/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _HEIGHT_FIELD_GEN_SUBDIV_H
#define _HEIGHT_FIELD_GEN_SUBDIV_H


#include "HeightField.h"
#include "MathGauss.h"


#define MENU_GEN_DIAMOND	"Diamond Square"
#define MENU_GEN_MIDPOINT	"Midpoint Subdivision"
#define MENU_GEN_OFFSET		"Offset Square"
#define MENU_GEN_RECURSIVE	"Recursive Subdivision"


/*
 *  HeightFieldGenSubdiv: generate a height field by subdivision. 
 */
class HeightFieldGenSubdiv
	{
	public:
				HeightFieldGenSubdiv (HeightField *HF);
				~HeightFieldGenSubdiv();

		// various generation modes 
		int		generate (int mode, int n, float scaleFactor, int seed);
		int		generateDiamond (int n, float scaleFactor, int seed);
		int		generateOffset (int n, float scaleFactor, int seed);
		int		generateMidpoint (int n, float scaleFactor, int seed);
		int		generateRecursive (int n, float scaleFactor, int seed);

		// utility functions
		void		setRequestedSize ();
		int		setPreferredSize (int n);

	private:
		
		void		processRSquare (int x1, int y1, int x2, int y2, float maxDelta);
		float		avgyvals (int i, int j, int strut, int dim);
		float		avgyvals2 (int i, int j, int strut, int dim);

		HeightField		*p_HF;
		MathGauss		*p_mGauss;
		int			d_prefSize,		// preferred (2^n) size
					d_reqSize;		// requested size 
		float			d_RscaleFactor;		// recursive scale factor
	};


#endif // _HEIGHT_FIELD_GEN_SUBDIV_H

