/* Terraform - (C) 1997-2000 Robert Gasch (r.gasch@chello.nl)
 *  - http://212.187.12.197/RNG/terraform/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "GlobalSanityCheck.h"
#include "GlobalDefs.h"


/* 
 *  bailout: print error and exit the programming unconditionally
 */ 
void SanityCheck::bailout (char *failedCondition, char *callerName)
{
	bailout ((!failedCondition), "failedCondition==NULL", "SanityCheck::bailout()");
	bailout ((!callerName), "callerName==NULL", "SanityCheck::bailout()");

	cerr 	<< "Sanity Check Failed: " << failedCondition 
		<< " in " << callerName << " ... Exiting\n"; 
	exit (1);
}


/* 
 *  bailout: print error and exit the program if expression is true. 
 */ 
void SanityCheck::bailout (bool expression, char *failedCondition, char *callerName)
{
	if (expression)
		bailout (failedCondition, callerName);
}


/* 
 *  warning: echo a warning unconditionally
 */ 
int SanityCheck::warning (char *failedCondition, char *callerName)
{
	bailout ((!failedCondition), "failedCondition==NULL", "SanityCheck::bailout()");
	bailout ((!callerName), "callerName==NULL", "SanityCheck::bailout()");

	if (callerName)
		cerr  << "\n** Warning: " << failedCondition << " in " 
		      << callerName << " !\n\n"; 
	else
		cerr  << "\n** Warning: " << failedCondition << " !\n\n"; 

	return TRUE;
}


/* 
 *  warning: echo a warning if expression is true. 
 */ 
int SanityCheck::warning (bool expression, char *failedCondition, char *callerName)
{
	if (expression)
		warning (failedCondition, callerName);

	return expression;
}
