/***************************************************************************
                          rtoolbutton.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rtoolbutton.cpp 1999/04/14 A. Mustun RibbonSoft
**
** Copyright (C) 1998/99 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qapplication.h>
#include <qpainter.h>
#include <qpointarray.h>

#include "rtoolbutton.h"


// Constructor:
//
RToolButton::RToolButton(QWidget* _parent, 
                         const char* _name,
                         bool _forwardRightClick)
:QToolButton(_parent, _name)
{
  forwardRightClick = _forwardRightClick;
}



// Destructor:
//
RToolButton::~RToolButton()
{

}



// Forward the right mouse click to parent widget:
//
//   Mouse Release event:
//
void 
RToolButton::mouseReleaseEvent(QMouseEvent* _ev)
{
  QToolButton::mouseReleaseEvent(_ev);
  
  if(forwardRightClick &&
     _ev->button()==RightButton) {
    qApp->notify(parentWidget(), _ev);
  }
}




/*!  Draws the edges and decoration of the button (pretty much
  nothing) and calls drawButtonLabel().

  \sa drawButtonLabel() QButton::paintEvent() */

void 
RToolButton::drawButton( QPainter * p )
{
  QPointArray a;
  a.setPoints( 3, 0, height()-1, 0, 0, width()-1, 0 );
    
  if (uses3D() || isOn()) {
    if (isOn()) {
      if ( style() == WindowsStyle ) {
        p->setBrush( QBrush(white,Dense4Pattern) );
        p->setPen( NoPen );
        p->setBackgroundMode( OpaqueMode );
        p->drawRect( 0,0, width(),height() );
        p->setBackgroundMode( TransparentMode );
      } 
      else {
        p->setBrush( colorGroup().mid() );
        p->setPen( NoPen );
        p->drawRect( 0,0, width(),height() );
      }
    }
    
    p->setPen( isDown() && !uses3D()
               ? colorGroup().light()
               : colorGroup().dark() );
    p->drawPolyline( a );
    a[1] = QPoint( width()-1, height()-1 );
    p->setPen( isDown() && !uses3D()
               ? colorGroup().dark()
               : colorGroup().light() );
    p->drawPolyline( a );
  }
  else {
    p->setPen( isDown() || isOn()
               ? colorGroup().dark()
               : colorGroup().light() );
    p->drawPolyline( a );
    a[1] = QPoint( width()-1, height()-1 );
    p->setPen( isDown() || isOn()
               ? colorGroup().light()
               : colorGroup().dark() );
    p->drawPolyline( a );
  }
  drawButtonLabel( p );

  if ( hasFocus() ) {
    if ( style() == WindowsStyle ) {
      p->drawWinFocusRect( 3, 3, width()-6, height()-6,
                           colorGroup().background() );
    } 
    else {
      p->setPen( black );
      p->drawRect( 3, 3, width()-6, height()-6 );
    }
  }
}




// EOF

