/***************************************************************************
                          rinputpanel.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rinputpanel.h 1998/09/20 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RINPUTPANEL_H
#define RINPUTPANEL_H

#include <qapplication.h>
#include <qlist.h>
//#include <qradiobutton.h>
//#include <qtoolbutton.h>

#include "rbuttongroup.h"
#include "rgraphic.h"
#include "rlabel.h"
#include "rlineedit.h"
#include "rwidget.h"
#include "rradiobutton.h"
#include "rtoolbutton.h"


class RPanelLabel : public RLabel
{
public:
  RPanelLabel(const QString & title, QWidget * parent=0, const char * name=0)
   : RLabel( title, parent, name )
  { }
protected:
  virtual void enterEvent(QEvent* _ev) {
    RLabel::enterEvent(_ev);
    qApp->notify(parentWidget(), _ev);
  }
};



class RPanelButtonGroup : public QButtonGroup
{
public:
  RPanelButtonGroup(const QString & title, QWidget * parent=0, const char * name=0)
   : QButtonGroup( title, parent, name )
  { }

protected:
  virtual void enterEvent(QEvent* _ev) {
    QButtonGroup::enterEvent(_ev);
    qApp->notify(parentWidget(), _ev);
  }
};



class RPanelLineEdit : public RLineEdit
{
public:
  RPanelLineEdit(QWidget * parent=0, const char * name=0)
   : RLineEdit( parent, name )
  { }
protected:
  virtual void enterEvent(QEvent* _ev) {
    RLineEdit::enterEvent(_ev);
    qApp->notify(parentWidget(), _ev);
  }
};



class RPanelToolButton : public RToolButton
{
public:
  RPanelToolButton(QWidget * parent=0, const char * name=0)
   : RToolButton( parent, name )
  { }
protected:
  virtual void enterEvent(QEvent* _ev) {
    RToolButton::enterEvent(_ev);
    qApp->notify(parentWidget(), _ev);
  }
};



class RPanelRadioButton : public RRadioButton
{
public:
  RPanelRadioButton(QWidget * parent=0, const char * name=0)
   : RRadioButton( parent, name )
  { }
protected:
  virtual void enterEvent(QEvent* _ev) {
    RRadioButton::enterEvent(_ev);
    qApp->notify(parentWidget(), _ev);
  }
};


class RInputPanel : public RWidget
{
  Q_OBJECT
public:
  RInputPanel(QWidget* _parent=0, 
         const char* _name=0,
         WFlags _f=0);
  ~RInputPanel();

  //void resizeChildren();

  void      setGraphic(RGraphic* _graphic);
  RGraphic* getGraphic() { return graphic; }

  void   newGroup(const char* _titel);
  void   endGroup();
  void   addLineEdit(const char* _label, bool _lockButton=false);
  //void   addCheckBox(QPixmap _icon);
  //void   addCheckBox(char* _label);
  void   addRadioButton(QPixmap _pixmap, const char* _qInfo=0, int _col=0, int _maxCol=1);

  void   adjustSize();

  void   setValue(int _ind, float _value);
  float  getValue(int _ind);
  void   setCheckedRadioButton(int _ind);
  int    isRadioButtonChecked(int _ind);

protected:
  //virtual void resizeEvent(QResizeEvent* _ev);
  virtual void enterEvent ( QEvent* _ev );
  virtual void leaveEvent ( QEvent* _ev );
  virtual void mouseMoveEvent ( QMouseEvent* _ev );
  virtual void keyReleaseEvent ( QKeyEvent * e );

public slots:
  void reset();

private slots:

  //! Lock value in first edit box
  /*
      Locks/unlocks the value in edit box n
      \param _ind index of input field to lock/unlock
   */
  void lock(int _ind);
  void updateIcons();
  void valueChanged(const QString&);
  void buttonChanged();

private:
  RGraphic* graphic;              // Pointer to graphic

  QList<RPanelToolButton> bLock;       // Lock buttons
  QList<RPanelLineEdit>   eInput;      // Input fields
  QList<RPanelLabel>      lLabel;      // Labels
  QList<RPanelButtonGroup> gGroup;     // Buttongroup for Radio Buttons
  QList<RPanelRadioButton> rButton;    // Radio Button List

  int posY;                       // Our "cursor" for appending objects
  int gap;                        // Gap between objects
  int bSize;                      // Button size
  int panelWidth;                 // Width of whole panel
  int panelHeight;                // Height of whole panel
  int group;                      // current group for Radiobuttons

};


#endif

// EOF




