////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// mark@danks.org
//
// Implementation file
//
//    Copyright (c) 1997-1999 Mark Danks.
//    For information on usage and redistribution, and for a DISCLAIMER OF ALL
//    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.
//
/////////////////////////////////////////////////////////

#include "camera.h"

#include <GL/glu.h>

#include "Base/GemMan.h"

CPPEXTERN_NEW(camera)

/////////////////////////////////////////////////////////
//
// camera
//
/////////////////////////////////////////////////////////
// Constructor
//
/////////////////////////////////////////////////////////
camera :: camera()
{
    // create the inlets
    inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_list, gensym("rotatelist"));
    inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_list, gensym("translatelist"));

    resetValues();
}

/////////////////////////////////////////////////////////
// Destructor
//
/////////////////////////////////////////////////////////
camera :: ~camera()
{ }

/////////////////////////////////////////////////////////
// resetMess
//
/////////////////////////////////////////////////////////
void camera :: resetMess()
{
    resetValues();
    render(NULL);
    setModified();
}

/////////////////////////////////////////////////////////
// resetValues
//
/////////////////////////////////////////////////////////
void camera :: resetValues()
{
    m_spin[0] = 0.0;
    m_spin[1] = m_spin[2] = 0.0;
    m_pos[0] = m_pos[1] = 0.0;
    m_pos[2] = -4.0;
}

/////////////////////////////////////////////////////////
// render
//
/////////////////////////////////////////////////////////
void camera :: render(GemState *)
{
    glLoadIdentity();
	glTranslatef(m_pos[0], m_pos[1], m_pos[2]);
	glRotatef(m_spin[0], 1.f, 0.f, 0.f);
	glRotatef(m_spin[1], 0.f, 1.f, 0.f);
	glRotatef(m_spin[2], 0.f, 0.f, 1.f);
}

/////////////////////////////////////////////////////////
// printMess
//
/////////////////////////////////////////////////////////
void camera :: printMess()
{
    post("rot vect: %f %f %f", m_spin[0], m_spin[1], m_spin[2]);
    post("trans vect: %f %f %f", m_pos[0], m_pos[1], m_pos[2]);
}

/////////////////////////////////////////////////////////
// rotVectorMess
//
/////////////////////////////////////////////////////////
void camera :: rotVectorMess(float x, float y, float z)
{
    m_spin[0] = x;
    m_spin[1] = y;
    m_spin[2] = z;
    setModified();
}

/////////////////////////////////////////////////////////
// transVectorMess
//
/////////////////////////////////////////////////////////
void camera :: transVectorMess(float x, float y, float z)
{
    m_pos[0] = x;
    m_pos[1] = y;
    m_pos[2] = z;
    setModified();
}

/////////////////////////////////////////////////////////
// static member functions
//
/////////////////////////////////////////////////////////
void camera :: obj_setupCallback(t_class *classPtr)
{
    class_addmethod(classPtr, (t_method)&camera::rotVectorMessCallback,
    	    gensym("rotatelist"), A_FLOAT, A_FLOAT, A_FLOAT, A_NULL);
    class_addmethod(classPtr, (t_method)&camera::transVectorMessCallback,
    	    gensym("translatelist"), A_FLOAT, A_FLOAT, A_FLOAT, A_NULL);
    class_addmethod(classPtr, (t_method)&camera::resetMessCallback,
    	    gensym("reset"), A_NULL);
    class_addmethod(classPtr, (t_method)&camera::printMessCallback,
    	    gensym("print"), A_NULL);
}
void camera :: rotVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z)
{
    GetMyClass(data)->rotVectorMess((float)x, (float)y, (float)z);
}
void camera :: transVectorMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z)
{
    GetMyClass(data)->transVectorMess((float)x, (float)y, (float)z);
}
void camera :: resetMessCallback(void *data)
{
    GetMyClass(data)->printMess();
}
void camera :: printMessCallback(void *data)
{
    GetMyClass(data)->resetMess();
}
