// copyright (c) 1997,1998 stephen f. white
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

import java.awt.*;

class FontChooser extends Dialog {
    static final int		fieldWidth = 10;

    private Choice	fontChoice = new Choice();
    private Checkbox	bold = new Checkbox("Bold");
    private Checkbox	italic = new Checkbox("Italic");
    private TextField	sizeText;
    private TextField	sampleText = new TextField("ABCabc");
    private Button	okButton = new Button("OK");
    private Button	cancelButton = new Button("Cancel");

    boolean	ok;
    Font	font;

    FontChooser(Frame parent, Font font) {
	super(parent, "Font Chooser", true);

        Panel   mainPanel = new Panel();
        Panel   samplePanel = new Panel();
        Panel   buttonPanel = new Panel();

	setLayout(new BorderLayout());
        setResizable(false);

	mainPanel.setLayout(new GridLayout(4, 2));

        mainPanel.add(new Label("Font:", Label.RIGHT));
	fontChoice = new Choice();
	String[] fonts = getToolkit().getFontList();
	for (int i = 0; i < fonts.length; i++) {
	    fontChoice.addItem(fonts[i]);
	}
        mainPanel.add(fontChoice);
	mainPanel.add(new Label(""));
	mainPanel.add(bold);
	mainPanel.add(new Label(""));
	mainPanel.add(italic);
        mainPanel.add(new Label("Size:", Label.RIGHT));
	sizeText = new TextField(Integer.toString(font.getSize()));
        mainPanel.add(sizeText);

	samplePanel.setLayout(new GridLayout(1, 2));

	samplePanel.add(new Label("Sample:", Label.RIGHT));
	sampleText.setEditable(false);
	samplePanel.add(sampleText);

	buttonPanel.add(okButton);
	buttonPanel.add(cancelButton);

        add("North", mainPanel);
        add("Center", samplePanel);
        add("South", buttonPanel);

	fontChoice.select(font.getName());
	bold.setState(font.isBold());
	italic.setState(font.isBold());

        pack();
    }

    private void refreshFont() {
	Font  newFont = new Font(fontChoice.getSelectedItem(),
			(bold.getState() ? Font.BOLD : 0) |
			(italic.getState() ? Font.ITALIC : 0),
			Integer.valueOf(sizeText.getText()).intValue());
	if (newFont != null) {
	    font = newFont;
	    sampleText.setFont(font);
	}
    }

    public boolean handleEvent(Event evt) {
        if (evt.target == okButton && evt.id == Event.ACTION_EVENT) {
	    ok = true;
            hide();
            return true;
        } else if (evt.target == cancelButton && evt.id == Event.ACTION_EVENT) {
	    ok = false;
            hide();
            return true;
	} else if (evt.target == fontChoice && evt.id == Event.ACTION_EVENT
		|| evt.target == bold && evt.id == Event.ACTION_EVENT
		|| evt.target == italic && evt.id == Event.ACTION_EVENT
		|| evt.target == sizeText && evt.id == Event.LOST_FOCUS) {
	    refreshFont();
	    return true;
        } else {
            return false;
        }
    }

    boolean doModal() {
	show();
	return ok;
    }
}
