#include "swserv.h"
  
 
 
/*
 *      Shut down the server
 */
int CmdShutdown(int condescriptor, char *arg)
{
        long object_num;
        char sndbuf[CS_DATA_MAX_LEN];
        char stringa[512];


        /* Get object_num, assumed valid. */
        object_num = connection[condescriptor]->object_num;


        /* Check if object's permission allows save. */
        if(xsw_object[object_num]->permission.uid > ACCESS_UID_SHUTDOWN)
        {
            sprintf(sndbuf,
                "shutdown: Requires access level %i: Permission denied.",
                ACCESS_UID_SHUTDOWN
            );
            NetSendLiveMessage(condescriptor, sndbuf);

            return(-1);
        }


        /* Log who requested shutdown. */
        sprintf(stringa,
            "%s: Requesting server shutdown.",
            DBGetFormalNameStr(connection[condescriptor]->object_num)
        );
        if(sysparm.log_general)
            LogAppendLineFormatted(fname.primary_log, stringa);


        /* Begin shutdown sequence. */
        SWServDoShutdown();


        return(0);
}       
