#include "swserv.h"
  
 
 
/*
 *      Check user ID and group ID of object.
 */
int CmdID(int condescriptor, char *arg)
{
        long object_num;
        char stringa[XSW_OBJ_NAME_MAX];
        char sndbuf[CS_DATA_MAX_LEN]; 
        
        
        /* Copy arg to stringa. */
        strncpy(stringa, arg, XSW_OBJ_NAME_MAX);
        stringa[XSW_OBJ_NAME_MAX - 1] = '\0';   
        StringStripSpaces(stringa);
        
        
        /* If no argument, assume connection's object. */
        if(strlen(stringa) < 1)
            object_num = connection[condescriptor]->object_num;
        else
            object_num = MatchObjectByName(stringa, XSW_OBJ_TYPE_PLAYER);
            
            
        /* Make sure object_num is valid. */
        if((object_num < 0) || (object_num >= total_objects))
        {
            sprintf(sndbuf, "%s: No such player.",
                stringa
            );
            NetSendLiveMessage(condescriptor, sndbuf);
  
            return(-1);
        }
  
 
        /* Print ID. */
        sprintf(sndbuf,
            "%s: uid: %i  gid: %i",
            DBGetFormalNameStr(object_num),
            xsw_object[object_num]->permission.uid,
            xsw_object[object_num]->permission.gid
        );
        NetSendLiveMessage(condescriptor, sndbuf);


        return(0);
}
