#ifndef TILESET_HH
#define TILESET_HH
#ifdef __GNUG__
#pragma interface
#endif
#define MaxInMatchClass 4
#include "vector.hh"
class Tile;
class SwDrawable;

class Tileset {
 protected:
  
  short _border;
  short _halfwidth;
  short _halfheight;
  
  short _ntiles;
  short _npictures;
  short _nmatches;
  Vector<short> _pictures;
  Vector<short> _matches;
  
  void initialize_ivory();
  
 public:
  
  Tileset(short ntiles, short npictures, short nmatches);
  Tileset(const char *);		// set up by name, e.g. "ivory"
  virtual ~Tileset()			{ }
  
  virtual bool ok() const = 0;
  
  short border() const			{ return _border; }
  short halfwidth() const		{ return _halfwidth; }
  short halfheight() const		{ return _halfheight; }
  short width() const			{ return _border + 2*_halfwidth; }
  short height() const			{ return _border + 2*_halfheight; }
  
  short ntiles() const			{ return _ntiles; }
  short npictures() const		{ return _npictures; }
  short nmatches() const		{ return _nmatches; }
  
  short picture(short tile) const	{ return _pictures[tile]; }
  short match(short tile) const		{ return _matches[tile]; }
  
  virtual void draw_normal(const Tile *, SwDrawable *, short x, short y) = 0;
  virtual void draw_lit(const Tile *, SwDrawable *, short x, short y) = 0;
  virtual void draw_obscured(const Tile *, SwDrawable *, short x, short y) = 0;
  
  // Information about the normal tileset, called `ivory'.
  static const char *ivory_picture_name(int);
  static const int IVORY_NTILES = 144;
  static const int IVORY_NPICTURES = 42;
  static const int IVORY_NMATCHES = 36;
  
};

/* Requirement:
   If x % 2 == 0 && x >= 0 && x < ntiles(), then match(x) == match(x + 1). */

#endif
