#include "xev.h"
#include <sys/stat.h>

unsigned long SearchColor(r,g,b)
     long r,g,b;
{
      int i;
      XColor d_color[256];
      unsigned long min,min_pixel;

      for(i = 0 ; i < 256 ; i++) {
            d_color[i].pixel = i;
      }
      
      XQueryColors(d,cmap,d_color , 256);

      for(i = 0 ; i < 256 ; i++) {
	    long x;

            x = NIJOU((r - (d_color[i].red >> 8)))
              + NIJOU((g - (d_color[i].green >> 8)))
                + NIJOU((b - (d_color[i].blue >> 8)));
            if(x < min) {
                  min = x;
                  min_pixel = i;
            }
      }
      
      return min_pixel;
}


void MakeColor(use_dcmap)
     int use_dcmap;
{
      int i;
      XColor col;
      
      if(use_dcmap)
	vis -> class = StaticColor;
      
      switch(vis -> class) {
	  case StaticColor:
	  case TrueColor:
	    cmap = DefaultColormap(d,scr);
	    ch_color = 0;
	    for(i = 0 ; i < COLORNUM ; i++)
	      {
		    col.red = rgb[i][0]*256;
		    col.green = rgb[i][1]*256;
		    col.blue = rgb[i][2]*256;
		    col.flags = DoRed|DoGreen|DoBlue;
		    if(XAllocColor(d,cmap,&col) == False)
		      pixel[i] = SearchColor(rgb[i][0],rgb[i][1],rgb[i][2]);
		    else 
		      pixel[i] = col.pixel;
	      }	    
	    break;
	  case PseudoColor:
	  case DirectColor:
	    
	    cmap = XCreateColormap(d,w,vis,AllocAll); 
	    XSetWindowColormap(d,w,cmap);
	    ch_color = 1;
	    for(i = 0 ; i < COLORNUM ; i++)
	      {
		    col.red = rgb[i][0]*256;
		    col.green = rgb[i][1]*256;
		    col.blue = rgb[i][2]*256;
		    col.flags = DoRed|DoGreen|DoBlue;
		    col.pixel = i;
		    pixel[i] = i;
		    XStoreColor(d,cmap,&col);
	      }    
	    cr_pixel = 41;
	    break;
	  default:
	    cmap = DefaultColormap(d,scr);
	    ch_color = 0;
	    break;
      }


}

void InitWin(use_dcmap)
     int use_dcmap;
{
      int i;
      XGCValues gcv;
      XSetWindowAttributes setwinatt;
      
      if((d = XOpenDisplay(NULL)) == NULL) {
	    fprintf(stderr,"Can't open Display!\n");
	    exit(1);
      }
      
      gcv.graphics_exposures =  True;
      scr = DefaultScreen(d);
      setwinatt.backing_store = Always;
      setwinatt.save_under = True;

      
      if((depth = DefaultDepth(d,scr)) < 8) {
	    fprintf(stderr,"sorry this Display don't support 8 bit color\n");
	    exit(1);
      }

      vis = DefaultVisual(d,scr);
      w = XCreateSimpleWindow(d,RootWindow(d,scr),100,100,
			      XSIZE+256,YSIZE,2,0,0);
      XChangeWindowAttributes(d,w, CWSaveUnder |
			      CWBackingStore,&setwinatt);
      font_gc = XCreateGC(d,w,0,0);
      back_gc = XCreateGC(d,w,GCGraphicsExposures,&gcv);
      fnt=XLoadFont(d,"-misc-*-*-*-*--14-*-*-*-*-*-*-1");
      XSetFont(d,font_gc,fnt);
      XStoreName(d,w,"xbat    ver 1.1");
      XMapWindow(d,w);
      XSelectInput(d, w, KeyPressMask | KeyReleaseMask | ExposureMask);
      MakeColor(use_dcmap);
      XSetForeground(d,back_gc,pixel[0]);
      XFillRectangle(d,w,back_gc,0,0,XSIZE+256,YSIZE);
      XFlush(d);
}

void LoadChar(fn,img,size)
     char *fn,*img;
     int size;
{
      FILE *fp;
      char t_pixel , *rl;
      unsigned char length;
      int c = 0;
      struct stat buf;

      if(stat(fn , &buf)) {
	    perror("LoadChar");
	    exit(1);
      }

      if((rl = (char *)malloc((int)buf.st_size)) == NULL) {
	    perror("LoadChar");
            exit(1);
      }
      
      if((fp = fopen(fn,"rb")) == NULL) {
            perror("fopen in Setchar");
            exit(errno);
      }
      
      if(fread(rl , (int)buf.st_size , 1 , fp) != 1) {
            perror("fread in SetChar");
            fclose(fp);
            exit(errno);
      }
      
      if(fclose(fp) == EOF) {
            perror("fclose in InputData ");
            exit(errno);
      }
      
      for(;buf.st_size > 0; buf.st_size-=2) {
            t_pixel = rl[c++];
            length = (unsigned char)rl[c++];
            for(;length > 0 ; length--) {
		  *img++ = t_pixel;
	    }
      }
      free(rl);
}

void DrawChar32(img , mask , gc ,pixmap)
     char *img,*mask;
     GC gc;
     Pixmap pixmap;
{
      int x,y;

      for(y = 0 ; y < CSIZE ; y++)
	for(x = 0 ; x < CSIZE ; x++) {
	      if(img[y*CSIZE+x] != 100) {
		    mask[y*4+x/8] |= (1<< (x%8));
		    XSetForeground(d,gc,
				   pixel[img[y*CSIZE+x]]);
		    XDrawPoint(d,pixmap,gc,x,y);
	      }
	}
}






