/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

/*
 * walls.h
 * 
 * (c) 1997 Jeremy Boulton under terms of the GNU General Public
 * License.
 * 
 */

#ifndef SNIPES_WALLS

#define SNIPES_WALLS


#include "snipes.h"


/*
 * Cell width is the wall-to-wall width:
 * 
 * |--- 12 ---|
 * |          |
 * +----------+
 * 
 * and addressing of the map begins at (0,0) in the upper
 * left hand corner.  Use normalize_x_coord() and
 * normalize_y_coord() to make sure that (x,y) references
 * are not outsize of the bounds of the maze.  i.e., you
 * use these to handle wrap-around.
 * 
 */


typedef struct wall_info {
  char *wall_array;
  
  int cell_width;
  int cell_height;

  long max_x_cell;
  long max_y_cell;

  long max_x;
  long max_y;
} wall_info;


long normalize_x_coord( wall_info *w, long x );
long normalize_y_coord( wall_info *w, long y );
void set_wall_segment( wall_info *wi, int x, int y, int type );
int init_walls( wall_info *w, int x, int y, int width, int height );
int close_walls( wall_info *w );
void draw_walls( wall_info *w, screen_coords *sc );


#endif // SNIPES_WALLS
