/*C*
 *
 * Hatman - The Game of Kings
 * Copyright (C) 1997 James Pharaoh & Timothy Fisken
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *C*/

#ifndef vgaxx_VgaBlur_h
#define vgaxx_VgaBlur_h

#include "Rect.h"
#include "Vga.h"
#include "../util/Collection.h"
#include <stdio.h>

//--------------------------------------------------------------------------------------------------------------------------------

class VgaBlur : public Vga
{
public:
 VgaBlur();
 ~VgaBlur();

 void blur2(class Rect r) { blurs2->add(new Rect(r)); }
 void keep() { copyTo(blurZone); }
 void keepAndUpdate() { keep(); update(); }
 Rect keep(class Rect r) { copyBoxTo(r, blurZone); return r; }
 Rect keepAndUpdate(class Rect r) { keep(r); update(r); return r; }
 Rect keepAndBlur1(class Rect r) { keep(r); blurs1->add(new Rect(r)); return r; }
 Rect restore(Rect r) { copyBoxFrom(blurZone, r); return r; }

 void wipeUpdate(int w, int d);

 void copyBlurs();
 void clearBlurs();

private:
 Collection<Rect> *blurs2, *blurs1;
 VgaContext* blurZone;
};

//--------------------------------------------------------------------------------------------------------------------------------

#endif
