/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "gnome_chess.h"
#include <ctype.h>
#include <sys/time.h>
#include <stdarg.h>
#include <signal.h>

#include "pro.h"
#include "child.h"

int start_child(char *cmd, char **arg, FILE **readpipe, FILE **writepipe,pid_t *childpid)
{
int pipe1[2],pipe2[2];

if((pipe(pipe1) <0) || (pipe(pipe2) < 0))
  {
    perror("pipe");
    exit(-1);
  }

if((*childpid = fork())<0)
  {
    perror("fork");
    exit(-1);
  }
else if (*childpid > 0) /* Parent */
  {
    close(pipe1[0]);
    close(pipe2[1]);

    *readpipe  = fdopen(pipe2[0],"r");
    *writepipe = fdopen(pipe1[1],"w");
    setlinebuf(*writepipe);

    return *childpid;
  }
else   /* Child */
  {
    close(pipe1[1]);
    close(pipe2[0]);

    dup2(pipe1[0],0);
    dup2(pipe2[1],1);

    close(pipe1[0]);
    close(pipe2[1]);

    if (execvp(cmd,arg) < 0)
      perror(cmd);
    _exit(1);
  }

  /* Should NEVER be reached */
  abort(); 
  return 0;
}

/* Kill Child */
int stop_child(pid_t childpid) {
	if (childpid && kill(childpid,SIGTERM) ) { 
		debug_print(DEBUG_NONE,"Failed to kill child!\n");
		return 1;
	}
	return 0;
}
