#include "rules.h"
#include "game.h"

#include "coordinate.h"

extern Coordinate direction[8];
extern Square board[BOARD_XSIZE][BOARD_YSIZE];

static int _win_test_dir(Coordinate *coor, Square s, int dir)
{
	int count;
	Coordinate ocoor[2];

	coordinate_copy(&ocoor[0], coor);
	coordinate_copy(&ocoor[1], coor);
	for(count = 1; !coordinate_add_with_clip(&ocoor[0], &direction[dir+4]); count++)
		if(ARRAY_COOR(board, ocoor[0]) != s)
			break;
	for(; !coordinate_add_with_clip(&ocoor[1], &direction[dir]); count++)
		if(ARRAY_COOR(board, ocoor[1]) != s)
			break;

	return (count >= 5);
}

int rules_win_test(Coordinate *c, Square s)
{
	int dir;

	for(dir=0; dir<4; dir++)
		if(_win_test_dir(c, s, dir))
			return 1;

	return 0;
}