/* GNU Chess 5.0 - universal board code
   Copyright (c) 1999 Free Software Foundation, Inc.

   GNU Chess is based on the two research programs 
   Cobalt by Chua Kong-Sian and Gazebo by Stuart Cracraft.

   GNU Chess is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   GNU Chess is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Chess; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Contact Info: 
     bug-gnu-chess@gnu.org
     cracraft@ai.mit.edu, cracraft@stanfordalumni.org, cracraft@earthlink.net
*/

#include <stdio.h>
#include <stdlib.h>
#include <pc.h>
#include <conio.h>
#include <unistd.h>
#include "svasync.h"

#define COM_PORT        COM1
#define BAUD_RATE       9600
#define COM_SETTINGS    (BITS_8 | STOP_1 | NO_PARITY)

int univ_init(void) {
	printf("Universal Initialization.  Type \"quit\" to exit.\n\n");

	if(SVAsyncInit( COM_PORT)) {
		printf("Error initalizing COM Port.\n");
		return(0);
	}
	
	SVAsyncFifoInit();

	SVAsyncSet(BAUD_RATE, COM_SETTINGS);
	SVAsyncHand(DTR | RTS);

	return (1);
}

int univ_read (char *p)
{
  int n;
  unsigned char c;

  n = SVAsyncInStat();
  if (n > 0 ) {		/* T, J, N, Me2e4, etc. */
    printf("Total of %d characters to read from Universal\n",n);
    while ((c = SVAsyncIn()) != 0) {
      if (c != '\015' && c != '\012' && c != 'M')
        *p++ = c;
    }
    *p = '\000';
    return(1);
  }
  return(0);
}

int univ_write (char *p)
{
  unsigned char *c;

  c = p;
  while (*c != '\0')
    SVAsyncOut(*c++);
  return(1);
}

void univ_loop (void)
{
	unsigned char c;

	for(;;) {
		/* If a character was recieved, send it to stdout */
		if( (c=SVAsyncIn()) != 0  ) {
			putchar(c);
		}
		/* You could set stdout to nonbuffered, or do a fflush
		   after every character is sent.  I chose to use stdout
		   instead of direct console i/o so it would support
		   ansi.sys */
		fflush(stdout);

		/* If a key has been pressed       */

		if(kbhit()) {
			c=getch();
			if(!c) {  /* Check for 'extended characters */
				c=getch();      /* Get the extended code */
				if( c==0x44)    /* Exit if it is a F10 */
					break;
			}
			else 
				SVAsyncOut(c);
		}



		/* If the buffer has a lot in it, drop RTS and empty the buffer */
		if( SVAsyncInStat()>4096) {
			SVAsyncHand(DTR);        /* Drop RTS */
			while(SVAsyncInStat()>0)
				putch(SVAsyncIn());
			SVAsyncHand(DTR | RTS);
		}
	}

	SVAsyncStop();
}

