/*
 * This program has been placed under the GNU General Public License.  There
 * is no warranty for this program.
 *
 * blackjack: (c) 1999 Stevie Strickland
 *
 * Updated 04 March 1999, Stev(i)e Baker :)
 * 	1.1
 * 	- cleaned up some of the code...
 * 	- now it tells you which card the dealer gets
 * 	- changed the print_card() function so that it says who got the card
 * 	  (either #defined by DEALER or PLAYER)
 * 	1.2
 * 	- fixed it so that it says "The Dealer" for face cards as well, I
 * 	  overlooked that one...  Now off to fix that grammar!
 * 	1.3
 * 	- it was also a little ambiguous about why the player wins, so I hacked
 * 	  it to let the user know that the dealer busted, when he did.
 * 	- the moment we've all been waiting for!  You can now abuse the dealer!
 * 	  Simply press 'p' for Punch when you get prompted to Stay or Hit.  Be
 * 	  careful not to kill him, though.
 * 	1.4
 * 	- reads from ~/.blackjackrc to see how much money you have.  The rc file
 * 	  is in the form "money = n" where n is the money (in dollars) that you
 * 	  possess.
 * 	- if you don't have an rc file, then one is created, and yer fronted
 * 	  $100...
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define FALSE_VAL 0
#define TRUE_VAL 1

#define HEARTS 0
#define SPADES 1
#define CLUBS 2
#define DIAMONDS 3

#define JACK 10
#define QUEEN 11
#define KING 12
#define ACE 0

#define NUM_SUITS 4
#define NUM_VALUES 13
#define NUM_CARDS 52

/* (sbaker) These are for my print_card() hack. */
#define PLAYER "You"
#define DEALER "The Dealer"

/* (sbaker) Use the define for readability. */
static int deck[NUM_CARDS];
static int cards_used = 0;

static void init_random(){ 
  time_t *t;

  if((t = malloc(sizeof(time_t))) == NULL) {
    printf("Error initalizing random number generator!\n");
    exit(EXIT_FAILURE);
  }

  (void)time(t);

  srand((unsigned int)*t);
  (void)sleep(1);
  free(t);
}

static void init_deck() {
  int index;

  for(index = 0; index < NUM_CARDS; index++)
    deck[index] = 0;
}

static int get_suit(void) {
  int suit;

  suit = (int)(NUM_SUITS * (rand()/(RAND_MAX + 1.0)));

  return suit;
}

static int get_value(void) {
  int value;

  value = (int)(NUM_VALUES * (rand()/(RAND_MAX + 1.0)));

  return value;
}

/* (sbaker) get the user's money from their rc file...  If they don't have an
 * rcfile, create one, and spot them $100
 */
int get_money()
{
	char rcfilename[64];
	char s1[16];
	int i1;
	int money;
	FILE *rcfile;

	memset(rcfilename, (int)NULL, 64);
	strcat(rcfilename, getenv("HOME"));
	strcat(rcfilename, "/.blackjackrc");

	rcfile = fopen(rcfilename, "r");

	if (rcfile == NULL) {
		puts(rcfilename);
		printf(".blackjackrc not found, creating.\n");
		printf("Giving you $100 to start.\n");
		
		rcfile = fopen(rcfilename, "w");
		fprintf(rcfile, "money = 100");
		
		printf("Exiting, please restart blackjack.\n");

		exit(0);
	}
	
	fscanf(rcfile, "%s = %d", s1, &i1);

	if (strcmp(s1, "money")) {
		printf("Invalid .blackjackrc.\n");
		exit(1);
	} else {
		money = i1;
	}

	return money;
}

/* (sbaker) added char *name so that the dealer can have cards too */
static void print_card(char *name, int value, int suit) {

  char *suit_name, *face_name, *verb;
  int index;

  if((verb = malloc(5 * sizeof(char))) == NULL) {
    printf("Error in allocating verb\n");
    exit(EXIT_FAILURE);
  }
  if(strcmp(name, "You") == 0) (void)strcpy(verb, "have");
  else (void)strcpy(verb, "has");
  
  if((suit_name = malloc(15 * sizeof(char))) == NULL) {
    printf("Error in allocating suit name\n");
    exit(EXIT_FAILURE);
  }
  if((face_name = malloc(15 * sizeof(char))) == NULL) {
    printf("Error in allocating face name\n");
    free(suit_name);
    exit(EXIT_FAILURE);
  }

  for(index = 0; index < 15; index++) {
    suit_name[index] = '\0';
    face_name[index] = '\0';
  }

  switch (suit) {
  case HEARTS:   (void)strcpy(suit_name, "Hearts"); break;
  case SPADES:   (void)strcpy(suit_name, "Spades"); break;
  case CLUBS:    (void)strcpy(suit_name, "Clubs"); break;
  case DIAMONDS: (void)strcpy(suit_name, "Diamonds"); break;
  default: (void)strcpy(suit_name, "Hmmm... error?");
  }

  if((value > ACE) && (value < JACK)) 
    printf("%s %s the %d of %s.\n", name, verb, value + 1, suit_name);
  else{
    switch(value) {
    case JACK:  (void)strcpy(face_name, "Jack"); break;
    case QUEEN: (void)strcpy(face_name, "Queen"); break;
    case KING:  (void)strcpy(face_name, "King"); break;
    case ACE:   (void)strcpy(face_name, "Ace"); break;
    default: (void)strcpy(face_name, "Hmmm... error?");
    }
    printf("%s %s the %s of %s.\n", name, verb, face_name, suit_name);
  }
  free(suit_name);
  free(face_name);
}

static int valid_card(int value, int suit) {

  if(deck[NUM_VALUES * suit + value] == 1)
    return FALSE_VAL;
  else {
    deck[NUM_VALUES * suit + value] == 1;
    return TRUE_VAL;
  }
}

static int score_card(int value) {
  
  switch(value){
  case JACK:
  case QUEEN:
  case KING:
    return 10;
  case ACE:
    return 11;
  }
  return(value + 1);
}

static int dealer_score() {
  int dealer_count = 0, dealer_scoring = 0;
  int suit, value, aces = 0;
  
  while(TRUE_VAL) {
    if(cards_used > 40) 
      init_deck();
    suit = get_suit();
    value = get_value();
    if(valid_card(value, suit)) {
      cards_used++;
      dealer_count++;
      print_card(DEALER, value, suit);
      if(score_card(value) == 11)
        aces++;
      dealer_scoring += score_card(value);
      while((aces > 0) && (dealer_scoring > 21)) {
        dealer_scoring -= 10;
        aces--;
      }
      if(dealer_scoring > 16)
        break;
    }
  }
  return dealer_scoring;
}

/* For when that bastahd dealer won't quit cheating! */
void punch_dealer() {
	static int punch_count = 0;
	
	if (punch_count < 1) {
		printf("Oh my lord!  %s just punched %s right in the mouth!\n",
				PLAYER, DEALER);
		printf("Maybe he'll give you a better card now...\n");
		punch_count++;
	} else {
		printf("%s punched %s again!\n", PLAYER, DEALER);
		printf("...\n");
		printf("Nice going, buster, you killed him.  Now you don't ");
		printf("have anyone to play with.\n");
		exit(0);
	}
}
		
int main() {
  int current_score = 0, natural = FALSE_VAL, aces = 0;
  int suit, value, cards_in_hand = 0, dealer = 0; 
  int cash;
  char rcfilename[64];
  FILE *rcfile;
  unsigned char choice;

  /* (sbaker) get the user's money */
  cash = get_money();
 
  init_random();
  
  printf("Welcome to my Blackjack game!\n");

  while(TRUE_VAL) {
 
    printf("Would you like to play? (Y/n) ");
    /* (sbaker) this should be getchar(), will fix later */
    choice = (unsigned char)getc(stdin);
    while((char)getc(stdin) != '\n');
    
    if(((char)tolower((int)choice) == 'n') || (cash < 5)) {
      printf("Too bad...\n");
      break;
    } else {
	    printf("You have $%d!\n", cash);
      cash -= 5;
      while(TRUE_VAL) {
	if(cards_used > 40)
	  init_deck;
	suit = get_suit();
	value = get_value();

	if(valid_card(value, suit)) {
	  cards_used++;
	  cards_in_hand++;
	  print_card(PLAYER, value, suit);
	  if(score_card(value) == 11)
            aces++;
	  current_score += score_card(value);
	  if((cards_in_hand == 2) && (current_score == 21)) {
            natural = TRUE_VAL;
            break;
	  }
	  while((aces > 0) && (current_score > 21)) {
	    current_score -= 10;
	    aces--;
	  }
	  if(current_score >= 21)
	    break;
	  if(cards_in_hand >= 2) {
	    printf("Would you like to (S)tay or (h)it? ");
	    choice = (unsigned char)getc(stdin);
            while((char)getc(stdin) != '\n');
	    if((char)tolower((int)choice) == 's') {
              break;
	    } else if ((char)tolower((int)choice) == 'p') {
		    /* I _had_ to do something weird...  Just had to. */
		    punch_dealer();
	    }
	  }
	}
      }
      dealer = dealer_score();
      if(current_score > 21)
	printf("Too bad, you busted!  You only have $%d...\n", cash);
      else if(natural) {
	cash += 15;
	printf("Congratulations!  You got 21! You now have $%d!\n", cash);
      } else if((dealer > 21) || (current_score > dealer)) {
	cash += 10;
	printf("%s busted!  You now have $%d!\n", DEALER, cash);
      } else if(current_score == dealer) {
        cash += 5;
        printf("You and the dealer tied!  You now have $%d!\n", cash);
      } else 
        printf("Sorry, the dealer won with %d! $%d left...\n", dealer, cash);
      current_score = 0;
      dealer = 0;
      cards_in_hand = 0;
      aces = 0;
    }
  }

/* BIG HULKING BUG (fixed) HERE... */
  	
  	/* How stupid of me...  Forgot to update how much money the player now
	 * has... 
	 */
	memset(rcfilename, (int)NULL, 64);
	strcat(rcfilename, getenv("HOME"));
	strcat(rcfilename, "/.blackjackrc");
  	
	rcfile = fopen(rcfilename, "w");
	
	fprintf(rcfile, "money = %d", cash);
	
	fclose(rcfile);
	
	
  return EXIT_SUCCESS;
}
