#ifndef IIRSCRAM_STRING_LITERAL_HH
#define IIRSCRAM_STRING_LITERAL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_StringLiteral.hh,v 1.2 1999/03/09 20:56:48 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_StringLiteral.hh"
template <class type> class set;

class IIRScram_StringLiteral : public IIRBase_StringLiteral {
public:
  void _publish_cc();
  void _publish_cc_string();
  virtual void _publish_cc_state_object_init();
  void _publish_cc_initialization_value();
  void _publish_cc_universal_value();
  void _publish_cc_condition();
  void _publish_cc_bounds();
  void _publish_cc_range();
  void _publish_cc_headers();

  void _publish_cc_without_quotes();
  void _publish_cc_function_name();
  void _convert_function_name(ostrstream &, IIR_Boolean _is_unary_operator = FALSE);
  void _publish_cc_variable_name();

  IIR_Boolean _is_string_literal(){ return TRUE; }
  IIR_Boolean _is_array_type(){ return TRUE; }

  void _type_check( set<IIR_TypeDefinition> * );

  set<IIR_TypeDefinition> *
  _get_rval_set( IIR_Boolean (IIR::*constraint_function)() = 0 );
  IIR *_clone();

protected:
  IIRScram_StringLiteral();
  virtual ~IIRScram_StringLiteral() = 0;

private:
};
#endif
