// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan ramanan@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ScalarTypeDefinition.cc,v 1.4 1999/09/30 21:13:23 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include <strstream.h>
#include "IIR_Declaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_RangeTypeDefinition.hh"
#include "IIR_LeftAttribute.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_EnumerationTypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "StandardPackage.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_ScalarTypeDefinition::~IIRScram_ScalarTypeDefinition() {}

IIR*
IIRScram_ScalarTypeDefinition::_get_direction() {
  return get_direction();
}

IIR*
IIRScram_ScalarTypeDefinition::_get_base_type_left() {
  if(get_left() != NULL) {
    return get_left();
  } else if(_get_base_type() != NULL) {
    return _get_base_type()->_get_base_type_left();
  } else {
    return NULL;
  }
}
    
IIR*
IIRScram_ScalarTypeDefinition::_get_base_type_direction() {
  if(get_direction() != NULL) {
    return get_direction();
  } else if(_get_base_type() != NULL) {
    return _get_base_type()->_get_base_type_direction();
  } else {
    return NULL;
  }
}
    
IIR*
IIRScram_ScalarTypeDefinition::_get_base_type_right() {
  if(get_right() != NULL) {
    return get_right();
  } else if(_get_base_type() != NULL) {
    return _get_base_type()->_get_base_type_right();
  } else {
    return NULL;
  }
}
    
IIR_TypeDefinition*
IIRScram_ScalarTypeDefinition::_get_base_type() {

  if(_is_enumeration_type() == TRUE) {
    return get_base_type();
  }
  else if(_is_subtype_decl() == TRUE) {
    return _get_type_mark();
  }
  else if(_is_anonymous() == TRUE) {
    if(_get_type_mark() != NULL) {
      return _get_type_mark();
    }
    else {
      return get_base_type();
    }
  }
  else {
    return get_base_type();
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out){
  ASSERT(get_left() != NULL && get_left()->_is_resolved());
  ASSERT(get_direction() != NULL && get_direction()->_is_resolved());
  ASSERT(get_right() != NULL && get_right()->_is_resolved());

  if( _get_attribute() != NULL )  {
    _vhdl_out << " range ";
    _get_attribute()->_publish_vhdl( _vhdl_out );
  }
  else{
    if (_get_resolution_function() != NULL) {
      _get_resolution_function()->get_declarator()->_publish_vhdl(_vhdl_out);
      _vhdl_out << " ";
    }
    
    if (_get_type_mark() != NULL) {
      _get_type_mark()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
      
      if (_get_type_mark()->_is_iir_scalar_type_definition() == TRUE) {
	IIR_ScalarTypeDefinition *as_scalar = (IIR_ScalarTypeDefinition *)_get_type_mark();
	if( get_left() == as_scalar->get_left() &&
	    get_right() == as_scalar->get_right() &&
	    get_direction() == as_scalar->get_direction() ){
	  // If none of the fields is different  don't bother with ranges
	  // just quit;
	  return;
	}
      }
    }
    
    _vhdl_out << " range ";
    get_left()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
    if ( _is_ascending_range() == TRUE ) {
      _vhdl_out << " to ";
    }
    else {
      _vhdl_out << " downto ";
    }

    _vhdl_out << " ";
    get_right()->_publish_vhdl(_vhdl_out);
  }
}
    
void 
IIRScram_ScalarTypeDefinition::_publish_vhdl(ostream &_vhdl_out){
  if( _get_attribute() != NULL ){
    _get_attribute()->_publish_vhdl( _vhdl_out );
  }
  else{
    if(_is_anonymous() == TRUE) {
      if( _get_type_mark() != NULL ){
	ASSERT( _get_type_mark()->_is_iir_scalar_type_definition() == TRUE );
	IIR_ScalarTypeDefinition *as_scalar = (IIR_ScalarTypeDefinition *)_get_type_mark();
	_get_type_mark()->_publish_vhdl( _vhdl_out );
	if( get_left() != as_scalar->get_left() ||
	    get_right() != as_scalar->get_right() ||
	    get_direction() != as_scalar->get_direction() ){
	  // If one of the fields is different, print the range.  otherwise,
	  // don't bother.
	 
	  _vhdl_out << " range ";
	  _publish_vhdl_range( _vhdl_out );
	}
      }
      else{
	_publish_vhdl_range( _vhdl_out );
      }
    } 
    else {
      ASSERT(_get_declaration()->_is_resolved() == TRUE);
      _get_declaration()->_publish_vhdl(_vhdl_out);
    }
  }
}

void
IIRScram_ScalarTypeDefinition::_publish_vhdl_index(ostream &_vhdl_out) {
  if ((_is_iir_type_definition() == TRUE) && (_is_anonymous() == FALSE))  {
    _get_declaration()->_get_declarator()->_publish_vhdl(_vhdl_out);
  }
  else {
    if (_get_type_mark() != NULL) {
      _get_type_mark()->_publish_vhdl(_vhdl_out);
      _vhdl_out << " range ";
    }
    _publish_vhdl_range(_vhdl_out);
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_vhdl_range(ostream &_vhdl_out) {

  if (_get_attribute() != NULL) {
    _get_attribute()->_publish_vhdl(_vhdl_out);
  } else if (get_left() == NULL) {
    ASSERT(get_right() == NULL);
    ASSERT(get_direction() == NULL);
    _vhdl_out << "<>";
  } else {
    ASSERT(get_right() != NULL);
    ASSERT(get_direction() != NULL);
    get_left()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
    if( _is_ascending_range() == TRUE ){
      _vhdl_out << "to";
    } else {
      _vhdl_out << "downto";
    }
    _vhdl_out << " ";
    get_right()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_vhdl_constraint(ostream &_vhdl_out) {
  _report_undefined_scram_fn("_publish_vhdl_constraint(ostream &)");
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_left() {
  if(_get_attribute() == NULL) {
    ASSERT(get_left() != NULL);
    get_left()->_publish_cc();
  } else {
    _get_attribute()->_publish_cc();
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_right() {
  if(_get_attribute() == NULL) {
    ASSERT(get_right() != NULL);
    get_right()->_publish_cc();
  } else {
    _get_attribute()->_publish_cc();
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_universal_left() {
  if(_get_attribute() == NULL) {
    ASSERT(get_left() != NULL);
    get_left()->_publish_cc_universal_value();
  } else {
    _get_attribute()->_publish_cc_universal_left();
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_universal_right() {
  if(_get_attribute() == NULL) {
    ASSERT(get_right() != NULL);
    get_right()->_publish_cc_universal_value();
  } else { 
    _get_attribute()->_publish_cc_universal_right();
  }
}

IIR_Boolean
IIRScram_ScalarTypeDefinition::_is_bit_type() {
  if(_get_declaration() != NULL) {
    return ( 0 ==IIR_TextLiteral::_cmp(_get_declaration()->get_declarator(), "bit"));
  }
  else {
    return FALSE;
  }
}

IIR_Boolean
IIRScram_ScalarTypeDefinition::_is_boolean_type() {
  if(_get_declaration() != NULL) {
    return ( 0 ==IIR_TextLiteral::_cmp(_get_declaration()->get_declarator(), "boolean"));
  }
  else {
    return FALSE;
  }
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_range() {
  if(get_left() != NULL) {
    ASSERT(get_left()->_is_resolved() == TRUE);
    ASSERT(get_direction() != NULL);
    ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);
    ASSERT(get_right() != NULL);
    ASSERT(get_right()->_is_resolved() == TRUE);

    get_left()->_publish_cc_value();
    _cc_out << ", ";
    ((IIR_EnumerationLiteral *)get_direction())->_publish_cc_direction();
    _cc_out << ", ";
    get_right()->_publish_cc_value();
  } else {
    if (_get_attribute() == NULL) {
      ASSERT (_get_base_type() != NULL);
      ASSERT (_get_base_type()->_is_iir_scalar_type_definition() == TRUE);
      IIR_ScalarTypeDefinition *baseType = (IIR_ScalarTypeDefinition *) _get_base_type();
      ASSERT (baseType->get_left()->_is_resolved() == TRUE);
      ASSERT (baseType->get_direction() != NULL);
      ASSERT (baseType->get_direction()->get_kind() ==IIR_ENUMERATION_LITERAL);
      ASSERT (baseType->get_right() != NULL);
      ASSERT (baseType->get_right()->_is_resolved() == TRUE);
      
      baseType->get_left()->_publish_cc_value();
      _cc_out << ", ";
      ((IIR_EnumerationLiteral *) baseType->get_direction())->_publish_cc_direction();
      _cc_out << ", ";
      baseType->get_right()->_publish_cc_value();
    }
    else {
      ASSERT(_get_attribute() != NULL);
      ASSERT(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE);
      _get_attribute()->_publish_cc_range();
    }
  }
}

IIR_Boolean
IIRScram_ScalarTypeDefinition::_is_ascending_range() {
  if( get_direction() == NULL ){
    ostrstream err;
    err << "Get direction called on type that has no direction." << ends;
    report_error( this, err, WARNING );

    return FALSE;
  }
  else{
    return get_direction()->_is_ascending_range();
  }
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_init_signal() {
  if(((IIR_Declaration*)_current_publish_node)->_is_implicit_declaration() == true) {
    _publish_cc_init_implicit_signal(); 
  }
  else {
   _publish_cc_init_explicit_signal(); 
  }
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_composite_init() {
  _cc_out << "{\n";
  
  _cc_out << "Variable<";
  _publish_cc_universal_type();
  _cc_out << ">* variable = (Variable<"; 
  _publish_cc_universal_type();
  //_cc_out << ">*) (*(ScalarType*)&this->" << _current_publish_name << ")"
  //  << ".object;\n";
  _cc_out << ">*) (*(ScalarType*)&" << _current_publish_name << ")"
	  << ".object;\n";
  
  _cc_out << "  variable->val = ";
  _publish_cc_universal_left();
  _cc_out << ";\n}\n";
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_init_implicit_signal() {
  _cc_out << "  ImplicitSignal<";
  this->_publish_cc_universal_type();
  _cc_out << ">* signal = (ImplicitSignal<"; 
  this->_publish_cc_universal_type();
  ASSERT(_current_publish_name != NULL);
  _cc_out << ">*) (*(ScalarType*)&this->" << _current_publish_name << ")"
	  << ".object;\n";

  // I expect _current_another_name to be set to the string representation
  // of the signal's netinfo structure when I get here.  It is set in
  // IIRScram_SignalDeclaration::_publish_cc_init_signal().
  ASSERT(_current_another_name != NULL);

  _cc_out << "  signal->type =";
	  
  //  _cc_out << " IMPLICIT;\n";
  ((IIR_Declaration*)_current_publish_node)->_get_attribute_name()->_publish_cc_sigtype();
  //_cc_out << "  signal->sensitive = true;\n";
  // XXX not all signals are sensitive; this will be slightly inefficient

  //Implicit Signals do not need source information : Ramanan
  //  _cc_out << "  signal->source = ";
  //((IIR_Declaration*)_current_publish_node)->_get_attribute_name()->_publish_cc_init_val();
  //_cc_out << ";\n";

  _cc_out << "  signal->drvVal = ";
  ((IIR_Declaration*)_current_publish_node)->_get_attribute_name()->_publish_cc_init_val();
  _cc_out << ";\n";

  _cc_out << "  signal->effVal = ";
  ((IIR_Declaration*)_current_publish_node)->_get_attribute_name()->_publish_cc_init_val();
  _cc_out << ";\n";

  _cc_out << "  signal->name = \"" << _current_publish_name << "\";\n";

  //  ((IIR_Declaration*)_current_publish_node)->_get_attribute_name()->_publish_cc_necessary_decl_init();
  _cc_out << "\n";
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_init_explicit_signal() {
  // NOTE : The values set in _current_publish_name and _current_another_name
  //        are important. Care must be taken to set these names correctly.
  //        Incase of publishing for RecordTypes, the function expects
  //        _current_publish_name to point to the record name and
  //        _current_another_name to point to the field name.
  //
  //        When publishing scalar types, the variable _current_publish_name
  //        should be set to the scalar variable name while
  //        _current_another_name must be set to NULL

  _cc_out << "  Signal<";
  this->_publish_cc_universal_type();
  _cc_out << ">* signal = (Signal<"; 
  this->_publish_cc_universal_type();
  _cc_out << ">*) (*(ScalarType*)&this->" << _current_publish_name;
  
  _cc_out << ")"  << ".object;\n";

  //  _cc_out << "  signal->sensitive = true;\n";
  // XXX not all signals are sensitive; this will be slightly inefficient

  if(_current_publish_node->_is_signal()) {
    if (_current_publish_node->get_value() == NULL) {
      _cc_out << "  signal->drvVal = ";
      this->_publish_cc_universal_left();
      
      _cc_out << ";\n";
      _cc_out << "  signal->effVal = ";
      this->_publish_cc_universal_left();
      _cc_out << ";\n";
    }
  }

  _cc_out << "  signal->name = \"" << _current_publish_name << "\";\n";
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_init_last_event() {
  _cc_out << _current_publish_name << ";\n";
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_class_last_event() {
  //Nothing to be done here
  //May be used later, once the way implicit signal attributes are fixed
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_class_event() {
  //Nothing to be done here
  //May be used later, once the way implicit signal attributes are fixed
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_universal_type() {
  _report_undefined_scram_fn("_publish_cc_universal_type()");
}

ostream &
IIRScram_ScalarTypeDefinition::_print( ostream &os ){
  if( get_left() == NULL && get_right() == NULL && get_direction() == NULL ){
    // This is an unconstrained type.
    if( get_base_type() != NULL ){
      os << *get_base_type()->_get_declarator() << " range <> ";
    }
    else{
      os << *_get_declarator() << " range <> ";
    }
  }
  else{
    if( get_left() != NULL ){
      os << *get_left();
    }
    
    if( _is_ascending_range() == TRUE ){
      os << " to ";
    }
    else{
      os << " downto ";
    }
    if( get_right() != NULL ){
      os << *get_right();
    }
  }
  return os;
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_init_val() {
  _publish_cc();
  _cc_out << "(ObjectBase::VARIABLE, ";
  _publish_cc_universal_left();
  _cc_out << ")";
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_signal_value_left() {

  if(_current_publish_node->_is_signal()) {
    if (_current_publish_node->get_value() == NULL) {
      this->_publish_cc_universal_left();
    }
    else {
      _current_publish_node->get_value()->_publish_cc_universal_value();
    }
  }
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_decl_type_attributes() {
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_define_type_attributes() {
  //  _publish_cc_attribute_left();
  //_publish_cc_attribute_right();
  // _publish_cc_attribute_high();
  //_publish_cc_attribute_low();
  //_publish_cc_attribute_ascending();
  //_publish_cc_attribute_image();
  //_publish_cc_attribute_value();

  //if(_is_discrete_type() || _is_physical_type()) {
  //  _publish_cc_attribute_pos();
  // _publish_cc_attribute_val();
  //_publish_cc_attribute_succ();
  //_publish_cc_attribute_pred();
  //_publish_cc_attribute_leftof();
  //_publish_cc_attribute_rightof();
  //}
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_left() {
  _cc_out << "const ";
  _publish_cc_kernel_type();
  _cc_out << endl;
  _publish_cc_type_name();  
  _cc_out << "::LEFT(){" << endl
	  << "return ";
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_get_attribute() != NULL){
      if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
      }
      if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
      }
    }
    else {
    _publish_cc_universal_left();
    }
    _cc_out << ")";
  }
  else {
    _publish_cc_kernel_type();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_get_attribute() != NULL){
      if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
      }
      if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
      }
    }
    else {
    get_left()->_publish_cc_value();
    }
    _cc_out << ")";
  }
  _cc_out << ";" << endl
	  << "}" << endl;
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_right() {
  _cc_out << "const ";
  _publish_cc_kernel_type();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::RIGHT(){" << endl
	  << "return ";
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_get_attribute() != NULL){
      if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
      }
      if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
      }
    }
    else{
    _publish_cc_universal_right();
    }
    _cc_out << ")";
  }
  else {
    _publish_cc_kernel_type();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_get_attribute() != NULL){
      if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
      }
      if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
      }
    }
    else{
    get_right()->_publish_cc_value();
    }
    _cc_out << ")";
  }
  _cc_out << ";" << endl
	  << "}" << endl;

}


void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_high() {
  _cc_out << "const ";
  _publish_cc_kernel_type();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::HIGH(){" << endl;
  _cc_out << "return ";
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_is_ascending_range()) {
      if(_get_attribute() != NULL){
	if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
	}
	if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
	}
      }
      else{
      _publish_cc_universal_right();
      }
    } else {
      if(_get_attribute() != NULL){
	if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
	}
	if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
	}
      }
      else {
      _publish_cc_universal_left();
      }
    }
    _cc_out << ")";
  }
  else {
    if(_is_ascending_range()) {
      _publish_cc_kernel_type();
      _cc_out << "(ObjectBase::VARIABLE, ";
      get_right()->_publish_cc_value();
      _cc_out << ")";
    } else {
      _publish_cc_kernel_type();
      _cc_out << "(ObjectBase::VARIABLE, ";
      get_left()->_publish_cc_value();
      _cc_out << ")";
    }
  }
  _cc_out << ";" << endl
	  << "}" << endl;
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_low() {
  _cc_out << "const ";
  _publish_cc_kernel_type();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::LOW(){" << endl;
  _cc_out << "return ";
  if(_is_subtype_decl() == TRUE) {
    _publish_cc_type_name();
    _cc_out << "(ObjectBase::VARIABLE, ";
    if(_is_ascending_range()) {
      if(_get_attribute() != NULL){
	if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
	}
	if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
	}
      }
      else {
      _publish_cc_universal_left();
      }
    } else {
      if(_get_attribute() != NULL){
	if(_get_attribute()->get_kind() == IIR_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_right();
	}
	if(_get_attribute()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE){
	  ((IIRScram_Attribute*)_get_attribute())->_publish_cc_universal_left();
	}
      }
      else {
      _publish_cc_universal_right();
      }
    }
    _cc_out << ")";
  }
  else {
    if(_is_ascending_range()) {
      _publish_cc_kernel_type();
      _cc_out << "(ObjectBase::VARIABLE, ";
      get_left()->_publish_cc_value();
      _cc_out << ")";
    } else {
      _publish_cc_kernel_type();
      _cc_out << "(ObjectBase::VARIABLE, ";
      get_right()->_publish_cc_value();
      _cc_out << ")";
    }
  }
  _cc_out << ";" << endl
	  << "}" << endl;
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_ascending() {
  _cc_out << "const EnumerationType" << endl;
  _publish_cc_type_name();
  _cc_out << "::ASCENDING(){" << endl;
  _cc_out << "return EnumerationType(ObjectBase::VARIABLE,";
  if(_is_ascending_range() == TRUE) {
    _cc_out << "true";
  }
  else {
    _cc_out << "false";
  }
  _cc_out << ", SavantbooleanType_info);" << endl
	  << "}" << endl;
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_image() {
  _report_undefined_scram_fn("_publish_cc_attribute_image()");
}


void
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_value() {
  _report_undefined_scram_fn("_publish_cc_attribute_value()");
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_pos() {
  _cc_out << "const IntegerType" << endl;
  _publish_cc_type_name();
  _cc_out << "::POS(";
  _publish_cc_base_type_name();
  _cc_out << "& x) {" << endl;

  if(_is_subtype_decl() == TRUE) {
    if(_is_enumeration_type() == TRUE) {
      _cc_out << "return ";
      get_base_type()->_publish_cc();
      _cc_out << "::POS(x);" << endl;
    }
    else {
      _cc_out << "return ";
      ASSERT(_get_type_mark() != NULL);
      _get_type_mark()->_publish_cc_type_name();
      _cc_out << "::POS(x);" << endl;
    }
  } else {
    _publish_cc_universal_type();
    _cc_out << " val;" << endl
	    << " val = x.getObject()->readVal();" << endl;

    if(_get_bottom_base_type()->_is_integer_type() != true){
      if (_is_physical_type() != true) {
	if(_is_ascending_range()) {
	  _cc_out << "val = val - (";
	  _publish_cc_universal_type();
	  _cc_out << "(";
	  get_left()->_publish_cc_value();
	  _cc_out << "))";
	  _cc_out << ";\n";
	}
	else {
	  _cc_out << "val = (";
	  _publish_cc_universal_type();
	  _cc_out << "(";
	  get_left()->_publish_cc_value();
	  _cc_out << "))";
	  _cc_out << " - val;\n";
	}
      }
    }
    _cc_out << "return IntegerType(ObjectBase::VARIABLE, val, SavantintegerType_info);" << endl;
  }
  _cc_out << "}" << endl;
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_range_check() {
  if(_is_ascending_range()) {
    _cc_out << "(val >= (";
    _publish_cc_universal_type();
    _cc_out << "(";
    get_left()->_publish_cc_value();
    _cc_out << "))";
    _cc_out << " && val <= (";
    _publish_cc_universal_type();
    _cc_out << "(";
    get_right()->_publish_cc_value();
    _cc_out << ")))";
  }
  else {
    _cc_out << "(val <= (";
    _publish_cc_universal_type();
    _cc_out << "(";
    get_left()->_publish_cc_value();
    _cc_out << "))";
    _cc_out << " && val >= (";
    _publish_cc_universal_type();
    _cc_out << "(";
    get_right()->_publish_cc_value();
    _cc_out << ")))";
  }
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_val() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::VAL(IntegerType& x) {" << endl;

  if(_is_subtype_decl() == TRUE) {
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE,(const VHDLData&) ";
    if(_is_enumeration_type() == TRUE) {
      get_base_type()->_publish_cc_type_name();
    }
    else {
      ASSERT(_get_type_mark() != NULL);
      _get_type_mark()->_publish_cc_type_name();
    }
    _cc_out << "::VAL(x).getVHDLData());" << endl;
  } else {
    _publish_cc_universal_type();
    _cc_out << " val;" << endl
	    << " val = x.getObject()->readVal();" << endl
	    << "if(";
    _publish_cc_range_check();
    _cc_out <<") {" << endl;

  // not necessary for integer types & Physical Types
    if(_get_bottom_base_type()->_is_integer_type() != true){
      if (_is_physical_type() != true) {
	if(_is_ascending_range()) {
	  _cc_out << "val = val + ";
	  _cc_out << "(";
	  _publish_cc_universal_type();
	  _cc_out << "(";
	  get_left()->_publish_cc_value();
	  _cc_out << "));" << endl;
	}
	else {
	  _cc_out << "val = ";
	  _cc_out << "(";
	  _publish_cc_universal_type();
	  _cc_out << "(";
	  get_left()->_publish_cc_value();
	  _cc_out << "))";
	  _cc_out << " - val;" << endl;
	}
      }
    }
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	    << "}" << endl
	    << "else {" << endl
	    << "cerr << \"The Result of `VAL attribute not withing range\";"
	    << "abort();" << endl
	    << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	    << "}" << endl;
  }
  _cc_out << "}" << endl;
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_succ() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::SUCC(";
  _publish_cc_base_type_name();
  _cc_out << "& x) {" << endl;

  _publish_cc_universal_type();
  _cc_out << " val;" << endl
	  << " val = x.getObject()->readVal();" << endl
	  << "if(";
  _publish_cc_range_check();
  _cc_out <<") {" << endl;

  if(_get_bottom_base_type()->_is_integer_type() == true){
    _cc_out << "val = val + 1;" << endl;
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	    << "}" << endl;
  }
  else {
    _cc_out << "if(";
    if(_is_ascending_range()) {
      _cc_out << "(val != ";
      _publish_cc_universal_right();
      _cc_out << ")";
    } else {
      _cc_out << "(val != ";
      _publish_cc_universal_left();
      _cc_out << ")";
    }
    _cc_out <<") {" << endl
	    << "val = val + 1;" << endl
	    << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	    << "}" << endl
	    << "else {" << endl
	    << "cerr << \"The parameter to `SUCC is equal to 'HIGH\";"
	    << "abort();" << endl
	    << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	    << "}" << endl
	    << "}" << endl;
  }
  _cc_out << "else {" << endl
	  << "cerr << \"The parameter of `SUCC attribute not withing range\";"
	  << "abort();" << endl
	  << "return ";
  _publish_cc_base_type_name();
  _cc_out << "(ObjectBase::VARIABLE, val);" << endl
	  << "}" << endl
	  << "}" << endl;
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_pred() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::PRED(";
  _publish_cc_base_type_name();
  _cc_out << "& x) {\n";

  _publish_cc_universal_type();
  _cc_out << " val;\n";
  _cc_out << " val = x.getObject()->readVal();\n";
  _cc_out << "if(";
  _publish_cc_range_check();
  _cc_out <<") {\n";

  if(_get_bottom_base_type()->_is_integer_type() == true){
    _cc_out <<"val = val - 1;" << endl;
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    _cc_out << "}\n";
  }
  else {
    _cc_out << "if(";
    if(_is_ascending_range()) {
      _cc_out << "(val != ";
      _publish_cc_universal_left();
      _cc_out << ")";
    }
    else {
      _cc_out << "(val != ";
      _publish_cc_universal_right();
      _cc_out << ")";
    }
    _cc_out <<") {\n";
    
    _cc_out << "val = val - 1;\n";
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    _cc_out << "}\n";
    
    _cc_out << "else {\n";
    _cc_out << "cerr << \"The parameter to `PRED is equal to 'LOW\";";
    _cc_out << "abort();\n";
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    _cc_out << "}\n";
    _cc_out << "}\n";
  }
  _cc_out << "else {\n";
  _cc_out << "cerr << \"The parameter of `PRED attribute not within range\";";
  _cc_out << "abort();\n";
  _cc_out << "return ";
  _publish_cc_base_type_name();
  _cc_out << "(ObjectBase::VARIABLE, val);\n";
  _cc_out << "}\n";
  _cc_out << "}\n";
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_leftof() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::LEFTOF(";
  _publish_cc_base_type_name();
  _cc_out << "& x) {\n";

  _publish_cc_universal_type();
  _cc_out << " val;\n";
  _cc_out << " val = x.getObject()->readVal();\n";

  _cc_out << "if(";
  _publish_cc_range_check();
  _cc_out <<") {\n";

  if(_get_bottom_base_type()->_is_integer_type() == true){
    if(_is_ascending_range()) {
      _cc_out << "val = val - 1;\n";
    }
    else {
      _cc_out << "val = val + 1;\n";
    }
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);}\n";
  }
  else {
    _cc_out << "if(";
    _cc_out << "(val != ";
    _publish_cc_universal_left();
    _cc_out <<")) {\n";
    
    if(_is_ascending_range()) {
      _cc_out << "val = val - 1;\n";
    }
    else {
      _cc_out << "val = val + 1;\n";
    }
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    
    _cc_out << "}\n";
    _cc_out << "else {\n";
    _cc_out << "cerr << \"The parameter to `LEFTOF is equal to 'LEFT\";";
    _cc_out << "abort();\n";
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    _cc_out << "}\n";
    
    _cc_out << "}\n";
  }
  _cc_out << "else {\n";
  _cc_out << "cerr << \"The parameter of `LEFTOF attribute not withing range\";";
  _cc_out << "abort();\n";
  _cc_out << "return ";
  _publish_cc_base_type_name();
  _cc_out << "(ObjectBase::VARIABLE, val);\n";
  _cc_out << "}\n";
  _cc_out << "}\n";
}


void 
IIRScram_ScalarTypeDefinition::_publish_cc_attribute_rightof() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << "\n";
  _publish_cc_type_name();
  _cc_out << "::RIGHTOF(";
  _publish_cc_base_type_name();
  _cc_out << "& x) {\n";

  _publish_cc_universal_type();
  _cc_out << " val;\n";
  _cc_out << " val = x.getObject()->readVal();\n";

  _cc_out << "if(";
  _publish_cc_range_check();
  _cc_out <<") {\n";

  if(_get_bottom_base_type()->_is_integer_type() == true){
    if(_is_ascending_range()) {
      _cc_out << "val = val + 1;\n";
    }
    else {
      _cc_out << "val = val - 1;\n";
    }
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);}\n";
  }
  else {
    _cc_out << "if(";
    _cc_out << "(val != ";
    _publish_cc_universal_right();
    _cc_out <<")) {\n";
    
    if(_is_ascending_range()) {
      _cc_out << "val = val + 1;\n";
    }
    else {
      _cc_out << "val = val - 1;\n";
    }
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    
    _cc_out << "}\n";
    _cc_out << "else {\n";
    _cc_out << "cerr << \"The parameter to `RIGHTOF is equal to 'RIGHT\";";
    _cc_out << "abort();\n";
    _cc_out << "return ";
    _publish_cc_base_type_name();
    _cc_out << "(ObjectBase::VARIABLE, val);\n";
    _cc_out << "}\n";
    _cc_out << "}\n";
  }
  _cc_out << "else {\n";
  _cc_out << "cerr << \"The parameter of `RIGHTOF attribute not withing range\";";
  _cc_out << "abort();\n";
  _cc_out << "return ";
  _publish_cc_base_type_name();
  _cc_out << "(ObjectBase::VARIABLE, val);\n";
  _cc_out << "}\n";
  _cc_out << "}\n";
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_kernel_type() {
  _report_undefined_scram_fn("_publish_cc_kernel_type()");
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_decl_destructors() {
  _cc_out << "virtual ~";
  _publish_cc_type_name();
  _cc_out << "() {}" << endl;
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_constructor_args() {
  //Nothing to be done here
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_decl_constructors() {
  if(_is_subtype_decl()) {
    _publish_cc_subtype_constructors();
  } else {
    _publish_cc_type_constructors();
  }
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_type_constructors() {
  
   //The constructors for these subtypes of scalartypes have to change to include the type info also
  /*  char* typeName;
  strstream typeStream;
  switch(get_kind()){
  case IIR_INTEGER_TYPE_DEFINITION:
  case IIR_INTEGER_SUBTYPE_DEFINITION:
    typeStream << "rangeInfo" << ends;
    break;
  case IIR_FLOATING_TYPE_DEFINITION:
  case IIR_FLOATING_SUBTYPE_DEFINITION:
    typeStream << "realInfo" << ends;
    break;
  case IIR_ENUMERATION_TYPE_DEFINITION:
  case IIR_ENUMERATION_SUBTYPE_DEFINITION:
    typeStream << "enumInfo" << ends;
    break;
  case IIR_PHYSICAL_TYPE_DEFINITION:
  case IIR_PHYSICAL_SUBTYPE_DEFINITION:
    typeStream << "phyInfo" << ends;
    break;
  }

  typeName = typeStream.str();

  // This constructor is needed to initialize vectors

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "() : ";
  _publish_cc_parent_type_name();
  _cc_out << "()  {}\n" << endl;
  
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(const ";
  _publish_cc_parent_type_name();
  _cc_out << "& val, "; 
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(val, rInfo)"; 
  _cc_out << "{}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, ";
  _publish_cc_kernel_type();
  _cc_out << "(ObjectBase::VARIABLE, "; 
  _cc_out << "rInfo.get_left()),"; 
  _cc_out <<"rInfo)";
  _cc_out << "{}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_universal_type();
  _cc_out << "& val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, val, ";
  _cc_out << "rInfo) {}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_kernel_type();
  _cc_out << "& val, "; 
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, val, ";
  _cc_out << "rInfo) {}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_type_name();
  _cc_out << "& val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";;
  _publish_cc_parent_type_name();
  _cc_out << "(objType, (";
  _publish_cc_parent_type_name();
  _cc_out << "&)val, ";
  _cc_out << "rInfo) {}" << endl;

  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(const ";
  _publish_cc_type_name();
  _cc_out << "& val, "; 
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(val,";
  _cc_out << "rInfo) {}" << endl;

  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "(bool alias, ";
  _publish_cc_type_name();
  _cc_out << "& actual, "; 
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info): ";
  _publish_cc_parent_type_name();
  _cc_out << "(alias, actual, "; 
  _cc_out << "rInfo) {}" << endl; */
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_subtype_constructors() {

  //The constructors for these subtypes of scalartypes have to change to include the type info also
  char* typeName;
  strstream typeStream;
  switch(get_kind()){
  case IIR_INTEGER_TYPE_DEFINITION:
  case IIR_INTEGER_SUBTYPE_DEFINITION:
    typeStream << "rangeInfo" << ends;
    break;
  case IIR_FLOATING_TYPE_DEFINITION:
  case IIR_FLOATING_SUBTYPE_DEFINITION:
    typeStream << "realInfo" << ends;
    break;
  case IIR_ENUMERATION_TYPE_DEFINITION:
  case IIR_ENUMERATION_SUBTYPE_DEFINITION:
    typeStream << "enumInfo" << ends;
    break;
  case IIR_PHYSICAL_TYPE_DEFINITION:
  case IIR_PHYSICAL_SUBTYPE_DEFINITION:
    typeStream << "phyInfo" << ends;
    break;
  }

  typeName = typeStream.str();
  

  // Constructor with no value.
  /*  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType): ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, (";
  _publish_cc_kernel_type();
  _cc_out << " &) ";
  _publish_cc_type_name();
  _cc_out << "::LEFT()) {" << endl; 
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Constructor for base type.
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(const ";
  _publish_cc_type_name();
  _cc_out << "& val) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(val) {}" << endl;

  // Constructor for base type with ObjectBase
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_kernel_type();
  _cc_out << "& val) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, ";
  _cc_out << "val) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Consttuctor with value.
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _publish_cc_universal_type();
  _cc_out << " val) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, val) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Constructor with value of its own type
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_type_name();
  _cc_out << "& val) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, (";
  _publish_cc_parent_type_name();
  _cc_out << "&) val) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Constructor for alias initialization.
  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "(bool alias, ";
  _publish_cc_parent_type_name();
  _cc_out << "& actual) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(alias, actual) {}" << endl;*/

  // This constructor is needed for initializing the vectors
  /*
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "() : ";
  _publish_cc_parent_type_name();
  _cc_out << "() {}\n" << endl;
  
  // Constructor with no value
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info): ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, ";
  _publish_cc_kernel_type();
  _cc_out << "(ObjectBase::VARIABLE, rInfo.get_left()), rInfo)";
  _cc_out << "{" << endl; 
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  //Constructor for base type
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(const ";
  _publish_cc_type_name();
  _cc_out << "& val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(val, rInfo) { }" << endl;

  // Constructor for base type with ObjectBase
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_kernel_type();
  _cc_out << "& val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info):";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, ";
  _cc_out << "val, rInfo) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Consttuctor with value.
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, ";
  _publish_cc_universal_type();
  _cc_out << " val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, val, rInfo) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Constructor with value of its own type
  _cc_out << "  ";
  _publish_cc_type_name();
  _cc_out << "(ObjectBase::ObjectType objType, const ";
  _publish_cc_type_name();
  _cc_out << "& val, ";
  _cc_out << typeName;
  _cc_out << " rInfo = ";
  _publish_cc_type_name();
  _cc_out << "_info) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(objType, (";
  _publish_cc_parent_type_name();
  _cc_out << "&) val, rInfo) {" << endl;
  _publish_cc_set_resolution_function();
  _cc_out << "}" << endl;

  // Constructor for alias initialization.
  _cc_out << " ";
  _publish_cc_type_name();
  _cc_out << "(bool alias, ";
  _publish_cc_parent_type_name();
  _cc_out << "& actual) : ";
  _publish_cc_parent_type_name();
  _cc_out << "(alias, actual) {}" << endl; */
  
}

void 
IIRScram_ScalarTypeDefinition::_publish_cc_headers() {
  _cc_out << "#include \"";
  _publish_cc_parent_type_name();
  _cc_out << ".hh\"" << endl;
  if(_is_subtype_decl() == TRUE) {
    _cc_out << "#include \"";
    ASSERT(_get_type_mark() != NULL);
    _get_type_mark()->_publish_cc_type_name();
    _cc_out << ".hh\"" << endl;
  }
  //For a type its ranges can be specified in terms of othher types.
  // and that type's attributes. Then in that case those types.hh have to
  //be included in the .cc file
  if(_get_attribute() != NULL) {
    _get_attribute()->_publish_cc_headers();
  }
  else {
    IIR* my_left = get_left();
    IIR* my_right = get_right();
    if(my_left != NULL && my_left->_is_literal() == FALSE &&
       my_left->_is_enumeration_literal() == FALSE) {
      my_left->_publish_cc_headers();
    }
    if(my_right != NULL && my_right->_is_literal() != TRUE &&
       my_right->_is_enumeration_literal() == FALSE) {
      my_right->_publish_cc_headers();
    }
  }
  _cc_out << "#include <strstream.h>" << endl;
}

void
IIRScram_ScalarTypeDefinition::_publish_cc_necessary_decl_in_state() {
  // Dummy function.
}


IIR_ScalarTypeDefinition *
IIRScram_ScalarTypeDefinition::_determine_discrete_type( IIR_RangeTypeDefinition *range ){

  if( range->get_left() == NULL ){
    ostrstream err;
    err << "Internal error in IIRScram_ScalarTypeDefinition::_determine_discrete_type(";
    err << "IIR_RangeTypeDefinition *range ) - this problem is most likely due to a known bug ";
    err << "in the intermediate form.  Attempting work around it." << ends;
    report_error( range, err, WARNING );
    return range;
  }

  ASSERT( range->get_left() != NULL );
  ASSERT( range->get_right() != NULL );
  ASSERT( range->get_direction() != NULL );

  // This is the type that this is a subtype of.
  IIR_TypeDefinition *subtype_of = NULL;
  
  set<IIR_TypeDefinition> *left_set = range->get_left()->_get_rval_set();
  if( left_set == NULL ){
    report_undefined_symbol( range->get_left() );
    return NULL;
  }
  
  set<IIR_TypeDefinition> *right_set = range->get_right()->_get_rval_set();
  if( right_set == NULL ){
    report_undefined_symbol( range->get_right() );
    return NULL;
  }
  
  ASSERT( left_set != NULL );
  left_set->reduce_set( &IIR::_is_discrete_type );
  
  reconcile_sets( left_set, right_set );  
  switch( left_set->num_elements() ){

  case 0:{
    ostrstream err;
    err << "|" << *range << "| is not a proper range in this context." << ends;
    report_error( range, err );
    return NULL;
  }

  case 1:{
    IIR_TypeDefinition *left_type = left_set->get_element();
    IIR_TypeDefinition *right_type = right_set->get_element();

    ASSERT( left_type->_is_scalar_type() == TRUE );
    ASSERT( right_type->_is_scalar_type() == TRUE );


    if( left_type->_get_bottom_base_type() != right_type->_get_bottom_base_type() ){
      // That means that the two types aren't "naturally" related, so one of them must be
      // a universal type.
      ASSERT( left_type == StandardPackage::savant_universal_integer ||
	      right_type == StandardPackage::savant_universal_integer );

      if( left_type == StandardPackage::savant_universal_integer ){
	subtype_of = (IIR_ScalarTypeDefinition *)right_type;
      }
      else{
	ASSERT( right_type == StandardPackage::savant_universal_integer );
	subtype_of = (IIR_ScalarTypeDefinition *)left_type;
      }

    }
    else{
      // The types are naturally compatible, and "reconcile_sets" should
      // have handed us the correct type back in the left set.
      subtype_of = (IIR_ScalarTypeDefinition *)left_set->get_element();
    }

    ASSERT( subtype_of->_is_scalar_type() == TRUE );
    break;
  }

  default:{
    ostrstream err;
    err << "The type of a range used in this manner must be "
	<< "determinable without context." << ends;
    report_error( range, err );
    report_ambiguous_error( range, left_set );
    return NULL;
  }
  }

  delete left_set;
  delete right_set;


  // This method is following the rules of page 42, line 350 of the LRM.  
  if( subtype_of == StandardPackage::savant_universal_integer &&
      ( range->get_left()->_is_integer_literal() == TRUE ||
	range->get_left()->_is_attribute() == TRUE ) &&
      ( range->get_right()->_is_integer_literal() == TRUE ||
	range->get_right()->_is_attribute() == TRUE ) ){
    subtype_of = StandardPackage::integer_type;
  }

  return (IIR_ScalarTypeDefinition *)subtype_of;
}


IIR_Boolean 
IIRScram_ScalarTypeDefinition::_is_resolved(){
  IIR_Boolean retval = TRUE;

  if( this != StandardPackage::savant_universal_integer 
      && this != (IIR_ScalarTypeDefinition*)StandardPackage::savant_universal_real ){
    if( get_left() == NULL || get_right() == NULL || get_direction() == NULL ){
      ASSERT( get_left() == NULL);
      ASSERT( get_right() == NULL);
      ASSERT( get_direction() == NULL);
    }
    else{
      ASSERT( get_left() != NULL);
      ASSERT( get_right() != NULL);
      ASSERT( get_direction() != NULL);
      
      if( get_left()->_is_resolved() == FALSE ||
	  get_right()->_is_resolved() == FALSE || 
	  get_direction()->_is_resolved() == FALSE ){
	retval = FALSE;
      }
    }
  }
  
  return retval;
}



IIR_TypeDefinition *
IIRScram_ScalarTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
						       IIR_ScalarTypeDefinition *new_constraint ){
  
  IIR_FunctionDeclaration *resolution_function_decl = NULL;

  IIR_TypeDefinition *subtype = _get_new_subtype();
  // This looks bacwards, but it's not...
  ASSERT( subtype->_is_iir_scalar_type_definition() == TRUE );


  ASSERT( subtype->_is_scalar_type() == TRUE );
  IIR_ScalarTypeDefinition *scalar_subtype = (IIR_ScalarTypeDefinition *)subtype;
  
  if( resolution_function != NULL ){
    resolution_function_decl = _resolve_resolution_function( resolution_function );
    scalar_subtype->set_resolution_function( resolution_function_decl );
  }
  
   // Enumeration types don't have anonymous base types unlike the
  // other scalar types - hence all of the special cases here.
  if( _is_subtype() == TRUE ){
    // If we are a subtype, and we're NOT an enumeration type:
    // 1) base type isn't null
    // 2) base type is a type - not a subtype, and it's anonymous.
    ASSERT( get_base_type() != NULL );
    ASSERT( get_base_type()->_is_subtype() == FALSE 
	    || get_base_type()->_is_enumeration_type() == TRUE );
    ASSERT( get_base_type()->_is_anonymous() == TRUE 
	    || get_base_type()->_is_enumeration_type() == TRUE );

    scalar_subtype->set_base_type( get_base_type() );
  }
  else{
    // We are a type.  If we're not an enumeration type, we must:
    // 1) have a NULL base type.
    // 2) be anonymous
    ASSERT( _is_enumeration_type() == TRUE || get_base_type() == NULL && _is_anonymous() == TRUE );
    scalar_subtype->set_base_type( this );
  }
    
  if( new_constraint != NULL ){
    copy_location( new_constraint, subtype );

    if( new_constraint->get_left() != NULL ){
      
      ASSERT( new_constraint->get_right() != NULL );
      ASSERT( new_constraint->get_direction() != NULL );

      // Resolve the left side, if needed
      if( new_constraint->get_left()->_is_resolved() == FALSE ){
	new_constraint->set_left( new_constraint->get_left()->_semantic_transform( this ) );
	new_constraint->get_left()->_type_check( this );
	new_constraint->set_left( new_constraint->get_left()->_rval_to_decl( this ) );	
      }
      // Modified by SK -- Begin
      // set the subtype of left if it is an enumeration literal.
      if(new_constraint->get_left()->_is_enumeration_literal() == TRUE) {
	if(new_constraint->get_left()->_get_subtype() == NULL) {
	  ASSERT(_is_enumeration_type() == TRUE);
	  ((IIR_EnumerationLiteral *) new_constraint->get_left())->set_subtype((IIR_EnumerationTypeDefinition*)this);
	}
      }
      // Modified by SK -- End      
      scalar_subtype->set_left( new_constraint->get_left() );

      // No resolution need for direction...
      scalar_subtype->set_direction( new_constraint->get_direction() );


      // Resolve the right side, if needed
      if( new_constraint->get_right()->_is_resolved() == FALSE ){
	new_constraint->set_right( new_constraint->get_right()->_semantic_transform( this ) );
	new_constraint->get_right()->_type_check( this );
	new_constraint->set_right( new_constraint->get_right()->_rval_to_decl( this ) );	
      }

      // Modified by SK -- Begin
      // set the subtype of right if it is an enumeration literal.
      if(new_constraint->get_right()->_is_enumeration_literal() == TRUE) {
	if(new_constraint->get_right()->_get_subtype() == NULL) {
	  ASSERT(_is_enumeration_type() == TRUE);
	  ((IIR_EnumerationLiteral *) new_constraint->get_right())->set_subtype((IIR_EnumerationTypeDefinition*)this);
	}
      }
      // Modified by SK -- End
      scalar_subtype->set_right( new_constraint->get_right() );
    }
#ifdef DEVELOPER_ASSERTIONS
    else{
      ASSERT( new_constraint->get_direction() == NULL );
      ASSERT( new_constraint->get_right() == NULL );
    }
#endif
    scalar_subtype->_set_attribute(new_constraint->_get_attribute());
  }
  else{
    // No new constraint 
    copy_location( this, scalar_subtype );
    scalar_subtype->set_left( get_left() );
    scalar_subtype->set_direction( get_direction() );
    scalar_subtype->set_right( get_right() );

    if( scalar_subtype->_is_iir_enumeration_type_definition() == TRUE ){
      ASSERT( _is_iir_enumeration_type_definition() == TRUE );
      IIR_EnumerationTypeDefinition *this_as_enumeration;
      IIR_EnumerationTypeDefinition *scalar_subtype_as_enumeration;
      this_as_enumeration = (IIR_EnumerationTypeDefinition *)this;
      scalar_subtype_as_enumeration = (IIR_EnumerationTypeDefinition *)scalar_subtype;
      scalar_subtype_as_enumeration->enumeration_literals = 
	this_as_enumeration->enumeration_literals;
    }
  }

  return scalar_subtype;
}

void 
IIRScram_ScalarTypeDefinition::set_resolution_function( IIR_FunctionDeclaration * ){
  _report_undefined_scram_fn("set_resolution_function");  
}


void 
IIRScram_ScalarTypeDefinition::_add_decl_into_cgen_symbol_table() {
  if(get_base_type() != NULL) {
    get_base_type()->_add_decl_into_cgen_symbol_table();
  }
  if(get_left() != NULL) {
    get_left()->_add_decl_into_cgen_symbol_table();
  }
  if(get_right() != NULL) {
    get_right()->_add_decl_into_cgen_symbol_table();
  }
}

IIR *
IIRScram_ScalarTypeDefinition::_clone(){
  _report_undefined_scram_fn("_clone");
  return NULL;
}

void 
IIRScram_ScalarTypeDefinition::_clone( IIR_ScalarTypeDefinition *my_clone ){
  my_clone->set_left( get_left() );
  my_clone->set_right( get_right() );
  my_clone->set_direction( get_direction() );

  IIR_TypeDefinition::_clone( my_clone );
}

IIR_Boolean 
IIRScram_ScalarTypeDefinition::_is_locally_static(){
  if( get_left() != NULL && get_left()->_is_locally_static() == TRUE &&
      get_right() != NULL && get_right()->_is_locally_static() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}


IIR_Boolean 
IIRScram_ScalarTypeDefinition::_is_globally_static(){
  if( get_left() != NULL && get_left()->_is_globally_static() == TRUE &&
      get_right() != NULL && get_right()->_is_globally_static() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

void 
IIRScram_ScalarTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){

  IIR_TypeDefinition::_build_implicit_operators( add_to );
  _build_ordering_operators( add_to );
}
