#ifndef IIRSCRAM_PHYSICAL_UNIT_HH
#define IIRSCRAM_PHYSICAL_UNIT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PhysicalUnit.hh,v 1.2 1999/03/09 20:55:54 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_PhysicalUnit.hh"

class IIR_List;
class IIR_PhysicalTypeDefinition;

class IIRScram_PhysicalUnit : public IIRBase_PhysicalUnit {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl(ostream &);
  
  void _publish_cc_name();
  void _publish_cc();
  void _publish_cc_state_object_init();
  void _publish_cc_value();
  void _publish_cc_headers();
  void _publish_cc_universal_value();
  void _publish_cc_initialization_value();

  void _set_physical_type( IIR_PhysicalTypeDefinition * );
  IIR_PhysicalTypeDefinition *_get_physical_type( );
  
  IIR_AttributeSpecificationList *_get_attribute_specification_list(){ return &attributes; }

  IIR_TypeDefinition *_get_subtype();
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0);
  declaration_type _get_type();

  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  virtual IIR_Boolean _is_iir_physical_unit(){ return TRUE; }  

  IIR* _clone() { return this; }

protected:
  IIRScram_PhysicalUnit() {}
  virtual ~IIRScram_PhysicalUnit() = 0;
    
private:
  IIR_PhysicalTypeDefinition *my_type;
};
#endif
