
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_List.cc,v 1.3 1999/04/14 18:29:21 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_List.hh"
#include "IIR_List.hh"
#include "IIR_TypeDefinition.hh"

IIRScram_List::~IIRScram_List(){}

void 
IIRScram_List::_listcopy( IIR_List &dest, IIR_List &source ){
  dest.dl_list<IIR>::operator=( source );
}

void 
IIRScram_List::_publish_vhdl_decl(ostream &_vhdl_out, char *separator ) {
  IIR *list_element = first();
  while( list_element != NULL ){
    list_element->_publish_vhdl_decl(_vhdl_out);
    list_element = successor( list_element );
    
    if( separator != NULL && list_element != NULL ){
      _vhdl_out << separator;
    }
  }
}

void 
IIRScram_List::_publish_vhdl( ostream &_vhdl_out, char *separator ) {
  IIR *list_element = first();
  while( list_element != NULL ){
    list_element->_publish_vhdl(_vhdl_out);
    list_element = successor( list_element );

    if( list_element != NULL && separator != NULL ){
      _vhdl_out << separator;
    }
  }
}

ostream &
IIRScram_List::_print( ostream &os ){

  IIR *list_element = first(); 
  while( list_element != NULL ){
    os << *list_element;
    list_element = successor(list_element);
    if( list_element != NULL ){
      os << ",";
    }
  }
  
  return os;
}

void 
IIRScram_List::_publish_cc_headers() {
  IIR *list_element = first(); 
  while( list_element != NULL ){
    ASSERT(list_element->_is_resolved());
    if (list_element->_get_subtype()->_is_scalar_type() == FALSE) {
      _cc_out << "#include \"";
      list_element->_publish_cc_type_name();
      _cc_out << ".hh\"" << endl;
    }
    else {
      if (list_element->_get_subtype()->_is_kernel_type() == FALSE) {
	list_element->_get_subtype()->_publish_cc_extern_type_info();
	_cc_out << ";\n";
      }
    }
    list_element = successor(list_element);
  }
}

IIR *
IIRScram_List::_clone(){
  _report_undefined_scram_fn("_clone()");
  return NULL;
}


IIR_Boolean 
IIRScram_List::_is_resolved(){
  IIR_Boolean retval = TRUE;

  IIR *current_element = first();
  while( current_element != NULL ){
    if( current_element->_is_resolved() == FALSE ){
      retval = FALSE;
      break;
    }
    current_element = successor( current_element );
  }

  return retval;
}

void 
IIRScram_List::_clone( IIR_List *clone_into ){
  IIR *current = first();
  while( current != NULL ){
    clone_into->append( current->_clone() );
    current = successor( current );
  }
}

IIR_Label *
IIRScram_List::_find_instantiate_label( IIR_SimpleName * ){
  _report_undefined_scram_fn("_find_instantiate_label( IIR_SimpleName * )");
  return NULL;
}

void 
IIRScram_List::_append( IIR_List *to_append ){
  ASSERT( to_append != NULL );

  // This is kind of inefficient - we could support it at a lower level and
  // hook the whole chain on at once.
  IIR *current = to_append->first();
  while( current != NULL ){
    append( current );
    current = to_append->successor( current );
  }
}

void 
IIRScram_List::_make_interface_visible( symbol_table *add_to ){
  IIR *current = first();
  while( current != NULL ){
    current->_make_interface_visible( add_to );
    current = successor( current );
  }
}

void 
IIRScram_List::_destroy_list(){
  IIR *current = first();
  IIR *last;
  while( current != NULL ){
    last = current;
    current = successor( current );
    remove( last );
    delete last;
  }
}
