
#ifndef IIRSCRAM_LIBRARY_CLAUSE_HH
#define IIRSCRAM_LIBRARY_CLAUSE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajsek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LibraryClause.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_LibraryClause.hh"

class IIR_List ;
class IIR_LibraryDeclaration;

class IIRScram_LibraryClause : public IIRBase_LibraryClause {

public:

  void _publish_vhdl(ostream &);
  void _publish_vhdl_decl(ostream &);

  void _type_check();

  void _set_library_declaration( IIR_LibraryDeclaration *new_library_declaration ){
    my_library_declaration = new_library_declaration;
  }

  IIR_LibraryDeclaration *_get_library_declaration( ){
    return my_library_declaration;
  }

protected:
  
  IIRScram_LibraryClause(){
    my_library_declaration = NULL;
  }
  
  virtual ~IIRScram_LibraryClause() = 0;
    
private:
  IIR_LibraryDeclaration *my_library_declaration;
};

#endif
