
#ifndef IIRSCRAM_FLOATING_TYPE_DEFINITION_HH
#define IIRSCRAM_FLOATING_TYPE_DEFINITION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingTypeDefinition.hh,v 
// 
//---------------------------------------------------------------------------

#include "IIRBase_FloatingTypeDefinition.hh"

class IIRScram_FloatingTypeDefinition : public IIRBase_FloatingTypeDefinition {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:
  IIR_Boolean _is_numeric_type() { return true; }
  IIR_Boolean _is_floating_type() { return true; }

  void _publish_cc_decl_cc();

  void _publish_cc_left();
  void _publish_cc_right();
  void _publish_cc_universal_type();
  void _publish_cc_kernel_type();

  virtual void _publish_cc_data_members();

  //The following function publishes the function for the
  // `IMAGE attribute for integer Type definition
  virtual void _publish_cc_attribute_image();

  //The following function publishes the function for the
  // `VALUE attribute for integer Type definition
  virtual void _publish_cc_attribute_value();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();
  void _publish_cc_type_string();

  IIR_TypeDefinition *_check_special_compatible( IIR_TypeDefinition * );

  IIR_TypeDefinition *_get_new_subtype();
  IIR *_clone();

  IIR_Boolean _is_iir_floating_type_definition(){ return TRUE; }

protected:
  
  IIRScram_FloatingTypeDefinition() {};
  virtual ~IIRScram_FloatingTypeDefinition() = 0;

  void _build_implicit_operators( set<IIR_Declaration> * );
    
private:
  

};

#endif
