// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AssertionStatement.cc,v 1.2 1999/03/09 20:52:56 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_AssertionStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"

IIRScram_AssertionStatement::~IIRScram_AssertionStatement(){}


void 
IIRScram_AssertionStatement::_publish_vhdl(ostream &_vhdl_out) {
  if(get_label() != NULL) {
    get_label()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ":\n";
  }
  _vhdl_out << " assert (";
  get_assertion_condition()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ")";

  if(get_report_expression() != NULL) {
    _vhdl_out << endl
	      << "   report ";
    get_report_expression()->_publish_vhdl(_vhdl_out);
  }

  if(get_severity_expression() != NULL) {
    _vhdl_out << endl
	      << "   severity ";
    get_severity_expression()->_publish_vhdl(_vhdl_out);
  }
}


void 
IIRScram_AssertionStatement::_publish_cc() {
  if (get_label() != NULL) {
    get_label()->_publish_cc();
    _cc_out << ":\n";
  }

  ASSERT(get_assertion_condition() != NULL);

  // Assertion condition.
  _cc_out << "if (SAVANT_BOOLEAN_FALSE  == ";
  get_assertion_condition()->_publish_cc();
  _cc_out << ") {" << endl;

  // _cc_out << "AccessVariable<char*> savantOutString;" << endl
  _cc_out << "SavantlineType savantOutString;" << endl
	  << "ostrstream savantOutStream;" << endl;

  // Report expression.
  _cc_out << "savantOutStream << \"Assertion failiure at \" << \"Time: \" << ";
  if(_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "processPtr->getTimeNow()";
  } else {
    _cc_out << "getTimeNow()";
  }
  _cc_out << " << \" Report: \" << endl << \"    \" << ";
  if(get_report_expression() != NULL) {
    get_report_expression()->_publish_cc();
  } else {
    _cc_out << "\"Assertion violation\"";
  }
  _cc_out << " << endl";

  // Severity expression.
  _cc_out << " << \"Severity Level: \" << ";
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_publish_cc();
  } else {
    _cc_out << "\"NOTE\"";
  }

  // More information on the location of the assertion statement.
  _cc_out << " << \" at " << *get_file_name() << ":" 
	  << get_line_number() << "\" << ends;" << endl;

  _cc_out << "savantOutString = savantOutStream.str();" << endl;

  // If the assertion statement is in a subprogram, we need to use the
  // process pointer supplied to the program to call the writeline method,
  // since a writeline method is a member of VHDLKernel.
  if(_is_currently_publishing_subprogram() == TRUE) {
    _cc_out << "processPtr->";
  }

  _cc_out << "savantwriteline(NULL, FileQueue::standardOut, savantOutString);"
	  << endl;
  _cc_out << "delete [] savantOutStream.str();" << endl ;
  _cc_out << "}" << endl;
}


void 
IIRScram_AssertionStatement::_type_check(){
  // This code was copied too IIRScram_ConcurrentAssertionStatement.
  // Any changes here need to be made there, too.

  if( get_assertion_condition() != NULL ){
    _type_check_assertion_condition();
  }

  if( get_report_expression() != NULL ){
    _type_check_report_expression();
  }

  if( get_severity_expression() != NULL ){
    _type_check_severity_expression();
  }
}

void
IIRScram_AssertionStatement::_get_list_of_input_signals(set<IIR_Declaration>* list) {
  get_assertion_condition()->_get_list_of_input_signals(list);
  if(get_report_expression() != NULL) {
    get_report_expression()->_get_list_of_input_signals(list);
  }
  if(get_severity_expression() != NULL) {
    get_severity_expression()->_get_list_of_input_signals(list);
  }
}

IIR*
IIRScram_AssertionStatement::_clone() {
  IIR_AssertionStatement *clone = new IIR_AssertionStatement();
  IIR_SequentialStatement::_clone( clone );

  clone->set_assertion_condition( get_assertion_condition()->_clone() );
  clone->set_report_expression( get_report_expression()->_clone() );
  clone->set_severity_expression( get_severity_expression()->_clone() );

  return clone;
}
