/*$Id: d_switch.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * voltage (and current) controlled switch.
 * netlist syntax:
 * device:  Sxxxx n+ n- vc+ vc- mname <on>|<off> <model-card-args>
 * model:   .model mname SW <args>
 * current controlled switch
 * device:  Wxxxx n+ n- controlelement mname <on>|<off> <model-card-args>
 * model:   .model mname CSW <args>
 */
#include "ap.h"
#include "d_switch.h"
/*--------------------------------------------------------------------------*/
//		MODEL_SWITCH::MODEL_SWITCH();
//	void	MODEL_SWITCH::parse(CS&);
//	void	MODEL_SWITCH::print(int,int)const;
//		SWITCH_BASE::SWITCH_BASE();
//		SWITCH_BASE::SWITCH_BASE(const SWITCH_BASE& p);
//	void	SWITCH_BASE::parse_sb(CS&,int);
//	void	SWITCH_BASE::print(int,int)const;
//	void	SWITCH_BASE::expand_sb();
//	bool	SWITCH_BASE::do_tr();
//	void	SWITCH_BASE::do_ac();
//	void	DEV_CSWITCH::expand();
/*--------------------------------------------------------------------------*/
static SWITCH_COMMON Default_SWITCH(CC_STATIC);
/*--------------------------------------------------------------------------*/
MODEL_SWITCH::MODEL_SWITCH()
  :MODEL_CARD()
{
  vt = 0.;
  vh = 0.;
  ron = 1.;
  roff = 1e12;
  type = VOLTAGE;
}
/*--------------------------------------------------------------------------*/
void MODEL_SWITCH::parse(CS& cmd)
{
  cmd.skiparg();		// skip known ".model"
  parse_label(cmd);
  cmd.stuck();
  /**/ set(cmd, "SW",  &type, VOLTAGE)
    || set(cmd, "CSW", &type, CURRENT);
  if (cmd.stuck()){
    untested();
    cmd.warn(bWARNING, "need sw or csw");
  }
  cmd.skiplparen();
  cmd.stuck();
  do{
    cmd.get("VT",   &vt);
    cmd.get("VH",   &vh,  mPOSITIVE);
    cmd.get("IT",   &vt);
    cmd.get("IH",   &vh,  mPOSITIVE);
    cmd.get("RON",  &ron);
    cmd.get("ROFF", &roff);
  }while (cmd.more() && !cmd.stuck());
  cmd.skiprparen();
  cmd.check(bWARNING, "what's this?");
}
/*--------------------------------------------------------------------------*/
void MODEL_SWITCH::print(OMSTREAM where, int)const
{
  where.setfloatwidth(7);
  switch (type){
  case VOLTAGE:
    where << ".model " << short_label() << " sw ("
	  <<   "vt=" << vt
	  << "  vh=" << vh;
    break;
  case CURRENT:
    where << ".model " << short_label() << " csw ("
	  <<   "it=" << vt
	  << "  ih=" << vh;
    break;
  }
  where << "  ron="  << ron
	<< "  roff=" << roff
	<< ")\n";
}
/*--------------------------------------------------------------------------*/
SWITCH_BASE::SWITCH_BASE()
  :ONEPORT(),
   _input_label(),
   _input(0),
   _ic(_UNKNOWN),
   _current_state(_UNKNOWN),
   _previous_state(_UNKNOWN)
{
  attach_common(&Default_SWITCH);
}
/*--------------------------------------------------------------------------*/
SWITCH_BASE::SWITCH_BASE(const SWITCH_BASE& p)
  :ONEPORT(p),
   _input_label(p._input_label),
   _input(0),
   _ic(p._ic),
   _current_state(p._current_state),
   _previous_state(p._previous_state)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::parse_sb(CS& cmd, int numnodes)
{
  const SWITCH_COMMON* cc = prechecked_cast<const SWITCH_COMMON*>(common());
  assert(cc);
  SWITCH_COMMON* c = new SWITCH_COMMON(*cc);
  assert(c);
  assert(!c->has_model());

  parse_Label(cmd);
  parse_nodes(cmd, numnodes, numnodes);
  {if (typeid(*this) == typeid(DEV_CSWITCH)){
    _input_label = cmd.ctos(TOKENTERM);
    _input_label[0] = toupper(_input_label[0]);
  }else{
    assert(typeid(*this) == typeid(DEV_VSWITCH));
  }}
  c->parse_modelname(cmd);
  cmd.stuck();
  /**/ ::set(cmd, "OFF",    &_ic, _OFF)
    || ::set(cmd, "ON",	    &_ic, _ON)
    || ::set(cmd, "UNKNOWN",&_ic, _UNKNOWN);
  {if (cmd.stuck()){
    cmd.check(bWARNING, "need off, on, or unknown");
  }else{
    untested();
  }}
  attach_common(c);
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::print(OMSTREAM where, int)const
{
  const SWITCH_COMMON* c = prechecked_cast<const SWITCH_COMMON*>(common());
  assert(c);
  where << short_label();
  printnodes(where, numnodes());
  {if (_input){
    where << "  " << _input->short_label();
  }else{
    where << "  " << _input_label;
  }}
  where << ' ' << c->modelname();

  switch (_ic){
    case _OFF:	   where << " off";	break;
    case _ON:	   where << " on";	break;
    case _UNKNOWN: 			break;
  }
  where << '\n';
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::expand_sb()
{
  const MODEL_SWITCH* m = dynamic_cast<const MODEL_SWITCH*>(attach_model());
  if (!m){
    untested();
    assert(has_common());
    error(bERROR, long_label() + ": model " + common()->modelname()
	  + " is not a switch (SW or CSW)\n");
  }
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::precalc()
{
  const SWITCH_COMMON* c = prechecked_cast<const SWITCH_COMMON*>(common());
  assert(c);
  const MODEL_SWITCH* m = prechecked_cast<const MODEL_SWITCH*>(c->model());
  assert(m);

  set_value(m->ron);
  y0.f0 = LINEAR;
  y0.f1 = (_ic == _ON) ? m->ron : m->roff;	/* unknown is off */
  m0.c1 = 1./y0.f1;
  m0.c0 = 0.;
  _previous_state = _current_state = _ic;
  assert(loss == 0.);
  assert(!constant()); /* depends on input */
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::dc_begin()
{
  const SWITCH_COMMON* c = prechecked_cast<const SWITCH_COMMON*>(common());
  assert(c);
  const MODEL_SWITCH* m = prechecked_cast<const MODEL_SWITCH*>(c->model());
  assert(m);

  assert(loss == 0.);
  assert(y0.f0 == LINEAR);
  y0.f1 = ((_ic == _ON) ? m->ron : m->roff);  /* unknown is off */
  m0.c1 = 1./y0.f1;
  assert(m0.c0 == 0.);
  _current_state = _ic;
}
/*--------------------------------------------------------------------------*/
bool SWITCH_BASE::do_tr()
{
  const SWITCH_COMMON* c = prechecked_cast<const SWITCH_COMMON*>(common());
  assert(c);
  const MODEL_SWITCH* m = prechecked_cast<const MODEL_SWITCH*>(c->model());
  assert(m);

  y0.x = (_input)			/* y0.x is controlling value */
    ? CARD::probe(_input,"I")		/* current controlled */
    : n[IN1].v0() - n[IN2].v0();	/* voltage controlled */

  state_t new_state;
  {if (y0.x > m->vt + m->vh){
    new_state = _ON;
  }else if (y0.x < m->vt - m->vh){
    new_state = _OFF;
  }else{
    new_state = _previous_state;
  }}

  {if (new_state != _current_state){
    y0.f1 = (new_state == _ON) ? m->ron : m->roff;	/* unknown is off */
    _current_state = new_state;
    m0.c1 = 1./y0.f1;
    q_load();
    store_values();
    set_not_converged();
  }else{
    assert(y0.f1 == (new_state == _ON) ? m->ron : m->roff);
    set_converged();
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void SWITCH_BASE::do_ac()
{
  assert(ev  == y0.f1);
  assert(acg == m0.c1);
  ac_load_passive();
}
/*--------------------------------------------------------------------------*/
void DEV_CSWITCH::expand()
{
  _input = dynamic_cast<ELEMENT*>(find_in_scope(_input_label));
  if (!_input){
    untested();
    error(bERROR,
	  long_label() + ": " + _input_label + " cannot be used as input\n");
  }
  expand_sb();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
