//  uniprint.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <stdlib.h>
#include <iostream.h>
#include <stdiostream.h>
#include <UString.h>
#include <UCommon.h>
//  yudit version 0.95pl1 Copyright(C) 12 January, 1997, Tokyo Japan  Gaspar Sinai
#include <UPrint.h>
#include <sys/stat.h>

#ifdef __sun__
#ifndef __svr4__
extern "C" {
int getopt(int argc, char* const* argv, const char* optstring);
extern int optind;
extern char *optarg;
}
#endif
#else
#include <unistd.h>
#endif

#define LINE_LENGTH     4096

static void exitUsage ();
int
main (int argc, char *argv[])
{
	int		option;
	AString		font=0;
	char*		encoding=0;
	char*		hEncoding=0;
	double		headerSize=10.0;
	ofstream*	ofileStream;
#ifdef HAVE_STDIOSTREAM
	stdiostream*	pipePrinter;
#else
	ostdiostream*	pipePrinter;
#endif
	FILE*		filePrinter;
	ostream*	printerStream;
	ifstream*	file;
	istream*	input;
	unsigned char*	strBuffer;
	int		bufLen;
	UCS2*		ucs2Buffer;
	UCS2**		ucs2Array;
	int*		intArray;
	int		arraySize;

	UString*	str;
	UString*	headerUString;

	UCS2*		uheader;
	int		uheaderSize;

	unsigned char*	headerString;
	char*		umaps;
	UPrint*		printer;
	UPrint::UStatus status;
	char*		xPath;
	double		fontSize=12.0;
	char*		fontFile;
	int		tabStops=8;
	char*		ofile;
	AString		printerCommand;
	char*		device;
	struct stat     statbuf;

	device = 0;
	headerString = 0;
	ofile = 0;
	if ((umaps = getenv ("FONTDIR")) != 0)
	{
		xPath = umaps;
	}
	else if (umaps=getenv ("YUDITDATA"))
	{
		xPath = umaps;
	}
	else
	{
		xPath = DATA_DIR;
	}
	USetMapPath (xPath);
	encoding=0;
	hEncoding=0;
	while ((option=getopt (argc, argv, "E:e:s:H:S:t:f:o:P:"))!= -1)
	{
		switch (option)
		{
		case 'P':
			device = optarg; break;
		case 'o':
			ofile = optarg; break;
		case 's':
			fontSize = atof (optarg); break;
		case 't':
			tabStops = atoi (optarg); break;
		case 'S':
			headerSize=atof (optarg);
			if (headerSize<0.0) headerSize=0.0;
			break;
		case 'H':
			headerString=(unsigned char*) optarg;
			break;
		case 'e':
			encoding=optarg;
			break;
		case 'E':
			hEncoding=optarg;
			break;
		case 'f':
			font = (const char*) optarg;
			font += (const char*) ".ttf";
			break;
		default:
			exitUsage ();
		}
	}

	if (font.isNull())
	{
		font = (const char*) DEFAULT_TT_FONT;
		font += (const char*) ".ttf";
		fontFile=UFindFile (xPath, font);
		if (fontFile==0)
		{
			cerr << "error: default font '";
			cerr << (const char*) font ;
			cerr << "' not found.\n";
			exit (0);
		}
	}
	else
	{
		fontFile=UFindFile (xPath, font); 
		if (fontFile==0)
		{
			cerr << "error: font '";
			cerr << (const char*) font ;
			cerr << "' not found.\n";
			exit (0);
		}
	}


	if (optind < argc-1 || font==0)
	{
		exitUsage ();
	}

	pipePrinter = 0;

	if (argc-optind == 1)
	{
		file = new ifstream (argv[optind]);
		if (file->rdbuf() == 0 || !file->rdbuf()->is_open())
		{
			cerr << "uniprint: can not open '" << argv[optind] 
				<< "' for reading.\n";
			exit (1);
		}
		input = file;
		if (headerString==0) headerString = (unsigned char*) argv[optind];
	}
	else
	{
		if (headerString==0) headerString = (unsigned char*) "stdin";
		input = &cin;
	}
	pipePrinter = 0;
	filePrinter = 0;
	printerStream = 0;
	ofileStream = 0;
	if (ofile==0)
	{
		if (stat ((const char*) LPR_COMMAND, &statbuf) == -1
			|| (statbuf.st_mode & S_IEXEC) ==0 )
		{
			cerr << "error: can not open pipe'"
			  << LPR_COMMAND << "' for writing.\n";
		}
		printerCommand = (const char*) "| ";
		printerCommand += (const char*) LPR_COMMAND;
		if (device != 0)
		{
			printerCommand += " -P";
			printerCommand += device;
		}
		filePrinter = popen (&printerCommand[1], "w");
		if (filePrinter==0)
		{
			cerr << "error: can not execute '"
			  << LPR_COMMAND << "'.\n";
			exit (1);
		}
#ifdef HAVE_STDIOSTREAM
		pipePrinter = new stdiostream (filePrinter);
#else
		pipePrinter = new ostdiostream (filePrinter);
#endif
		if (pipePrinter==0)
		{
			cerr << "error: can not execute '"
			  << LPR_COMMAND << "'.\n";
			exit (1);
		}
		printerStream = new iostream (pipePrinter->rdbuf());
	}
	else if (strcmp (ofile, "-") ==0)
	{
		printerStream = &cout;
	}
	else 
	{
		ofileStream = new ofstream (ofile);
		if (ofileStream->rdbuf() == 0 
			|| !ofileStream->rdbuf()->is_open())
		{
			cerr << "error: can not open '"
			  << ofile << "' for writing.\n";
			exit (1);
		}
		printerStream = ofileStream;
	}
	str = new UString();
	headerUString = new UString ();
	if (encoding!=0)
	{
		if (str->setConverter (encoding)== UString::ERROR)
		{
			cerr << "uniprint: can not find converter for '" 
				<< encoding << "'.\n";
			exit (1);
		}
	}
	if (hEncoding!=0)
	{
		if (headerUString->setConverter (hEncoding)== UString::ERROR)
		{
			cerr << "uniprint: can not find converter for '" 
				<< hEncoding << "'.\n";
			exit (1);
		}
	}

	// build
	headerUString->putString (headerString);
	strBuffer = UReadBuffer (input, &bufLen);
	if (strBuffer==0)
	{
		exit (1);
	}
	str->putString (strBuffer, bufLen);
	delete strBuffer;
	ucs2Buffer = str->getUString(&bufLen);
	if (ucs2Buffer==0)
	{
		cerr << "error: out of memory.\n";
		exit (1);
	}
	delete str;
	arraySize = USplit (ucs2Buffer, bufLen, &ucs2Array, &intArray);
	if (ucs2Array == 0)
	{
		cerr << "error: out of memory.\n";
		exit (1);
	}
	printer = new UPrint (fontFile, fontSize, tabStops, headerSize);
	CHECKNULL (printer);
	uheader = headerUString->getUString(&uheaderSize);
	status = printer->print (printerStream, ucs2Array, intArray, arraySize, uheader, uheaderSize);
	delete fontFile;
	if (status==UPrint::ERROR)
	{
		cerr << (const char*) printer->errors << "\n";
		exit (0);
	}
	if (printerStream  == &cout)
	{
		//cout.close();
	}
	else if (pipePrinter)
	{
		delete pipePrinter;
		pclose (filePrinter);
	}
	else if (printerStream != 0)
	{
		if (ofileStream!=0)
		{
			ofileStream->close();
			if (ofileStream!=printerStream) delete ofileStream;
		}
		delete printerStream;
	}
	if (printer->getPageCount() > 1)
	{
		cerr << printer->getPageCount() << " pages.\n";
	}
	else
	{
		cerr << printer->getPageCount() << " page.\n";
	}
	if (printer->getWrappedCount() > 0)
	{
		if (printer->getWrappedCount()>1)
		{
			cerr << printer->getWrappedCount() 
		   	   << " lines were wrapped because of length\n";
		}
		else
		{
			cerr << printer->getWrappedCount() 
		   	   << " line was wrapped because of length\n";
		}
	}
	delete ucs2Array;
	delete ucs2Buffer;
	exit (0);
}

static void
exitUsage ()
{ 
	cerr << UWidgetVersion();
	cerr << "\n";
	cerr << 
"usage: uniprint [-o output-file ] [-P printer] [-f truetype-font]\n";
	cerr << 
"       [-t tab-stops] [-s font-size] [-S header-font-size] [-e body-encoding]\n";
	cerr << 
"       [-E header-encoding] [-H header-string] [unicode-input-file]\n";
	exit (1);
}
