//  UWidget.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#ifndef __uwidget_h__
#define __uwidget_h__

#include "UFont.h"
#include "UCursor.h"
#include "UString.h"
#include <X11/Xlib.h>
#include "UInput.h"
#include "UXInput.h"
#include "UPixmapCache.h"


class UWidget : public UWidgetX
{
public:
	enum UDrawType		{D_ADJUST, D_ASNEEDED, D_REVERSE, 
					D_NORMAL, D_NORMAL_FILL};
	enum USubDrawType	{S_ADJUST, S_REVERSE, S_NORMAL, S_NORMAL_FILL};
	enum UEditable		{ EDITABLE, VIEW, CURSOROFF };
	enum UMultiLine		{ MULTILINE_SCROLL, MULTILINE, 
				 SINGLE_SCROLL, SINGLE };

				UWidget (const char* nameIn, 
					const UMultiLine multiLineIn
							=MULTILINE_SCROLL, 
					const UEditable editableIn=EDITABLE);

				UWidget (const char* nameIn, 	
					Display* displayIn, Window windowIn, 
					const UMultiLine multiLineIn
						=MULTILINE_SCROLL, 
					const UEditable editableIn=EDITABLE);

	virtual			~UWidget();
					
	enum UStatus 		{OK, ERROR};

	// People like to define thse in headers so we put U_ in front.
	enum UMouseButton 	{UB_LEFT, UB_MIDDLE, UB_RIGHT};
	enum UKey		{UK_ASCII, UK_LEFT, UK_RIGHT,UK_UP, UK_DOWN, 
				UK_NEXT, UK_PRIOR, UK_DELETE, 
				UK_BACKSPACE, UK_HOME, UK_END, UK_RETURN,
				UK_XINPUT_TOGGLE,
				UK_CNTRL_LEFT, UK_CNTRL_RIGHT,
				UK_CNTRL_UP, UK_CNTRL_DOWN,
				UK_CNTRL_PRIOR, UK_CNTRL_NEXT,
				UK_CNTRL_HOME, UK_CNTRL_END,
				UK_CNTRL_RETURN, UK_SHIFT_RETURN };

	UStatus			uSetWidget (
					Display* 	displayIn,
					Window 		windowIn );
	UStatus			uSetInput (const char* kmap);
	inline void		uSetXInput (UXInput*	xinputIn) {uXInput=xinputIn; }
	// It will copy the font...
	UStatus			uSetFont  (UFont* font);
	UStatus			uSetFont  (const char* font);
	UStatus 		uSetFontSize (const int pixel);
	UStatus 		uSetFontSlant (const char* slant);
	UStatus 		uSetFontWeight (const char* weight);
	UStatus 		uSetFontSpacing (const char* spacing);
	UStatus 		uSetFontAvgWidth (const char* avgWidth);
	UStatus 		uSetFontAddStyle (const char* addStyle);

	UString::UStatus	uSetConverter (const char* nameIn);
	UStatus			uClear  ();
	void 			uHandleEvent (XEvent *event);
	void			uRedraw (const int x=0, const int y=0, 
					const int width=0, const int height=0);

	// They need refresh
	void			uSetBackground (unsigned long bg);
	void			uSetForeground (unsigned long fg);
	void			uSetCursorColor (unsigned long cr);
	void			uSetEditable (const UEditable	editableIn);
	void			uSetMultiLine (const UMultiLine multiLineIn);

	// use delete to free up memory
	
	unsigned char*		uGetMarkedText(int* len);

	void 			uInsertUCS2 (const UCS2 *ucs2, 
					const int length,
					const int moveCursor=1, 
					const int newLineIn=0);

	// qery current position and append. need refresh
	void			uAppendText (
					const unsigned char *text,
					const int length,
					const int moveCursor=0,
					const int newLine=0);

	// qery current position and append. need refresh
	void 			uInsertText (
					const unsigned char *text,
					const int length,
					const int moveCursor=0,
					const int newLine=0);

	void			uDeleteText (const UPoint& from, 
					const UPoint& to);

	unsigned char* 		uGetLine (const int lineNo, int* len);
	unsigned char* 		uGetBuffer (int* bufLen);

	// lowest level
	void			uInsertLineUCS2 (UPoint& currentP,
					const UCS2 *string, const int from, 
					const int to, const int newLine=1);

	void			uClipboardClear();


	virtual void		uResize (const int widthIn, const int heightIn,
					const int cornerX=0, 
					const int cornerY=0);
	void			uSetFullSize(); // do it if you made changes
						// that affect sizes
	void			uRefresh ();
	void			uVScroll (int value);
	void			uHScroll (int value);
	void			uSetCursor (const UCursor::UType type, const int all=0);
	void 			uSetCursorXY (const int x, const int y);
	virtual void 		uSetCursorViewable ();
	inline int		uGetCursorX () { return uCursorBox.at.posX; }
	inline int		uGetCursorY () { return uCursorBox.at.posY; }
	void			uProcKeyPressEvent (const UKey key, const int asci=0);
	void			uProcMousePressEvent (const UMouseButton but, 
					const int xIn, const int yIn);
	void			uProcMouseReleaseEvent (const UMouseButton but, 
					const int xIn, const int yIn);
	void			uProcMouseMotionEvent (const UMouseButton but, 
					const int xIn, const int yIn);
	void			uSetTabSize (const int tabsize);
	inline void		uClearModified () { modified = 0; }
	inline int		uIsModified () { return modified; }
	virtual void		uXIMStart ();
	virtual void		uXIMEnd ();
	virtual void		uXIMFail ();
	virtual int		uDeleteSelection ();
	inline const UCS2* const *	uGetTextBuffer() const
				{ return uTextBuffer; };
	inline const int*		uGetTextSizes() const
				{ return uTextSizes; };

	inline int		uGetTextSize() const
				{ return uTextSize; };

	int			uFindUCS2 (const UCS2* text, const int len, int fromBegin=0);
	int			uReplaceUCS2 (const UCS2* text, const int len);
	int			uGoTo (int lineNo);
	void			uClearXInput();

	UStatus			uSetXInput(const char* name,
					const char*	imIn,
					const char*	inputStyleIn,
					const char*	textType,
					const char*	uStringIn,
					const char*	font,
					double		verisonIn=0.0);
				// Inherit everything except window and
				// what..not...
	void			uInherit (UWidget *uwidgetIn);
	int			uIsEditable() { return editable == EDITABLE; };

	// This depends on only font parameters.
	int			uMinimumHeight ();
	int			uMinimumWidth ();

protected:
	int			modified;
	// These two are hooked.
	virtual void		uClipboardPut (const unsigned char *text, const int len);
	virtual unsigned char*	uClipboardGet (int *len);

	// min is zero, increment is 1
	virtual void		uSetVScroll (int value, int step, int page, int max);
	virtual void		uSetHScroll (int value, int step, int page, int max);
	void			uBlinkCursor(const int lastBlink=0);
	UXInput*		uXInput;
private:
	UPixmapCache*		pixmapFonts;
	UInput*			uInput;

	// One nice day they will be in a structure
	int*			uTextSizes;
	int*			uTextTabSizes;
	int*			uTextCtrlSizes;
	UCS2**			uTextBuffer;
	int			uTextSize;

	UString*		uString;
	int			tabSize;
	int			uTextBufferSize;

	char*			name;

	// SGC
	UEditable		editable;
	UMultiLine		multiLine;

// cursors
enum	UCursorState		{US_ON, US_OFF, US_FROZEN_ON, US_FROZEN_OFF};
	UCursorState		cursorState;

	UPoint			underLine[2];
	UPoint			reversePoints[2];
	UPoint			dragPoint;
	int			startDrag;
	int			reverseP;

	void 			getCursorPosition (UCursorBox* pos);

	void			getTextPosition (const int inX, const int inY, 
					int* outX, int* outY);

	void			drawCursor(UCursorState state=US_ON);
	void			hideCursor();

	void			drawUnderLine ();
	void			hideUnderLine ();

	void			drawVisibleSegments (const UPoint& from, 
					const UPoint& to, 
					UDrawType type, int fillEnd = 1);

	int			drawSegments (UPoint& from,
					const UPoint& to,
					const UDrawType type=D_ADJUST);

	int			drawSegment (UPoint& from, 
					const UPoint& to,
					const UCS2* text,
					UFontCache* fontCache,
					const USubDrawType type);

	void			startSelection (const int coordXIn, 
					const int coordYIn,
					const int xIn, const int yIn);
	void			continueSelection (const int coordXIn, 
					const int coordYIn,
					const int xIn, const int yIn);
	void			endSelection (const int coordXIn, 
					const int coordYIn,
					const int xIn, const int yIn);
	void			clearSelection();
	int			clipboardActive;

	XChar2b*		char2BBuf;
	int			char2BLen;
};

#endif /* __uwidget_h__ */
