//  UScroll.h version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#ifndef __uscroll_h_
#define __uscroll_h_

// A simple frame. It draws an arrow.
#include "UTop.h"
#include "UFrame.h"
#include "UArrowButton.h"
#include "UColor.h"

class UScroll : public UFrame
{
public:
	enum UScrollStyle { VERTICAL, HORIZONTAL };
	enum UGranuality { GRANUAL, NONGRANUAL };
			UScroll  (UFrame* parent_, UScrollStyle=VERTICAL);
	virtual		~UScroll ();

	
	virtual int		isA (UComponent::UType type);
	virtual void		eventDown (UEvent* event);
	virtual void		eventUp (UEvent* event);
	virtual void		resize (int width, int height);
	void 			scroll(int value, int step, int page, int max);
	void 			scroll(int value);
	void			setGranuality (UGranuality gr);
	virtual void		setBackground (const UColor& color);
	virtual void 		setBackground (const char* color);
	inline int		getValue () { return scrollValue; } 
protected:
	void 			slideTo (int sliderValue);
	int			scrollValue;
	int			scrollStep;
	int			scrollPage;
	int			scrollMax;
	UGranuality		granuality;

	UArrowButton*		inc;
	UArrowButton*		dec;
	UArrowButton*		slide;
	UScrollStyle		scrollStyle;

private:
	// covenience 
	int			sliderSize;
	double			scaleFactor;
	int			sliderPosition;
	int			xRoot;
	int			yRoot;
	int			presedPos;
};

#endif /* __uscroll_h_ */
