//  UChoiceDialog.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#define CMARGIN 4
#define MARGIN 10
#define BUTTON_MARGIN 20

#include "UChoiceDialog.h"
#include "UTextButton.h"
#include "UTextLabel.h"
#include "UTextMenu.h"
#include "UButton.h"
#include "UChoice.h"
#include "UScrolledList.h"
#include "strings.h"

UChoiceDialog::UChoiceDialog (UShell* transient_, 
	int choiceCount_, int frameSize_) :
	UDialog (transient_, frameSize_)
{
	choiceCount = choiceCount_;
	setUp();
}

UChoiceDialog::UChoiceDialog (UTop* top_, 
	int choiceCount_, int frameSize_) :
	UDialog (top_, frameSize_)
{
	choiceCount = choiceCount_;
	setUp ();
}

void 
UChoiceDialog::setUp()
{
	int	i;

	component[OK] = new UTextButton (this, "OK");
	component[OK]->setMargin (CMARGIN);
	component[CANCEL] = new UTextButton (this, "CANCEL");
	component[CANCEL]->setMargin (CMARGIN);
	lastButton = CANCEL;
	component[LABEL] = new UTextLabel (this, "Print", UTextLine::CENTER);
	component[LABEL]->setMargin (CMARGIN);

	frame[LEFT] = new UFrame (this, 0);
	frame[RIGHT] = new UFrame (this, 0);

	choice = new UComponent*[choiceCount];
	choiceLabel = new UComponent*[choiceCount];
	selected = new AString[choiceCount];
	for (i=0; i<choiceCount; i++)
	{
		choiceLabel[i] = new UTextLabel (frame[LEFT], 0,
			UTextLine::RIGHT);
		choiceLabel[i]->setMargin (CMARGIN);
		choice[i] = new UChoice ( frame[RIGHT]);
		choice[i]->setMargin (CMARGIN);
	}
	rectangle.width = 20;
	rectangle.height = 20;
}

UChoiceDialog::~UChoiceDialog ()
{
	// autodelete
	delete choice;
	delete choiceLabel;
	delete selected;
}

#define MAXVLE(_a, _b) ((_a>_b)?_a:_b)

const UBestSize&
UChoiceDialog::getBestSize ()
{
	UBestSize	bsComp[COMP_MAX];
	UBestSize*	bsChoice;
	UBestSize*	bsChoiceLabel;
	int*		heights;
	int		widths[SIDE_MAX];
	int		acctY;
	int		frameHeight;
	int		i;

	heights = new int [choiceCount];
	bsChoice = new  UBestSize[choiceCount];
	bsChoiceLabel = new  UBestSize[choiceCount];

	for (i=0; i<(int)COMP_MAX; i++)
	{
		bsComp[i] = component[i]->getBestSize ();
	}

	bsComp[OK].width = MAXVLE (bsComp[OK].width, bsComp[CANCEL].width);
	bsComp[CANCEL].width = bsComp[OK].width;

	widths[LEFT] = frameSize;
	widths[RIGHT] = frameSize;
	frameHeight = 0;
	acctY = 0;
	for (i=0; i<choiceCount; i++)
	{
		bsChoiceLabel[i] = choiceLabel[i]->getBestSize ();
		bsChoice[i] = choice[i]->getBestSize ();
		heights[i] = MAXVLE (bsChoiceLabel[i].height, bsChoice[i].height);
		widths[LEFT] = MAXVLE (bsChoiceLabel[i].width, widths[LEFT]);
		widths[RIGHT] = MAXVLE (bsChoice[i].width, widths[RIGHT]);
		frameHeight += heights[i];
		choiceLabel[i]->place (0, 
			 acctY + (heights[i]-bsChoiceLabel[i].height)/2, 
			0, -acctY-(heights[i]+bsChoiceLabel[i].height)/2);
		choice[i]->place (0, acctY + (heights[i]-bsChoice[i].height)/2, 
			-bsChoice[i].width, 
			-acctY - (heights[i]+bsChoice[i].height)/2);
		acctY += heights[i];
	}

	// place all components
	acctY=MARGIN;
	component[LABEL]->place(MARGIN, acctY, MARGIN, -bsComp[LABEL].height-acctY);
	acctY += bsComp[LABEL].height;
	frame[LEFT]->place (MARGIN, acctY, -widths[LEFT]-MARGIN, -frameHeight-acctY);
	frame[RIGHT]->place (-widths[RIGHT]-MARGIN, acctY, MARGIN, -frameHeight-acctY);
	acctY += frameHeight;

	component[CANCEL]->place (-bsComp[CANCEL].width-MARGIN, 
			-bsComp[CANCEL].height-MARGIN, 
			MARGIN, MARGIN);
	component[OK]->place (MARGIN, -bsComp[OK].height-MARGIN, 
			-bsComp[OK].width-MARGIN, MARGIN);

	bestSize.width = 0;
	
#if 0
	bestSize.width = bsComp[LABEL].width;
	if (bestSize.width > XDisplayWidth (top->display, top->screen)/2)
	{
		bestSize.width = XDisplayWidth (top->display, top->screen)/2;
	}
#endif
	bestSize.width = MAXVLE (bestSize.width, widths[LEFT] + widths[RIGHT]);
	bestSize.width = MAXVLE (bestSize.width, 2*bsComp[CANCEL].width);
	bestSize.height = bsComp[LABEL].height + frameHeight + bsComp[OK].height;
	bestSize.width += 2*MARGIN;
	bestSize.height += 3*MARGIN;

	minimumWidth = bestSize.width;
	minimumHeight = bestSize.height;
	if (rectangle.width > bestSize.width) bestSize.width = rectangle.width;
	if (rectangle.height > bestSize.height) bestSize.height = rectangle.height;
	delete heights;
	delete bsChoice;
	delete bsChoiceLabel;

	return bestSize;
}

UDialog::UValue
UChoiceDialog::getValue()
{
	lastButton = CANCEL;
	UDialog::getValue();
	if (lastButton==OK) return (UDialog::OK);
	return  (UDialog::CANCEL);
}

void
UChoiceDialog::setButtonFont (UFont* font_)
{
	int i;
	component[OK]->setFont (font_);
	component[CANCEL]->setFont (font_);

	for (i=0; i<choiceCount; i++)
	{
		choice[i]->setFont (font_);
	}
}

void
UChoiceDialog::setTextFont (UFont* font_)
{
	int i;
	component[LABEL]->setFont (font_);

	for (i=0; i<choiceCount; i++)
	{
		((UTextLabel*)choiceLabel[i])->setFont (font_);
	}
}

void
UChoiceDialog::setText (USubComponent comp_, const char* utf8_)
{
	switch (comp_)
	{
	case CANCEL:
	case OK:
		((UTextButton*) component[comp_])->setText (utf8_);
		break;
	case LABEL:
		((UTextLabel*) component[comp_])->setText (utf8_);
		((UTextLabel*) component[comp_])->selectLine (0);
		break;
	default:
		break;
	}
}
void
UChoiceDialog::setChoice (int loc, const char* labelString,
	const char* selected_, const AStringList& name_, 
	const AStringList& translatedName_)
{
	UPopUp* 	pup;
	int		i;
	const char*	selectedName;

	if (name_.getSize() != translatedName_.getSize())
	{
		cerr << "setChoice: name and translation mismatch\n"; 
		return;
	}
	// find out translation for selected
	selectedName = selected_;
	for (i=0; i<name_.getSize(); i++)
	{
		if (strcmp (selected_, name_.at(i))==0)
		{
			selectedName = translatedName_.at(i);
		}
	}
	pup = new UPopUp (((UChoice*)choice[loc]),
		selected_, selectedName, 
		UMenu::NO_LEFT, UMenu::DOWN);

	for (i=0; i<name_.getSize(); i++)
	{
		(void) new UTextMenu (pup, name_.at(i), 
			translatedName_.at(i),  UMenu::NO_LEFT,
			 UMenu::ARROW_BLANK);
	}
	((UTextLabel*)choiceLabel[loc])->setText (labelString);
	selected[loc] = selected_;
}

const char*
UChoiceDialog::getSelected (int loc)
{
	return ((const char*) selected[loc]);
}

void	
UChoiceDialog::eventUp (UEvent* event)
{
	UPopUp* 	popUp;
	AString		newDir;
	UTextMenu*	textMenu;
	UBestSize	bs;
	int		i;
	const UCS2* 	ucs2;

	switch (event->type)
	{
	case UEvent::ACTIVATED:
		if (event->client !=0 && event->client==component[CANCEL])
		{
			lastButton = CANCEL;
			hide ();
			return;
		}
		if (event->client !=0 && event->client==component[OK])
		{
			lastButton = OK;
			hide ();
			return;
		}
		break;
	case UEvent::MENU_SELECTION:
		for (i=0; i<choiceCount; i++)
		{
			if (event->client == choice[i]) break;
		}
		if (i>=choiceCount) break;
		popUp = (UPopUp*) event->popUp;
		if (popUp ==0) break;
		textMenu = (UTextMenu*) popUp->itemAt (event->value);
		if (textMenu ==0) break;
		ucs2 = textMenu->getText(0);
		if (ucs2 ==0) break;
		if (popUp->cascade==0) break;
		((UTextMenu*)popUp->cascade)->setText (ucs2);
		((UTextMenu*)popUp->cascade)->setName (textMenu->getName());
		selected[i] = textMenu->getName();

		bs = ((UChoice*)choice[i])->getBestSize();
		choice[i]->resize (bs.width-2*CMARGIN, 
			choice[i]->rectangle.height);
		break;
	default:
		UShell::eventUp (event);
		break;
	}
}

