/************************************************************************/
/*									*/
/*  Simple io streams using blocks of memory.				*/
/*									*/
/************************************************************************/

#   ifndef	SIO_MEMORY_H
#   define	SIO_MEMORY_H

#   include	<sioGeneral.h>

typedef struct MemoryBuffer
    {
    int			mbCapacity;
    unsigned char *	mbBytes;
    } MemoryBuffer;

extern void sioMemoryInit(	MemoryBuffer *	mb	);
extern void sioMemoryClean(	MemoryBuffer *	mb	);

extern SimpleInputStream * sioInMemoryOpen(	MemoryBuffer *	mb );

extern SimpleOutputStream * sioOutMemoryOpen(	MemoryBuffer *	mb );

#   endif
