/************************************************************************/
/*  Attributes of text.							*/
/************************************************************************/

#   ifndef	DOC_FONT_H
#   define	DOC_FONT_H

typedef struct TextAttribute
    {
    short int		taFontNumber;
    unsigned int	taFontSizeHalfPoints:10;
    unsigned int	taFontIsBold:1;
    unsigned int	taFontIsSlanted:1;
    unsigned int	taIsUnderlined:1;
    unsigned int	taInField:1;
    unsigned int	taSuperSub:2;
#   define		DOCfontREGULAR		0
#   define		DOCfontSUPERSCRIPT	1
#   define		DOCfontSUBSCRIPT	2
    } TextAttribute;

#   define	TAmaskFONTFAMILY		0x0001
#   define	TAmaskFONTSIZE			0x0002
#   define	TAmaskFONTBOLD			0x0004
#   define	TAmaskFONTSLANTED		0x0008
#   define	TAmaskTEXTUNDERLINED		0x0010
#   define	TAmaskTEXTINFIELD		0x0020
#   define	TAmaskSUPERSUB			0x0040

#   define	TAmaskALL			0x007f

#   define	docEqualFontAttributes(ta1,ta2) ( \
		(ta1)->taFontIsBold == (ta2)->taFontIsBold && \
		(ta1)->taFontIsSlanted == (ta2)->taFontIsSlanted )

#   define	docEqualFont(ta1,ta2) ( \
		(ta1)->taFontNumber == (ta2)->taFontNumber && \
		(ta1)->taFontSizeHalfPoints == (ta2)->taFontSizeHalfPoints && \
		(ta1)->taSuperSub == (ta2)->taSuperSub && \
		docEqualFontAttributes( (ta1), (ta2) ) )

#   define	docEqualTextAttributes(ta1,ta2) ( \
		docEqualFont((ta1),(ta2)) && \
		(ta1)->taIsUnderlined == (ta2)->taIsUnderlined && \
		(ta1)->taInField == (ta2)->taInField )

/************************************************************************/
/*  What attributes changed?						*/
/************************************************************************/

#    define	TEDcmFONTNUMBER	0x01
#    define	TEDcmFONTSIZE	0x02
#    define	TEDcmFONTBOLD	0x04
#    define	TEDcmFONTITALIC	0x08
#    define	TEDcmUNDERLINE	0x10

/************************************************************************/
/*  Font Administration.						*/
/************************************************************************/

#   define	FONTwidthNARROW		0
#   define	FONTwidthCONDENSED	1
#   define	FONTwidthNORMAL		2
#   define	FONTwidthEXTENDED	3

typedef struct DocumentFontInstance
    {
    TextAttribute	dfiAttribute;
    int			dfiPrivateFont;
    int			dfiPsFaceNumber;
    } DocumentFontInstance;

typedef struct DocumentFont
    {
    char *			dfFamilyStyle;	/*  fnil, fswiss ..	*/
    char *			dfName;		/*  Helvetica,		*/
						/*  Helvetica Narrow.	*/
    int				dfDocFamilyNumber;/*  f0, f1 ...	*/

    int				dfPsFamilyNumber;

    int				dfInstanceCount;
    DocumentFontInstance *	dfInstances;

    int				dfCharset;	/*  fcharsetN		*/

    int				dfPitch;	/*  fprqN		*/
    } DocumentFont;

#   define FONTpitchDEFAULT		0
#   define FONTpitchFIXED		1
#   define FONTpitchVARIABLE		2

#   define FONTcharsetDEFAULT		1
#   define FONTcharsetSYMBOL		2
#   define FONTcharsetOEM		255
#   define FONTcharsetANSI		0		/*  cpg 1252	*/
#   define FONTcharsetRUSSIAN		204		/*  cpg 1251	*/
#   define FONTcharsetEE		238		/*  cpg 1250	*/
#   define FONTcharsetGREEK		161		/*  cpg 1253	*/
#   define FONTcharsetTURKISH		162		/*  cpg 1254	*/
#   define FONTcharsetBALTIC		186		/*  cpg 1257	*/
#   define FONTcharsetHEBREW		177		/*  cpg 1255	*/
#   define FONTcharsetARABIC		178		/*  cpg 1256	*/
#   define FONTcharsetSHIFTJIS		128		/*  cpg 932	*/
#   define FONTcharsetHANGEUL		129		/*  cpg 949	*/
#   define FONTcharsetGB2313		134		/*  cpg 936	*/
#   define FONTcharsetCHINESEBIG5	136		/*  cpg 950	*/

typedef struct DocumentFontList
    {
    int			dflCount;
    DocumentFont *	dflFonts;
    } DocumentFontList;

/************************************************************************/
/*									*/
/*  Font information.							*/
/*									*/
/*  Used to map a users idea of fonts to implementation fonts.		*/
/*  Used by the font chooser to select fonts.				*/
/*									*/
/************************************************************************/
typedef struct AppFontTypeface
    {
    char *			aftFaceName;
    int *			aftSizes;
    int				aftSizeCount;
    unsigned int		aftIsBold:1;
    unsigned int		aftIsSlanted:1;
    unsigned int		aftIsScalable:1;
    unsigned int		aftIsFixedWidth:1;
    void *			aftPrintingData;
    char *			aftXQueryFormat;
    int				aftWidth;
    } AppFontTypeface;

typedef struct AppFontFamily
    {
    char *		affFontFamilyName;
    char *		affFontFamilyText;
    AppFontTypeface *	affFaces;
    int			affFaceCount;
    unsigned int	affHasFixedWidth:1;
    unsigned int	affHasProportionalWidth:1;
    unsigned int	affWidth;
					/********************************/
    unsigned int	affEncoding;	/*  Different meaning for	*/
					/*  PostScript and X11		*/
					/********************************/
    } AppFontFamily;

/************************************************************************/
/*									*/
/*  Default attributes.							*/
/*									*/
/************************************************************************/
extern TextAttribute   DocDefaultAttributes;

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/

extern void docInitFontFamily(	AppFontFamily *	aff );

extern void docInitFont(	DocumentFont *	df );

extern void docCleanFont(	DocumentFont *	df );

extern void docInitFontList(	DocumentFontList *	dfl );

extern void docCleanFontList(	DocumentFontList *	dfl );

extern const char *	docFontFamilyStyle( const char * fontFamilyName );

extern DocumentFont *	docInsertFont(	DocumentFontList *	dfl,
					int			n,
					const char *		familyStyle,
					const char *		fontName );

extern void docInitTextAttribute(	TextAttribute *	ta	);

extern unsigned int docAttributeDifference(	TextAttribute		ta1,
						TextAttribute		ta2,
						unsigned int		m );

extern int docFontCompareFaces(	const void *	veft1,
				const void *	veft2 );

extern int docGetFontByName(	DocumentFontList *	dfl,
				const char *		fontFamilyName );

#   endif	/*  DOC_FONT_H	*/
