/************************************************************************/
/*  Management of X11 fonts: Translation of understandable fonts to	*/
/*  X11 structures.							*/
/************************************************************************/

#   ifndef	APP_FONT_H					/*  {{	*/
#   define	APP_FONT_H

#   include	<X11/Xlib.h>
#   include	<X11/Intrinsic.h>
#   include	<docFont.h>
#   include	<appDraw.h>
#   include	<psFont.h>
#   include	<appTool.h>

typedef void (*FontChooserSetFont)( void * target,
	char * familyText, int familyNumber, int bold, int slant, int size );

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/

extern void appInitFontList(	AppPhysicalFontList *	apfl );
extern void appCleanFontList(	Display *		display,
				AppPhysicalFontList *	apfl );

extern void appEnableFontsTool(	void *	voidafc,
				int	enabled );

extern void appFontToolTextReadonly(	void *	voidafc,
					int	readonly );

extern void appShowFontsTool(		void *	voidefc	);

extern int appFontCatalog(	Display *		display,
				AppFontFamily **	pFamilies,
				int *			pCount		);

extern void appFontFormatCurrent(	char *			target,
					AppFontFamily *		aff,
					AppFontTypeface *	aft,
					int			size	);

extern int appFontXFont(	char *			target,
				Display *		display,
				double			magnifiedPixelsPerTwip,
				AppFontFamily *		aff,
				AppFontTypeface *	aft,
				int			twipsSize,
				int			variant );

extern int appOpenDocumentFont(	AppDrawingData *	add,
				DocumentFontList *	dfl,
				TextAttribute		ta	);

extern int appFontSetCurrentFont(	void *		voidefc,
					int		fontFamilyNumber,
					unsigned int	updMask,
					TextAttribute	taNew );

extern void appFontAttributeString(	char *			target,
					const char *		familyName,
					unsigned int		updMask,
					TextAttribute		taNew );

extern int appFontGetAttributes(	char *			attributeString,
					char **			pFamilyName,
					unsigned int *		pUpdMask,
					TextAttribute *		pTaNew );

extern int appGetPsFont(	int *			pFamily,
				int *			pFace,
				AppFontFamily **	pAff,
				AppFontTypeface **	pAft,
				const char *		afmDirectory,
				const DocumentFont *	df,
				TextAttribute		ta );

extern int appCharExistsInFont(	const XFontStruct *	xfs,
				int			ch );

#   endif							/*  }}  */
