/************************************************************************/
/*  Color mangement on X11: Try to get around the limitations.		*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>
#   include	<math.h>

#   include	"appColor.h"

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Allocate approximate colors.					*/
/*									*/
/************************************************************************/

int appColorRgb111(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    unsigned int	col111= C111( r, g, b );

    if  ( ac->ac222Colors[col111].pad == 1 )
	{
	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	ac->ac222Colors[col111].red=	( r << 8 ) | r;
	ac->ac222Colors[col111].green=	( g << 8 ) | g;
	ac->ac222Colors[col111].blue=	( b << 8 ) | b;

	ac->ac222Colors[col111].flags= DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( ac->acDisplay, ac->acColormap,
						    ac->ac222Colors+ col111 ) )
	    { LDEB(col111); return -1;	}

	/*
	printf( "%3d: %3d %3d %3d %6ld (111)\n",
			    col111, r, g, b, ac->ac222Colors[col111].pixel );
	*/

	ac->ac222Colors[col111].pad= 0;
	}


    *xc= ac->ac222Colors[col111];
    return 0;
    }

int appColorRgb222(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    unsigned int	col222= C222( r, g, b );

    if  ( ac->ac222Colors[col222].pad == 1 )
	{
	r= ( 255* ( r & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	g= ( 255* ( g & 0xc0 ) + 0xc0/ 2 )/ 0xc0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	ac->ac222Colors[col222].red=	( r << 8 ) | r;
	ac->ac222Colors[col222].green=	( g << 8 ) | g;
	ac->ac222Colors[col222].blue=	( b << 8 ) | b;

	ac->ac222Colors[col222].flags= DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( ac->acDisplay, ac->acColormap,
						    ac->ac222Colors+ col222 ) )
	    { LDEB(col222); return -1;	}

	/*
	printf( "%3d: %3d %3d %3d %6ld (222)\n",
			    col222, r, g, b, ac->ac222Colors[col222].pixel );
	*/

	ac->ac222Colors[col222].pad= 0;
	}


    *xc= ac->ac222Colors[col222];
    return 0;
    }

int appColorRgb555(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    unsigned int	col555= C555( r, g, b );

    if  ( ac->acColors[col555].pad == 1 )
	{
	r= ( 255* ( r & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	g= ( 255* ( g & 0xf1 ) + 0xf1/ 2 )/ 0xf1;
	b= ( 255* ( b & 0xf1 ) + 0xf1/ 2 )/ 0xf1;

	ac->acColors[col555].red=	( r << 8 ) | r;
	ac->acColors[col555].green=	( g << 8 ) | g;
	ac->acColors[col555].blue=	( b << 8 ) | b;

	ac->acColors[col555].flags= DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( ac->acDisplay, ac->acColormap,
						    ac->acColors+ col555 ) )
	    {
	    if  ( appColorRgb222( ac->acColors+ col555, ac, r, g, b ) )
		{ LDEB(col555); return -1;	}

	    ac->acColors[col555].pad= 2;

	    *xc= ac->acColors[col555];
	    return 0;
	    }

	ac->acColors[col555].pad= 0;
	}

    /*
    printf( "%3d: %3d %3d %3d %6ld (555)\n",
				col555, r, g, b, ac->acColors[col555].pixel );
    */

    *xc= ac->acColors[col555];
    return 0;
    }

int appColorRgb332(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    unsigned int	col332= C332( r, g, b );

    if  ( ac->acColors[col332].pad == 1 )
	{
	r= ( 255* ( r & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	g= ( 255* ( g & 0xe0 ) + 0xe0/ 2 )/ 0xe0;
	b= ( 255* ( b & 0xc0 ) + 0xc0/ 2 )/ 0xc0;

	ac->acColors[col332].red=	( r << 8 ) | r;
	ac->acColors[col332].green=	( g << 8 ) | g;
	ac->acColors[col332].blue=	( b << 8 ) | b;

	ac->acColors[col332].flags= DoRed | DoGreen | DoBlue;

	if  ( ! XAllocColor( ac->acDisplay, ac->acColormap,
						    ac->acColors+ col332 ) )
	    {
	    if  ( appColorRgb222( ac->acColors+ col332, ac, r, g, b ) )
		{ LDEB(col332); return -1;	}

	    ac->acColors[col332].pad= 2;

	    *xc= ac->acColors[col332];
	    return 0;
	    }

	ac->acColors[col332].pad= 0;
	}

    /*
    printf( "%3d: %3d %3d %3d %6ld (332)\n",
				col332, r, g, b, ac->acColors[col332].pixel );
    */

    *xc= ac->acColors[col332];
    return 0;
    }

int appColorRgb(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    if  ( ac->acVisualClass ==	TrueColor	||
	  ac->acVisualClass ==	DirectColor	)
	{
	appColorRgbDirect( xc, ac, r, g, b );
	return 0;
	}

    switch( ac->acDepth )
	{
	case  1:
	    return appColorRgb111( xc, ac, r, g, b );
	case  2: case  4:
	    return appColorRgb222( xc, ac, r, g, b );
	case  8:
	    return appColorRgb332( xc, ac, r, g, b );
	case 16:
	    return appColorRgb555( xc, ac, r, g, b );
	case 24:
	case 32:
	default:
	    LDEB(ac->acDepth); return -1;
	}

    }

int appColorNamed(	XColor *	xc,
			AppColors *	ac,
			char *		name )
    {
    XColor	exact;
    XColor	screen;

    if  ( ! XLookupColor( ac->acDisplay, ac->acColormap, name,
					    &exact, &screen ) )
	{ SDEB(name); return -1;	}

    return appColorRgb( xc, ac,
			exact.red/257, exact.green/257, exact.blue/257 );
    }

/************************************************************************/
/*									*/
/*  Allocate colors for an image.					*/
/*									*/
/************************************************************************/
static int scanPixCmp(		const void *	vpix1,
				const void *	vpix2 )
    {
    Pixel	pix1= *(Pixel *)vpix1;
    Pixel	pix2= *(Pixel *)vpix2;

    if  ( pix1 > pix2 )
	{ return  1;	}
    if  ( pix1 < pix2 )
	{ return -1;	}

    return 0;
    }

static void appTry222Color(	Display *	display,
				Colormap	cmap,
				AppColors *	ac,
				double		dists[64],
				Pixel		l )
    {
    XColor		xc;
    int			c222;

    xc.pixel= l;

    if  ( ! XQueryColor( display, cmap, &xc ) )
	{ return;	}

    c222= C222( (int)(xc.red/256), (int)(xc.green/256), (int)(xc.blue/256) );

    if  ( ac->ac222Colors[c222].pad == 0 )
	{
	double		c;
	double		d= 0;

	c= xc.red-   (256*256-1)* ( ( ( c222 & 0x30 ) >> 4 ) / 3 ); d += c* c;
	c= xc.green- (256*256-1)* ( ( ( c222 & 0x0c ) >> 2 ) / 3 ); d += c* c;
	c= xc.blue-  (256*256-1)* ( ( ( c222 & 0x03 ) >> 0 ) / 3 ); d += c* c;

	if  ( sqrt( d ) > dists[c222] )
	    { return;	}
	}

    if  ( XAllocColor( display, cmap, &xc )	)
	{
	if  ( xc.pixel == l )
	    {
	    if  ( ac->ac222Colors[c222].pad == 1 )
		{
		ac->ac222Colors[c222]= xc;
		ac->ac222Colors[c222].pad= 0;
		}
	    else{ XFreeColors( display, cmap, &xc.pixel, 1, 0L ); }
	    }
	else{ XFreeColors( display, cmap, &xc.pixel, 1, 0L ); }
	}
    }

static char *APP_VisualClasses[]=
    {
    "StaticGray",
    "GrayScale",
    "StaticColor",
    "PseudoColor",
    "TrueColor",
    "DirectColor",
    };

int appAllocateColors(	Display *		display,
			AppColors *		ac )
    {
    int			screen= DefaultScreen( display );
    int			depth= DefaultDepth( display, screen );
    Colormap		cmap= DefaultColormap( display, screen );
    Visual *		vis= DefaultVisual( display, screen );

    XVisualInfo		visualInfo;
    XVisualInfo *	visuals;

    long		mask;
    int			count;
    int			i;

    double		d[64];

    int			l, m, r;
    Pixel *		pxx;

    ac->acDisplay= display;
    ac->acDepth= depth;
    ac->acColormap= cmap;

    visualInfo.visualid= XVisualIDFromVisual( vis );
    visuals= XGetVisualInfo( display, VisualIDMask, &visualInfo, &count );
    if  ( count != 1 )
	{ LDEB(count); return -1;	}
    visualInfo= *visuals;
    XFree( visuals );

#   ifdef __cplusplus
    ac->acVisualClass= visualInfo.c_class;
#   else
    ac->acVisualClass= visualInfo.class;
#   endif

    switch( ac->acVisualClass )
	{
	case StaticGray:
	case GrayScale:
	    switch( ac->acDepth )
		{
		case 1: case 2: case 4: case 8:
		    break;
		default:
		    SLDEB(APP_VisualClasses[ac->acVisualClass],ac->acDepth);
		}
	    break;

	case StaticColor:
	    SDEB(APP_VisualClasses[ac->acVisualClass]);
	    break;
	case PseudoColor:
	    break;
	case TrueColor:
	case DirectColor:
	    mask= visualInfo.red_mask; ac->acRedPixelShift= 0;
	    while( ! ( mask & 0x1 ) )
		{ ac->acRedPixelShift++; mask= mask >> 1;	}
	    ac->acRedMask= mask;
	    ac->acRedApproxShift= 8;
	    while( mask & 0x1 )
		{ ac->acRedApproxShift--; mask= mask >> 1;	}

	    mask= visualInfo.green_mask; ac->acGreenPixelShift= 0;
	    while( ! ( mask & 0x1 ) )
		{ ac->acGreenPixelShift++; mask= mask >> 1;	}
	    ac->acGreenMask= mask;
	    ac->acGreenApproxShift= 8;
	    while( mask & 0x1 )
		{ ac->acGreenApproxShift--; mask= mask >> 1;	}

	    mask= visualInfo.blue_mask; ac->acBluePixelShift= 0;
	    while( ! ( mask & 0x1 ) )
		{ ac->acBluePixelShift++; mask= mask >> 1;	}
	    ac->acBlueMask= mask;
	    ac->acBlueApproxShift= 8;
	    while( mask & 0x1 )
		{ ac->acBlueApproxShift--; mask= mask >> 1;	}

	    return 0;
	}

    switch( depth )
	{
	case  1: count= 2;		break;
	case  2: count= 4;		break;
	case  4: count= 16;		break;
	case  8: count= 256;		break;
	case 16: count= 256* 256;	break;
	case 24: return 0;
	case 32: return 0;
	default:
	    LDEB(depth); return -1;
	}

    for ( l= 0; l < 64; l++ )
	{ d[l]= 300000;	}

    ac->acColors= (XColor *)malloc( count* sizeof(XColor) );

    if  ( ! ac->acColors )
	{ LXDEB(count,ac->acColors); return -1;	}

    ac->acColorCount= count;

    for ( i= 0; i < count; i++ )
	{
	ac->acColors[i].pixel= 0;
	ac->acColors[i].pad= 1;
	}

    XGrabServer( display );

    l= 0; r= count; m= ( l+ r )/2;
    pxx= (Pixel *)malloc( count* sizeof( Pixel ) );
    while( l < m )
	{
	if  ( ! XAllocColorCells( display, cmap, False,
						(unsigned long *)0, 0,
						pxx, (unsigned)m ) )
	    { r= m; }
	else{
	    XFreeColors( display, cmap, pxx, m, 0L );
	    l= m;
	    }

	m= ( l+ r )/2;
	}

    if  ( m > 0 )
	{
	if  ( ! XAllocColorCells( display, cmap, False,
					    (unsigned long *)0, 0,
					    pxx, (unsigned)m ) )
	    { LDEB(m); XUngrabServer( display ); return -1; }
	}

    XUngrabServer( display );

    qsort( pxx, m, sizeof(Pixel), scanPixCmp );
    pxx[m]= count;

    l= 0; r= 0;
    if  ( m > 0 ) while( r <= m )
	{
	while( (unsigned)l < pxx[r] )
	    {
	    appTry222Color( display, cmap, ac, d, l );

	    l++;
	    }

	l++; r++;
	}
    else{
	if  ( count <= 256 )
	    {
	    for ( l= 0; l < count; l++ )
		{ appTry222Color( display, cmap, ac, d, l ); }
	    }
	}

    if  ( m > 0 )
	{ XFreeColors( display, cmap, pxx, m, 0L ); }

    free( pxx );

    return 0;
    }

void appCleanColors(	Display *		display,
			AppColors *		ac )
    {
    int			screen= DefaultScreen( display );
    Colormap            cmap= DefaultColormap( display, screen );
    int			i;

    for ( i= 0; i < 64; i++ )
	{
	if  ( ! ac->ac222Colors[i].pad )
	    {
	    XFreeColors( display, cmap, &(ac->ac222Colors[i].pixel), 1, 0L );
	    ac->ac222Colors[i].pad= 1;
	    }
	}

    for ( i= 0; i < ac->acColorCount; i++ )
	{
	if  ( ! ac->acColors[i].pad )
	    {
	    XFreeColors( display, cmap, &(ac->acColors[i].pixel), 1, 0L );
	    ac->acColors[i].pad= 1;
	    }
	}

    ac->acColorCount= 0;

    if  ( ac->acColors )
	{ free( ac->acColors ); ac->acColors= (XColor *)0;	}
    }

void appInitColors(	AppColors *	ac )
    {
    int			i;

    for ( i= 0; i < 64; i++ )
	{
	ac->ac222Colors[i].pixel= 0;
	ac->ac222Colors[i].pad= 1;
	}

    ac->acColors= (XColor *)0;
    ac->acColorCount= 0;
    }

int appColorFindRgb(	XColor *	xc,
			AppColors *	ac,
			int		r,
			int		g,
			int		b )
    {
    int		d;
    int		col;

    for ( d= 0; d < 128; d++ )
	{
	XColor *	cxc;

	cxc= ac->ac222Colors;
	for ( col= 0; col < 64; cxc++, col++ )
	    {
	    if  ( cxc->pad == 1 )
		{ continue;	}

	    if  ( cxc->red	> 256* ( r- d )		&&
		  cxc->red	< 256* ( r+ d )		&&
		  cxc->green	> 256* ( g- d )		&&
		  cxc->green	< 256* ( g+ d )		&&
		  cxc->blue	> 256* ( b- d )		&&
		  cxc->blue	< 256* ( b+ d )		)
		{ *xc= *cxc; return 0;	}
	    }

	cxc= ac->acColors;
	for ( col= 0; col < ac->acColorCount; cxc++, col++ )
	    {
	    if  ( cxc->pad == 1 )
		{ continue;	}

	    if  ( cxc->red	> 256* ( r- d )		&&
		  cxc->red	< 256* ( r+ d )		&&
		  cxc->green	> 256* ( g- d )		&&
		  cxc->green	< 256* ( g+ d )		&&
		  cxc->blue	> 256* ( b- d )		&&
		  cxc->blue	< 256* ( b+ d )		)
		{ *xc= *cxc; return 0;	}
	    }
	}

    return -1;
    }
