/************************************************************************/
/*  Ted, main module.							*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	"tedApp.h"
#   include	"tedRuler.h"
#   include	<appUtil.h>

#   include	<sioXprop.h>

#   include	<X11/keysym.h>

#   include	<debugon.h>

/************************************************************************/
/*									*/
/*  Just log events that pass by for debugging purposes.		*/
/*									*/
/*  NOTE the silly constuction to do away with the 'unused' compiler	*/
/*	 warning.							*/
/*									*/
/************************************************************************/
static void tedLogEvent(	Widget		w,
				void *		voided,
				XEvent *	event,
				Boolean *	pRefused	)
    {
    EditDocument *		ed= (EditDocument *)voided;

    DEBFUN( "EVENT \"%s\": %s\n",
			ed->edTitle, APP_X11EventNames[event->type] );

    *pRefused= True;

    if  ( ! event )
	{ tedLogEvent( w, voided, event, pRefused );	}
    }

/************************************************************************/
/*									*/
/*  Blinking cursor.							*/
/*									*/
/************************************************************************/
#   define	TED_BLINK_VISIBLE	(800L)
#   define	TED_BLINK_INVISIBLE	(400L)

static void tedHideIBar(	void *		voided,
				XtIntervalId *	intervalId );

static void tedShowIBar(	void *		voided,
				XtIntervalId *	intervalId )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;
    Widget			w= ed->edDocumentWidget;

    int				ox= ed->edVisibleRect.drX0;
    int				oy= ed->edVisibleRect.drY0;

    td->tdShowIBarId= (XtIntervalId)0;

    tedRedrawIBar( td, ox, oy, XtDisplay( w ), XtWindow( w ), ed->edGc );

    td->tdHideIBarId= XtAppAddTimeOut( ea->eaContext, TED_BLINK_VISIBLE,
						tedHideIBar, (void *)ed );
    }

static void tedHideIBar(	void *		voided,
				XtIntervalId *	intervalId )
    {
    EditDocument *		ed= (EditDocument *)voided;
    EditApplication *		ea= ed->edApplication;
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    td->tdHideIBarId= (XtIntervalId)0;

    tedUndrawIBar( ed );

    td->tdShowIBarId= XtAppAddTimeOut( ea->eaContext, TED_BLINK_INVISIBLE,
						tedShowIBar, (void *)ed );
    }

void tedStartCursorBlink(	XtAppContext	context,
				EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    tedStopCursorBlink( context, ed );

    td->tdHideIBarId= XtAppAddTimeOut( context, TED_BLINK_VISIBLE,
						tedHideIBar, (void *)ed );
    }

void tedStopCursorBlink(	XtAppContext	context,
				EditDocument *	ed )
    {
    TedDocument *		td= (TedDocument *)ed->edPrivateData;

    if  ( td->tdHideIBarId )
	{ XtRemoveTimeOut( td->tdHideIBarId ); }

    if  ( td->tdShowIBarId )
	{
	Widget			w= ed->edDocumentWidget;

	int			ox= ed->edVisibleRect.drX0;
	int			oy= ed->edVisibleRect.drY0;

	XtRemoveTimeOut( td->tdShowIBarId );

	tedRedrawIBar( td, ox, oy, XtDisplay( w ), XtWindow( w ), ed->edGc );
	}

    td->tdHideIBarId= (XtIntervalId)0;
    td->tdShowIBarId= (XtIntervalId)0;

    return;
    }

/************************************************************************/
/*									*/
/*  Handle mouse clicks.						*/
/*									*/
/************************************************************************/
#   define	TED_DRAG_INTERVAL	(150L)

typedef struct DraggingContext
    {
    XtAppContext		dcContext;
    XtIntervalId		dcIntervalId;
    int				dcMouseX;
    int				dcMouseY;
    BufferPosition		dcAnchorPosition;
    EditDocument *		dcEd;
    } DraggingContext;

static void tedTick(		void *		voiddc,
				XtIntervalId *	intervalId )
    {
    DraggingContext *		dc= (DraggingContext *)voiddc;

    if  ( tedExtendSelectionToXY( dc->dcEd,
			&dc->dcAnchorPosition, dc->dcMouseX, dc->dcMouseY ) )
	{ LDEB(1);	}

    dc->dcIntervalId= XtAppAddTimeOut( dc->dcContext, TED_DRAG_INTERVAL,
						    tedTick, (void *)dc );

    return;
    }

static void tedButton1Pressed(	Widget				w,
				EditDocument *			ed,
				TedDocument *			td,
				XmDrawingAreaCallbackStruct *	cbs )
    {
    const AppDrawingData *	add= &(ed->edDrawingData);
    BufferDocument *		bd= td->tdDocument;

    DraggingContext		dc;

    Display *			display= XtDisplay( w );
    Window			win= XtWindow( w );

    int				ox= ed->edVisibleRect.drX0;
    int				oy= ed->edVisibleRect.drY0;

    static			Time	prevTime;
    static			Time	lastTime;
    static int			clickInterval= 0;

    if  ( clickInterval == 0 )
	{
	clickInterval= XtGetMultiClickTime( display );

	if  ( clickInterval == 0 )
	    { LDEB(clickInterval); clickInterval= 200;	}
	}

    if  ( cbs->event->xbutton.time- lastTime < clickInterval )
	{
	TextLine *		tl;
	TextParticule *		tp;

	int			wasObject= 0;

	BufferSelection		bs;

	docInitSelection( &bs );

	if  ( tedFindPosition( bd, add, cbs->event->xbutton.x+ ox,
				    cbs->event->xbutton.y+ oy,
				    &tp, &tl, &dc.dcAnchorPosition ) )
	    { LLDEB(cbs->event->xbutton.x,cbs->event->xbutton.y); return; }

	bs.bsBegin= dc.dcAnchorPosition;
	bs.bsEnd= dc.dcAnchorPosition;

	if  ( cbs->event->xbutton.time- prevTime < 2* clickInterval )
	    {
	    tp= dc.dcAnchorPosition.bpBi->biParaParticules+
			    tl->tlFirstParticule+ tl->tlParticuleCount- 1;

	    bs.bsBegin.bpStroff= tl->tlStroff;
	    bs.bsBegin.bpParticule= tl->tlFirstParticule;
	    bs.bsEnd.bpStroff= tl->tlStroff+ tl->tlStrlen;
	    bs.bsEnd.bpParticule= tl->tlFirstParticule+ tl->tlParticuleCount- 1;
	    }
	else{
	    bs.bsBegin.bpStroff= tp->tpStroff;
	    bs.bsEnd.bpStroff= tp->tpStroff+ tp->tpStrlen;

	    if  ( tp->tpKind == DOCkindOBJECT )
		{ wasObject= 1;	}
	    }

	bs.bsDirection= 1;
	bs.bsAnchor= bs.bsBegin;
	tedSetSelection( ed, td, &bs );

	tedAdaptToolsToSelection( ed );

	if  ( wasObject )
	    {
	    tedSetObjectWindows( td, bs.bsBegin.bpBi, tl, tp, ox, oy,
							    display, win );
	    }

	prevTime= lastTime; lastTime= cbs->event->xbutton.time;

	return;
	}

    prevTime= lastTime; lastTime= cbs->event->xbutton.time;

    if  ( tedBeginSelection( ed, td, &(dc.dcAnchorPosition),
		    cbs->event->xbutton.x+ ox, cbs->event->xbutton.y+ oy ) )
	{ LDEB(1); return;	}

    tedAdaptToolsToPosition( ed, 1 );

    if  ( ed->edFileReadOnly )
	{
	int		startPart;
	int		endPart;
	const char *	fileName;
	int		fileSize;
	const char *	markName;
	int		markSize;

	if  ( ! docGetHyperlinkForPosition( &(dc.dcAnchorPosition),
				&startPart, &endPart,
				&fileName, &fileSize, &markName, &markSize ) )
	    {
	    tedFollowLink( (Widget)0, (Widget)0, ed,
				    fileName, fileSize, markName, markSize );

	    return;
	    }
	}

    dc.dcContext= ed->edApplication->eaContext;
    dc.dcEd= ed;
    dc.dcMouseX= cbs->event->xbutton.x;
    dc.dcMouseY= cbs->event->xbutton.y;
    dc.dcIntervalId= XtAppAddTimeOut( dc.dcContext, TED_DRAG_INTERVAL,
						    tedTick, (void *)&dc );

    for (;;)
	{
	XtInputMask	mask;
	XEvent		event;

	mask= XtAppPending( dc.dcContext );
	if  ( mask )
	    {
	    while( mask )
		{
		XtAppNextEvent( dc.dcContext, &event );

		if  ( event.type != MotionNotify )
		    { break;	}

		mask= XtAppPending( dc.dcContext );
		}
	    }
	else{ XtAppNextEvent( dc.dcContext, &event );	}

	XtRemoveTimeOut( dc.dcIntervalId );

	if  ( event.type == ButtonRelease )
	    {
	    if  ( td->tdSelection.bsBegin.bpBi ==
					td->tdSelection.bsEnd.bpBi	&&
		  td->tdSelection.bsBegin.bpStroff ==
					td->tdSelection.bsEnd.bpStroff	)
		{
		td->tdSelection.bsCol0= -1;
		td->tdSelection.bsCol1= -1;
		td->tdSelection.bsDirection= 0;
		}

	    tedSelectionRectangle( &(td->tdSelectedRectangle),
						 add, &(td->tdSelection) );

	    tedAdaptToolsToSelection( ed );

	    break;
	    }

	if  ( event.type == MotionNotify )
	    {
	    dc.dcMouseX= event.xmotion.x;
	    dc.dcMouseY= event.xmotion.y;

	    if  ( tedExtendSelectionToXY( ed, &dc.dcAnchorPosition,
						dc.dcMouseX, dc.dcMouseY ) )
		{ LDEB(1); return;	}
	    }
	else{ XtDispatchEvent( &event );	}

	dc.dcIntervalId= XtAppAddTimeOut( dc.dcContext, TED_DRAG_INTERVAL,
						    tedTick, (void *)&dc );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Handle keyboard input.						*/
/*									*/
/*  a)  Handle miscelaneous keysyms as keysyms, even if they have a	*/
/*	string representation.						*/
/*									*/
/************************************************************************/

static void tedInputSetSelectedPosition(	EditDocument *		ed,
						TedDocument *		td,
						BufferPosition *	bp )
    {
    int			scrolledX= 0;
    int			scrolledY= 0;

    tedSetSelectedPosition( ed, td, bp, &scrolledX, &scrolledY );
    tedAdaptToolsToPosition( ed, 1 );

    return;
    }

static void tedInputExtendSelection(	EditDocument *		ed,
					TedDocument *		td,
					BufferPosition *	bp )
    {
    const AppDrawingData *	add= &(ed->edDrawingData);

    tedPositionCoordinates( bp, add );

    tedExtendSelectionToPosition( ed, &(td->tdSelection.bsAnchor), bp );

    tedSelectionRectangle( &(td->tdSelectedRectangle),
					     add, &(td->tdSelection) );

    tedAdaptToolsToSelection( ed );

    return;
    }

static void tedInputChangeSelection(	EditDocument *		ed,
					TedDocument *		td,
					int			state,
					BufferPosition *	bp )
    {
    if  ( state == ShiftMask )
	{
	tedInputExtendSelection( ed, td, bp );
	return;
	}

    tedInputSetSelectedPosition( ed, td, bp );

    return;
    }

static void tedKeyPressed(	Widget			w,
				EditDocument *		ed,
				TedDocument *		td,
				XKeyEvent *		keyEvent	)
    {
    const AppDrawingData *	add= &(ed->edDrawingData);
    BufferSelection *		bs= &(td->tdSelection);

    KeySym			keySym;
    unsigned char		scratch[40];
    int				got;

    Display *			display= XtDisplay( w );

    if  ( ! bs->bsBegin.bpBi )
	{ XBell( display, 0 ); return; }

    if  ( ed->edInputContext )
	{
	Status	status;

	got= XmbLookupString( ed->edInputContext, keyEvent, (char *)scratch,
				sizeof(scratch)- 1, &keySym, &status );
	switch( status )
	    {
	    case XBufferOverflow:
		LDEB(status); return;
	    case XLookupNone:
		return;
	    case XLookupChars:
		scratch[got]= '\0';

		if  ( ! td->tdCanReplaceSelection )
		    { return;	}

		tedAppReplaceSelection( ed, scratch, got );
		return;
	    case XLookupBoth:
		scratch[got]= '\0';
		/*  a  */
		if  ( got > 0 )
		    {
		    AppPhysicalFont *	apf;

		    if  ( ! td->tdCanReplaceSelection )
			{ return;	}

		    if  ( td->tdCurrentPhysicalFont < 0			||
			  td->tdCurrentPhysicalFont >=
				    add->addPhysicalFontList.apflCount	)
			{
			LDEB(td->tdCurrentPhysicalFont);
			LDEB(add->addPhysicalFontList.apflCount);
			return;
			}

		    apf= add->addPhysicalFontList.apflFonts+
						    td->tdCurrentPhysicalFont;

		    if  ( appCharExistsInFont( apf->apfFontStruct,
								scratch[0] ) )
			{
			tedAppReplaceSelection( ed, scratch, got );
			return;
			}
		    else{ break;	}
		    }
		else{ break;	}
	    case XLookupKeySym:
		break;
	    }
	}
    else{
	got= XLookupString( keyEvent, (char *)scratch,
			sizeof(scratch)- 1, &keySym, (XComposeStatus *)0 );

	scratch[got]= '\0';

	/*  a  */
	if  ( got > 0 && ( keySym & 0xff00 ) != 0xff00 )
	    {
	    if  ( ! td->tdCanReplaceSelection )
		{ return;	}

	    tedAppReplaceSelection( ed, scratch, got );
	    return;
	    }
	}

    switch( keySym )
	{
	BufferPosition	bpNew;

#	ifdef XK_ISO_Left_Tab
	case XK_ISO_Left_Tab:
	    if  ( bs->bsBegin.bpBi			&&
		  bs->bsBegin.bpBi->biParaInTable	&&
		  ! ( keyEvent->state & ControlMask )		)
		{ goto shiftTab;	}
	    else{ return;		}
#	endif

	case XK_i:
	    if  ( keyEvent->state != ControlMask )
		{ goto unknown; }
	    /*FALLTHROUGH*/
	case XK_Tab:
	    if  ( bs->bsBegin.bpBi			&&
		  bs->bsBegin.bpBi->biParaInTable	&&
		  ! ( keyEvent->state & ControlMask )		)
		{
		if  ( keyEvent->state & ShiftMask )
		    {
		  shiftTab:
		    if  ( docFirstPosition( bs->bsBegin.bpBi->biParent,
							    &bpNew )	||
			  tedPrevPosition( add, &bpNew, /*last=*/ 0 )	)
			{ return;	}
		    }
		else{
		    if  ( docLastPosition( bs->bsBegin.bpBi->biParent,
							    &bpNew )	||
			  tedNextPosition( add, &bpNew )		)
			{ return;	}
		    }

		tedInputSetSelectedPosition( ed, td, &bpNew );

		return;
		}

	    if  ( keyEvent->state & ShiftMask )
		{ return;	}

	    if  ( ! td->tdCanReplaceSelection )
		{ return;	}

	    tedAppReplaceSelection( ed, scratch, 0 );

	    tedSetTab( w, ed );

	    appDocumentChanged( ed->edApplication, ed, 1 );

	    return;

	case XK_j: case XK_m:
	    if  ( keyEvent->state != ControlMask )
		{ goto unknown; }
	    /*FALLTHROUGH*/
	case XK_KP_Enter:
	case XK_Return:
	    if  ( ! td->tdCanReplaceSelection )
		{ return;	}

	    tedAppReplaceSelection( ed, scratch, 0 );

	    tedSplitParagraph( ed, keyEvent->state == ControlMask );

	    appDocumentChanged( ed->edApplication, ed, 1 );

	    return;

	case XK_KP_Delete:
	case XK_Delete:
	    if  ( ! td->tdCanReplaceSelection )
		{ return;	}

	    if  ( tedHasIBarSelection( td ) )
		{
		bpNew= bs->bsBegin;

		if  ( tedNextPosition( add, &bpNew ) )
		    { return;	}

		if  ( ! docPositionsInsideCell( &(bs->bsBegin), &bpNew ) )
		    { return;	}

		if  ( tedNextPosition( add, &bs->bsEnd ) )
		    { return;	}
		}

	    tedAppReplaceSelection( ed, scratch, 0 );

	    return;

	case XK_BackSpace:
	    if  ( ! td->tdCanReplaceSelection )
		{ return;	}

	    if  ( tedHasIBarSelection( td ) )
		{
		const int	lastOne= 1;

		bpNew= bs->bsBegin;

		if  ( tedPrevPosition( add, &bpNew, lastOne ) )
		    { return;	}

		if  ( ! docPositionsInsideCell( &bpNew, &(bs->bsBegin) ) )
		    {
		    const int		state= 0;
		    tedInputChangeSelection( ed, td, state, &bpNew );
		    return;
		    }

		if  ( tedPrevPosition( add, &bs->bsBegin, lastOne ) )
		    { return;	}
		}

	    tedAppReplaceSelection( ed, scratch, 0 );
	    return;

	case XK_KP_Home:
	case XK_Home:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedBeginOfLine( add, &bpNew ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_End:
	case XK_End:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedEndOfLine( add, &bpNew ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Left:
	case XK_Left:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedPrevPosition( add, &bpNew, /*lastOne=*/ 1 ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Right:
	case XK_Right:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedNextPosition( add, &bpNew ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Up:
	case XK_Up:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedPrevLine( add, &bpNew ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Down:
	case XK_Down:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedNextLine( add, &bpNew ) )
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Prior:
	case XK_Prior:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedPageUp( &bpNew, td->tdDocument, add,
					ed->edVisibleRect.drY1-
					ed->edVisibleRect.drY0 )	&&
		  tedFirstPosition( add, td->tdDocument, &bpNew )	)
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

	case XK_KP_Next:
	case XK_Next:
	    if  ( bs->bsDirection >= 0 )
		{ bpNew= bs->bsEnd;	}
	    else{ bpNew= bs->bsBegin;	}

	    if  ( tedPageDown( &bpNew, td->tdDocument, add,
					add->addDocRect.drY1,
					ed->edVisibleRect.drY1-
					ed->edVisibleRect.drY0 )	&&
		  tedLastPosition( add, td->tdDocument, &bpNew )	)
		{ return;	}

	    tedInputChangeSelection( ed, td, keyEvent->state, &bpNew );
	    return;

#	if 0
	case XK_c:
	    /************************************************************/
	    /*  Usually this key is intercepted by the 'Edit' menu.	*/
	    /************************************************************/
	    if  ( keyEvent->state != ControlMask )
		{ goto defaultCase;	}

	    tedDocCopy( ed, (XEvent *)keyEvent );
	    return;
	case XK_x:
	    /************************************************************/
	    /*  Usually this key is intercepted by the 'Edit' menu.	*/
	    /************************************************************/
	    if  ( keyEvent->state != ControlMask )
		{ goto defaultCase;	}

	    tedDocCut( ed, (XEvent *)keyEvent );
	    return;
	case XK_v:
	    /************************************************************/
	    /*  Usually this key is intercepted by the 'Edit' menu.	*/
	    /************************************************************/
	    if  ( keyEvent->state != ControlMask )
		{ goto defaultCase;	}

	    appDocAskForPaste( ed, "PRIMARY", keyEvent->time );
	    return;
#	endif

	case XK_Shift_L:
	case XK_Shift_R:
	case XK_Alt_L:
	case XK_Alt_R:
	case XK_Control_L:
	case XK_Control_R:
	case XK_Caps_Lock:
	case XK_Insert:
	case XK_KP_Insert:
	case XK_Num_Lock:
	    return;
	default: unknown:
#	    ifdef DEBUG
	    DEBFUN( "INPUT \"%s\": %s (%s%s<Key>%s) \"%.*s\"\n",
			ed->edTitle, APP_X11EventNames[keyEvent->type],
			(keyEvent->state&ShiftMask)?"Shift":"",
			(keyEvent->state&ControlMask)?"Control":"",
			XKeysymToString( keySym ), got, scratch );
#	    endif
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Drag routine for inserted objects.					*/
/*									*/
/************************************************************************/
#   define	BLOCK		10

static void tedObjectResizeDrag(Widget			w,
				EditDocument *		ed,
				BufferItem *		bi,
				TextLine *		tl,
				TextParticule *		tp,
				InsertedObject *	io,
				int			right,
				int			bottom,
				int			prevX,
				int			prevY )
    {
    EditApplication *	ea= ed->edApplication;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    Display *		display= XtDisplay( w );
    Window		win= XtWindow( w );
    int			ox= ed->edVisibleRect.drX0;
    int			oy= ed->edVisibleRect.drY0;

    io->ioDragWide= io->ioPixelsWide;
    io->ioDragHigh= io->ioPixelsHigh;

    for (;;)
	{
	XtInputMask	mask;
	XEvent		event;

	mask= XtAppPending( ea->eaContext );
	if  ( mask )
	    {
	    while( mask )
		{
		XtAppNextEvent( ea->eaContext, &event );

		if  ( event.type != MotionNotify )
		    { break;	}

		mask= XtAppPending( ea->eaContext );
		}
	    }
	else{ XtAppNextEvent( ea->eaContext, &event );	}

	if  ( event.type == ButtonRelease )
	    { break; }

	if  ( event.type == MotionNotify )
	    {
	    int		moved= 0;

	    int		wide= io->ioDragWide;
	    int		high= io->ioDragHigh;

	    if  ( right )
		{ io->ioDragWide += event.xmotion.x- prevX; moved= 1; }

	    if  ( bottom )
		{ io->ioDragHigh += event.xmotion.y- prevY; moved= 1; }

	    if  ( wide < io->ioDragWide )
		{ wide=  io->ioDragWide;	}
	    if  ( high < io->ioDragHigh )
		{ high=  io->ioDragHigh;	}

	    if  ( moved )
		{
		XClearArea( display, win,
				tp->tpX0- ox, tl->tlY- io->ioPixelsHigh- oy,
				wide, high, True );
		}

	    prevX= event.xmotion.x;
	    prevY= event.xmotion.y;
	    }
	else{ XtDispatchEvent( &event );	}
	}

    if  ( io->ioDragWide != io->ioPixelsWide	||
	  io->ioDragHigh != io->ioPixelsHigh	)
	{
	if  ( tedResizeObject( ed, bi, td->tdSelection.bsBegin.bpLine, tp, io,
		io->ioDragWide, io->ioDragHigh, ox, oy ) )
	    { LDEB(1);	}

	appDocumentChanged( ed->edApplication, ed, 1 );
	}

    io->ioDragWide= 0;
    io->ioDragHigh= 0;

    tedSetObjectWindows( td, bi, tl, tp, ox, oy, display, win );

    return;
    }

static void tedObjectDrag(	Widget		w,
				void *		voided,
				Window		subwindow,
				int		prevX,
				int		prevY )
    {
    EditDocument *	ed= (EditDocument *)voided;
    TedDocument *	td= (TedDocument *)ed->edPrivateData;

    int			ox= ed->edVisibleRect.drX0;
    int			oy= ed->edVisibleRect.drY0;

    BufferItem *	bi;
    TextLine *		tl;
    TextParticule *	tp;
    InsertedObject *	io;

    int			wide;
    int			high;

    int			right= 0;
    int			bottom= 0;

    if  ( tedGetObjectSelection( td, &bi, &tl, &tp, &io ) )
	{ LDEB(1); return;	}

    wide= io->ioPixelsWide;
    high= io->ioPixelsHigh;

    if  ( prevX >= tp->tpX0- ox + wide/ 2- BLOCK/ 2	&&
	  prevX <  tp->tpX0- ox + wide/ 2+ BLOCK/ 2	&&
	  prevY >= tl->tlY- oy- BLOCK			)
	{ bottom= 1;	}

    if  ( prevX >= tp->tpX0- ox + wide- BLOCK		&&
	  prevY >= tl->tlY- oy - high/ 2- BLOCK/ 2	&&
	  prevY <  tl->tlY- oy - high/ 2+ BLOCK/ 2	)
	{ right= 1;	}

    if  ( prevX >= tp->tpX0- ox + wide- BLOCK		&&
	  prevY >= tl->tlY- oy- BLOCK			)
	{ right= 1; bottom= 1;	}

    if  ( right || bottom )
	{
	tedObjectResizeDrag( w, ed, bi, tl, tp, io,
					    right, bottom, prevX, prevY );
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Callback for input.							*/
/*									*/
/************************************************************************/
void tedDrawingInput(		Widget		w,
				XtPointer	voided,
				XtPointer	voidcbs	)
    {
    EditDocument *			ed= (EditDocument *)voided;
    TedDocument *			td= (TedDocument *)ed->edPrivateData;
    EditApplication *			ea= ed->edApplication;

    XmDrawingAreaCallbackStruct *	cbs;

    cbs= (XmDrawingAreaCallbackStruct *)voidcbs;

    tedStopCursorBlink( ea->eaContext, ed );

    switch( cbs->event->type )
	{
	case ButtonPress:
	    switch( cbs->event->xbutton.button )
		{
		case Button1:
		    if  ( cbs->event->xbutton.subwindow )
			{
			tedObjectDrag( w, voided, cbs->event->xbutton.subwindow,
				cbs->event->xbutton.x, cbs->event->xbutton.y );
			return;
			}

		    tedButton1Pressed( w, ed, td, cbs );
		    break;
		case Button2:
		    appDocAskForPaste( ed, "PRIMARY", cbs->event->xbutton.time );
		    break;
		case Button3:
		    break;
		default:
		    LDEB(cbs->event->xbutton.button);
		    break;
		}
	    break;
	case KeyPress:
	    tedKeyPressed( w, ed, td, &(cbs->event->xkey) );
	    break;
	case ButtonRelease:
	case KeyRelease:
	    break;
	default:
	    DEBFUN( "INPUT \"%s\": %s\n",
			ed->edTitle, APP_X11EventNames[cbs->event->type] );
	    break;
	}

    if  ( tedHasIBarSelection( td ) )
	{ tedStartCursorBlink( ea->eaContext, ed );	}

    return;
    }

/************************************************************************/
/*									*/
/*  Respond to selection events.					*/
/*									*/
/*  1)  If there is no result of the paste, ask for a less desirable	*/
/*	format, or if that does not exist, just give up.		*/
/*									*/
/************************************************************************/
void tedSelectionInput(	Widget		w,
			void *		voided,
			XEvent *	event,
			Boolean *	pRefused	)
    {
    EditDocument *	ed= (EditDocument *)voided;

    switch( event->type )
	{
	case SelectionNotify:
	    *pRefused= True;
	    break;
	case SelectionRequest:
	    *pRefused= True;
	    break;
	case SelectionClear:
	    *pRefused= True;
	    break;
	case PropertyNotify:
	    *pRefused= True;
	    break;
	case GraphicsExpose:
	    /*
	    DEBFUN( "%s \"%s\":[%4d..%4d x%4d..%4d]\n",
		    APP_X11EventNames[event->type], ed->Title,
		    event->xgraphicsexpose.x,
		    event->xgraphicsexpose.x+ event->xgraphicsexpose.width,
		    event->xgraphicsexpose.y,
		    event->xgraphicsexpose.y+ event->xgraphicsexpose.height );
	    */
	    tedExposeHandler( w, voided, event, pRefused );
	    *pRefused= False;
	    return;
	case NoExpose:
	    break;
	default:
	    DEBFUN( "SELECTION \"%s\": %s\n",
			ed->edTitle, APP_X11EventNames[event->type] );
	    *pRefused= True;
	    break;
	}

    return;
    }
