/* coolbrowse.c - simple example usage of the coolwidget X API
   Copyright (C) 1997 Paul Sheer

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.
 */

#include <coolwidget.h>
#include "cmdlineopt.h"
#include "mad.h"

/* {{{ command-line options */

#ifdef HAVE_DND
extern int option_dnd_version;
#endif

/* main and first window */
Window main_window = 0;

/* shell command to run */
extern char *option_man_cmdline;

/* argv[0] */
char *argv_nought = 0;

/* font from the library */
extern char *init_font;

/* server from command line */
char *option_display = 0;

/* font from the command line */
char *option_font = "-*-helvetica-bold-r-*--14-*-*-*-p-*-iso8859-1";

static int get_help = 0;
static int get_file = 0;
static int get_version = 0;

static char *command_line_args[] =
{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

void usage (void)
{
    printf (\
	    _ ("Coolbrowse version %s\nUsage:\n" \
	       "Coolbrowse [options] <Browser-Header>\n" \
	       "-d, -display <display>                   the X server to display on\n" \
	       "-f, -fn, -font <font-name>               default: 8x13bold\n" \
	       "-g, -get, --get-file                     print result to stdout\n" \
	       "-h, -H, -?, --help                       print this message to stdout\n" \
	       "-V, -v, --version                        print versiom info\n" \
	       "\n" \
	       "Coolbrowse draws a filebrowser and prints the selected file\n" \
	       "to stdout. The starting directory is the current working directory\n" \
	       "Coolbrowse was written with the Coolwidgets X Window widget library\n" \
	       "\n"), \
	    VERSION);
}

void version (void)
{
    printf (_ ("Coolbrowse version %s\n"), VERSION);
}

struct prog_options coolbrowse_options[] =
{
    {' ', "", "", ARG_STRINGS, 0, command_line_args, 0},
#ifdef HAVE_DND
    {0, "-dnd-old", "--dnd-old", ARG_CLEAR, 0, 0, &option_dnd_version},
#endif
    {'g', "-get", "--get-file", ARG_SET, 0, 0, &get_file},
    {'f', "-fn", "-font", ARG_STRING, &option_font, 0, 0},
    {'h', "-?", "--help", ARG_SET, 0, 0, &get_help},
    {'H', "-help", "--help", ARG_SET, 0, 0, &get_help},
    {'V', "-v", "--version", ARG_SET, 0, 0, &get_version},
    {'d', "", "-display", ARG_STRING, &option_display, 0, 0},
    {0, 0, 0, 0, 0, 0, 0}
};

/* here we use our own function (which is better than get_opt() or get_opt_long()) */
static void process_command_line (int argc, char **argv)
{
    int error;
    error = get_cmdline_options (argc, argv, coolbrowse_options);

    if (error) {
	fprintf (stderr, _ ("%s: error processing commandline argument %d\n"), argv[0], error);
	usage ();
	exit (1);
    }
    if (get_help)
	usage ();
    if (get_version)
	version ();
    if (get_help || get_version)
	exit (0);
}

/* }}} command-line options */


void load_trivial_options (void);

int main (int argc, char **argv)
{
    CInitData coolbrowse_startup;
    CEvent cwevent;
    char *header = 0;
    int i;

    setlocale (LC_CTYPE, "");
    setlocale (LC_TIME, "");
    setlocale (LC_MESSAGES, "");
    bindtextdomain (PACKAGE, LOCALEDIR);
    textdomain (PACKAGE);

    load_trivial_options ();

    process_command_line (argc, argv);

/* initialise the library */
    memset (&coolbrowse_startup, 0, sizeof (coolbrowse_startup));
    coolbrowse_startup.name = argv[0];
    coolbrowse_startup.display = option_display;
    coolbrowse_startup.font = option_font;
    CInitialise (&coolbrowse_startup);
    CDrawMainWindow ("dummy", "dummy");

    if (command_line_args[0]) {
	int l = 0;
	i = 0;
	while (command_line_args[i]) {
	    l += strlen (command_line_args[i]) + 1;
	    i++;
	}
	i = 0;
	header = CMalloc (l + 16);
	strcpy (header, " ");
	while (command_line_args[i]) {
	    strcat (header, command_line_args[i]);
	    strcat (header, " ");
	    i++;
	}
    } else {
	header = (char *) strdup (_(" File Browser "));
    }

    if (!get_file) {
	CDrawBrowser ("browser", CRoot, 0, 0, current_dir, "", header);

/* Run the application. */
	for (;;) {
	    CNextEvent (0, &cwevent);
	    if (!CIdent ("browser"))
		break;
	}
    } else {
	char *t;
	t = CGetFile (CRoot, 0, 0, current_dir, "", header);
	if (t)
	    printf ("%s\n", t);
    }

/* close connection to the X display */
    CShutdown ();
    return 0;
}

