/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : mux.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitMux
|
| Description : DSPKitMux
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char mux_cc [] = "$Id$";

#include "mux.h"

long DSPKitMux::setInput (DSPKitProcessor *ip)
{
  if (DSPKitProcessor::setInput (ip) != 0) return -1;
  outputCount = 0;
  outputIndex = 0;
  endOfInput  = 0;
  inputSample = 0.0;
  return 0;
}

void DSPKitMux::setOutput (DSPKitProcessor *op)
{
  DSPKitProcessor::setOutput(op);
  outputCount++;
}

long DSPKitMux::getSample (double &outputSample)
{
  if (outputIndex >= outputCount) outputIndex = 0;
  if (outputIndex++ == 0)
  {
    if (input->getSample (inputSample) == 0)
    {
      endOfInput = 1;
      return 0;
    }
  }

  if (endOfInput) return 0;
  outputSample = inputSample;
  return 1;
}

/***************************************************************************/
