/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : dpreader.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitDPReader
|
| Description : DSPKitDPReader
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char dpreader_cc [] = "$Id$";

#include "dpreader.h"
#ifndef NOFORMS
#include "DPTich_main.h"
#endif

#define DSPXCHECK 10000

DSPKitDPReader::DSPKitDPReader ()
{
  sample = 0;
}

long DSPKitDPReader::setInput (
  DPSample *newSample,
  long newChannel,
  long newSusLoops,
  long newRelLoops)
{
  sample       = newSample;
  channel      = newChannel;
  susLoops     = newSusLoops;
  relLoops     = newRelLoops;
  susLoopsTemp = susLoops;
  relLoopsTemp = relLoops;
  
  inputSamplingRate  = sample->getRate ();
  i                  = 0;
  frames             = sample->getFrames ();
  increment          = 1;
  tempSusLoopMode    = sample->getSusLoopMode ();
  tempRelLoopMode    = sample->getRelLoopMode ();
  susLoopStart       = sample->getSusLoopStart ();
  susLoopEnd         = sample->getSusLoopEnd ();
  relLoopStart       = sample->getRelLoopStart ();
  relLoopEnd         = sample->getRelLoopEnd ();
  
  // Catch special case (loops of duration zero and one - ignore both)
  if (susLoopStart == susLoopEnd) tempSusLoopMode = AF_LOOP_MODE_NOLOOP;
  if (relLoopStart == relLoopEnd) tempRelLoopMode = AF_LOOP_MODE_NOLOOP;
  if (susLoopStart == susLoopEnd - 1) tempSusLoopMode = AF_LOOP_MODE_NOLOOP;
  if (relLoopStart == relLoopEnd - 1) tempRelLoopMode = AF_LOOP_MODE_NOLOOP;
  
  checkReset = DSPXCHECK;
  check      = 1;

  sampleCount = sample->getFrames ();

  if (tempSusLoopMode == AF_LOOP_MODE_FORW)
  {
    sampleCount += susLoops * (susLoopEnd - susLoopStart);
  }
  else if (tempSusLoopMode == AF_LOOP_MODE_FORWBAKW)
  {
    sampleCount += susLoops * 2 * (susLoopEnd - susLoopStart - 1);
  }
  
  if (tempRelLoopMode == AF_LOOP_MODE_FORW)
  {
    sampleCount += relLoops * (relLoopEnd - relLoopStart);
  }
  else if (tempRelLoopMode == AF_LOOP_MODE_FORWBAKW)
  {
    sampleCount += relLoops * 2 * (relLoopEnd - relLoopStart - 1);
  }
  
  samplesLeft = sampleCount;
  
  return 0;
}

long DSPKitDPReader::getSample (double &outputSample)
{
  // #ifdef SNEAKYCHECK
  // XEvent newEvent;
  // #endif
  
  if (i >= 0 && i < frames)
  {
    outputSample = sample->getFrameDb (i,channel);

    if (susLoopsTemp > 0)
    {
      if (tempSusLoopMode == AF_LOOP_MODE_FORW && i == susLoopEnd - 1)
      {
        i = susLoopStart - 1;
        susLoopsTemp--;
      }
      else if (tempSusLoopMode == AF_LOOP_MODE_FORWBAKW)
      {
        if (i == susLoopStart)
        {
          if (increment == -1) susLoopsTemp--;
          increment = 1;
        }
        else if (i == susLoopEnd - 1)
        {
          increment = -1;
        }
      }
      if (susLoopsTemp == 0) increment = 1;
    }
    else if (relLoopsTemp > 0)
    {
      if (tempRelLoopMode == AF_LOOP_MODE_FORW && i == relLoopEnd - 1)
      {
        i = relLoopStart - 1;
        relLoopsTemp--;
      }
      else if (tempRelLoopMode == AF_LOOP_MODE_FORWBAKW)
      {
        if (i == relLoopStart)
        {
          if (increment == -1) relLoopsTemp--;
          increment = 1;
        }
        else if (i == relLoopEnd - 1)
        {
          increment = -1;
        }
      }
      if (relLoopsTemp == 0) increment = 1;
    }

    i += increment;
    
//     Checking moved to writer.run
//     if (!--check)
//     {
//       check = checkReset;
//       #ifndef NOFORMS
//       if (XCheckWindowEvent (fl_display,
//         executeForm->executeForm->window,~(long)0,&newEvent))
//       {
//         XPutBackEvent (fl_display,&newEvent);
//         fl_check_forms ();
//       }
//       #endif
//     }
  }
  else
  {
    return 0;
  }

  samplesLeft--;
  return 1;
}

/***************************************************************************/
