/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : butterwo.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitButterworthFilter
|
| Description : DSPKitButterworthFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char butterwo_cc [] = "$Id$";

#include "butterwo.h"

long DSPKitButterworthFilter::setInput (DSPKitProcessor *ip)
{
  DSPKitProcessor::setInput (ip);
  chBuf.x [0] = 0.0;
  chBuf.x [1] = 0.0;
  chBuf.y [0] = 0.0;
  chBuf.y [1] = 0.0;
  return 1;
}

long DSPKitButterworthFilter::getSample (double &outputSample)
{
  double inputSample;
  if (!input->getSample (inputSample)) return 0;

  outputSample =
    a [0] * inputSample +
    a [1] * chBuf.x [0] +
    a [2] * chBuf.x [1] -
    b [0] * chBuf.y [0] -
    b [1] * chBuf.y [1];

  chBuf.x [1] = chBuf.x [0];
  chBuf.x [0] = inputSample;
  chBuf.y [1] = chBuf.y [0];
  chBuf.y [0] = outputSample;

  return 1;
}

/***************************************************************************/
