/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_prefs.cc
|
| Revision    : 1.0
| Date        : 06/04/97
|
| Object      : None
|
| Description : Preferences code file
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

static char DPTich_prefs_cc [] = "$Id$";

#include "DPTich_prefs.h"

int localPrefsUsed = FALSE;

/*---------------------------------------------------------------------------
| FUNCTION loadPreferences
---------------------------------------------------------------------------*/

int loadPreferences ()
{
  char *directory;
  char *filename;
  FILE *file;
  int  prefsFound;
  
  prefsFound = FALSE;

  directory = getenv ("HOME");

  if (!localPrefsUsed && directory)
  {
    filename = new char [strlen (directory) + strlen (PREFSNAME) + 2];
    strcpy (filename,directory);
    if (strlen (filename) > 0 && filename [strlen (filename) - 1] != '/')
      strcat (filename,"/");
    strcat (filename,PREFSNAME);
    file = fopen (filename,"r");
    if (file)
      prefsFound = TRUE;
    else
      delete [] filename;
  }
  
  if (!prefsFound)
  {
    localPrefsUsed = TRUE;
    directory = ".";
    filename = new char [strlen (directory) + strlen (PREFSNAME) + 2];
    strcpy (filename,directory);
    if (strlen (filename) > 0 && filename [strlen (filename) - 1] != '/')
      strcat (filename,"/");
    strcat (filename,PREFSNAME);
    file = fopen (filename,"r");
    if (file)
      prefsFound = TRUE;
    else
      delete [] filename;
  }

  if (!prefsFound) return FALSE;
  
  // Read in prefs (into mainForm->sample)

  const int  tempStringLen = 128;
  const char delimiters [] = " \t\n";
  const char textDelimiters [] = "\n";
  char tempString [tempStringLen];
  char *token;
  
  while (readLine (file,tempString,tempStringLen))
  {
    if (!strlen (tempString)) continue;
    token = strtok (tempString,delimiters);
    if (!token) continue;
    if (!strcasecmp (token,"drawmode:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"dots"))
          fl_set_sample_drawmode (mainForm->sample,0);
        else if (!strcasecmp (token,"lines"))
          fl_set_sample_drawmode (mainForm->sample,1);
        else if (!strcasecmp (token,"filled"))
          fl_set_sample_drawmode (mainForm->sample,2);
      }
    }
    if (!strcasecmp (token,"drawaccuracy:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"quick"))
          fl_set_sample_drawaccuracy (mainForm->sample,0);
        else if (!strcasecmp (token,"accurate"))
          fl_set_sample_drawaccuracy (mainForm->sample,1);
      }
    }
    else if (!strcasecmp (token,"axismode:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"axis"))
          fl_set_sample_axis (mainForm->sample,1);
        else if (!strcasecmp (token,"noaxis"))
          fl_set_sample_axis (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"axisscale:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"frames"))
          fl_set_sample_frames (mainForm->sample,1);
        else if (!strcasecmp (token,"time"))
          fl_set_sample_frames (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"undobuffer:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_undomode (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_undomode (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"autowindows:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_autowindows (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_autowindows (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"autoglobals:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_autoglobals (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_autoglobals (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"autoeditmode:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_autoeditmode (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_autoeditmode (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"copyrightsave:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_copysave (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_copysave (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"tooltips:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_tooltips (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_tooltips (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"tempdir:"))
    {
      token = strtok (NULL,textDelimiters);
      if (token)
      {
        int firstNonSpace = findNonSpace (token);
        fl_set_sample_tempdir (mainForm->sample,token + firstNonSpace);
      }
    }
    else if (!strcasecmp (token,"normalidle:"))
    {
      token = strtok (NULL,textDelimiters);
      if (token)
      {
        int firstNonSpace = findNonSpace (token);
        normalIdle = atoi (token + firstNonSpace);
        fl_set_idle_delta (normalIdle);
      }
    }
    else if (!strcasecmp (token,"heavyidle:"))
    {
      token = strtok (NULL,textDelimiters);
      if (token)
      {
        int firstNonSpace = findNonSpace (token);
        heavyIdle = atoi (token + firstNonSpace);
      }
    }
    else if (!strcasecmp (token,"rangealternative:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_rangealt (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_rangealt (mainForm->sample,0);
      }
    }
    else if (!strcasecmp (token,"rangecrossover:"))
    {
      token = strtok (NULL,delimiters);
      if (token)
      {
        if (!strcasecmp (token,"on"))
          fl_set_sample_rangecross (mainForm->sample,1);
        else if (!strcasecmp (token,"off"))
          fl_set_sample_rangecross (mainForm->sample,0);
      }
    }
  }
  
  fclose (file);
  delete [] filename;
  updatePrefsForm ();
  updateSamplePrefs ();
  preferencesChanged = FALSE;
  return TRUE;
}  
  
/*---------------------------------------------------------------------------
| FUNCTION savePreferences
---------------------------------------------------------------------------*/

int savePreferences ()
{
  char *directory;
  char *filename;
  FILE *file;
  int  prefsFound;
  
  prefsFound = FALSE;

  directory = getenv ("HOME");

  if (!localPrefsUsed && directory)
  {
    filename = new char [strlen (directory) + strlen (PREFSNAME) + 2];
    strcpy (filename,directory);
    if (strlen (filename) > 0 && filename [strlen (filename) - 1] != '/')
      strcat (filename,"/");
    strcat (filename,PREFSNAME);
    file = fopen (filename,"w");
    if (file)
      prefsFound = TRUE;
    else
      delete [] filename;
  }
  
  if (!prefsFound)
  {
    localPrefsUsed = TRUE;
    directory = "";
    filename = new char [strlen (directory) + strlen (PREFSNAME) + 2];
    strcpy (filename,directory);
    if (strlen (filename) > 0 && filename [strlen (filename) - 1] != '/')
      strcat (filename,"/");
    strcat (filename,PREFSNAME);
    file = fopen (filename,"w");
    if (file)
      prefsFound = TRUE;
    else
      delete [] filename;
  }

  if (!prefsFound) return FALSE;
  
  // Write out prefs (from mainForm->sample)

  int item = fl_get_sample_drawmode (mainForm->sample);
  
  switch (item)
  {
    case 0 :
      fprintf (file,"drawmode: dots\n"); 
      break;
    case 1 :
      fprintf (file,"drawmode: lines\n"); 
      break;
    case 2 :
      fprintf (file,"drawmode: filled\n"); 
      break;
    default :
      break;
  }

  item = fl_get_sample_drawaccuracy (mainForm->sample);
  
  switch (item)
  {
    case 0 :
      fprintf (file,"drawaccuracy: quick\n"); 
      break;
    case 1 :
      fprintf (file,"drawaccuracy: accurate\n"); 
      break;
    default :
      break;
  }

  item=fl_get_sample_axis (mainForm->sample);
  
  if (item)
    fprintf (file,"axismode: axis\n"); 
  else
    fprintf (file,"axismode: noaxis\n"); 

  item=fl_get_sample_frames (mainForm->sample);
  
  if (item)
    fprintf (file,"axisscale: frames\n"); 
  else
    fprintf (file,"axisscale: time\n"); 

  item=fl_get_sample_undomode (mainForm->sample);
  
  if (item)
    fprintf (file,"undobuffer: on\n"); 
  else
    fprintf (file,"undobuffer: off\n"); 

  item=fl_get_sample_autowindows (mainForm->sample);
  
  if (item)
    fprintf (file,"autowindows: on\n"); 
  else
    fprintf (file,"autowindows: off\n"); 

  item=fl_get_sample_autoglobals (mainForm->sample);
  
  if (item)
    fprintf (file,"autoglobals: on\n"); 
  else
    fprintf (file,"autoglobals: off\n"); 

  item=fl_get_sample_autoeditmode (mainForm->sample);
  
  if (item)
    fprintf (file,"autoeditmode: on\n"); 
  else
    fprintf (file,"autoeditmode: off\n"); 

  item=fl_get_sample_copysave (mainForm->sample);
  
  if (item)
    fprintf (file,"copyrightsave: on\n"); 
  else
    fprintf (file,"copyrightsave: off\n"); 

  item=fl_get_sample_tooltips (mainForm->sample);
  
  if (item)
    fprintf (file,"tooltips: on\n"); 
  else
    fprintf (file,"tooltips: off\n"); 

  const char *textItem = fl_get_sample_tempdir (mainForm->sample);
  
  if (textItem)
    fprintf (file,"tempdir: %s\n",textItem);

  fprintf (file,"normalidle: %d\n",normalIdle);

  fprintf (file,"heavyidle: %d\n",heavyIdle);

  item=fl_get_sample_rangealt (mainForm->sample);
  
  if (item)
    fprintf (file,"rangealternative: on\n"); 
  else
    fprintf (file,"rangealternative: off\n"); 

  item=fl_get_sample_rangecross (mainForm->sample);
  
  if (item)
    fprintf (file,"rangecrossover: on\n"); 
  else
    fprintf (file,"rangecrossover: off\n"); 

  fclose (file);
  delete [] filename;
  preferencesChanged = FALSE;
  return TRUE;
}  
  
/*---------------------------------------------------------------------------
| FUNCTION readLine
---------------------------------------------------------------------------*/

int readLine (FILE *file,char *buffer,int bufferLen)
{
  int i=0;
  int c;

  if (!buffer || bufferLen < 1) return FALSE;
  c = getc (file);
  if (c == EOF) return FALSE;
  while (c != EOF && c != '\n')
  {
    if (i < bufferLen - 1)
      buffer [i++] = c;
    c = getc (file);
  }
  buffer [i] = 0;
  return TRUE;
}

/*---------------------------------------------------------------------------
| CALLBACK prefsEmpty_cb
---------------------------------------------------------------------------*/

void prefsEmpty_cb (FL_OBJECT *ob,long data)
{
}

/*---------------------------------------------------------------------------
| CALLBACK prefsOK_cb
---------------------------------------------------------------------------*/

void prefsOK_cb (FL_OBJECT *ob,long data)
{
  fl_hide_form (prefsForm->prefsForm);
  updateSamplePrefs ();
  updatePrefsForm ();
  preferencesChanged = TRUE;
}

/*---------------------------------------------------------------------------
| CALLBACK prefsCancel_cb
---------------------------------------------------------------------------*/

void prefsCancel_cb (FL_OBJECT *ob,long data)
{
  fl_hide_form (prefsForm->prefsForm);
  updatePrefsForm ();
}

/*---------------------------------------------------------------------------
| FUNCTION updatePrefsForm
---------------------------------------------------------------------------*/

void updatePrefsForm (void)
{
  int item = fl_get_sample_drawmode (mainForm->sample);
  
  switch (item)
  {
    case 0 :
      fl_set_button (prefsForm->dotsButton,TRUE);
      break;
    case 1 :
      fl_set_button (prefsForm->linesButton,TRUE);
      break;
    case 2 :
      fl_set_button (prefsForm->filledButton,TRUE);
      break;
    default :
      break;
  }

  item = fl_get_sample_drawaccuracy (mainForm->sample);
  
  switch (item)
  {
    case 0 :
      fl_set_button (prefsForm->quickButton,TRUE);
      break;
    case 1 :
      fl_set_button (prefsForm->accurateButton,TRUE);
      break;
    default :
      break;
  }

  item=fl_get_sample_axis (mainForm->sample);
  
  if (item)
  {
    fl_set_button (prefsForm->axisButton,TRUE);
  }
  else
  {
    fl_set_button (prefsForm->noaxisButton,TRUE);
  }

  item=fl_get_sample_frames (mainForm->sample);

  // Handle no range or no loop (sustain and release)
  // (range and loops get set due to text callbacks)
  DPSample *sample = fl_get_sample (mainForm->sample);
  long rangeValid  = sample->getRangeValid ();
  long susLoopMode = sample->getSusLoopMode ();
  long relLoopMode = sample->getRelLoopMode ();
  
  if (item)
  {
    fl_set_button (prefsForm->framesButton,TRUE);
    fl_hide_object (displayForm->floatInputs);
    fl_show_object (displayForm->intInputs);
    fl_hide_object (loopForm->floatInputs);
    fl_show_object (loopForm->intInputs);
    fl_hide_object (rangeForm->floatInputs);
    fl_show_object (rangeForm->intInputs);
  }
  else
  {
    fl_set_button (prefsForm->timeButton,TRUE);
    fl_hide_object (displayForm->intInputs);
    fl_show_object (displayForm->floatInputs);
    fl_hide_object (loopForm->intInputs);
    fl_show_object (loopForm->floatInputs);
    fl_hide_object (rangeForm->intInputs);
    fl_show_object (rangeForm->floatInputs);
  }

  // Restore range and loop settings
  if (!rangeValid)
    sample->rangeClear ();
  if (susLoopMode == AF_LOOP_MODE_NOLOOP)
    sample->setSusLoopMode (AF_LOOP_MODE_NOLOOP);
  if (relLoopMode == AF_LOOP_MODE_NOLOOP)
    sample->setRelLoopMode (AF_LOOP_MODE_NOLOOP);

  fl_redraw_object (mainForm->sample);
  updateRangeDetails ();
  updateLoopDetails ();

  item=fl_get_sample_undomode (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->undoButton,TRUE);
  else
    fl_set_button (prefsForm->undoButton,FALSE);

  item=fl_get_sample_autowindows (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->autowindowsButton,TRUE);
  else
    fl_set_button (prefsForm->autowindowsButton,FALSE);

  item=fl_get_sample_autoglobals (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->autoglobalsButton,TRUE);
  else
    fl_set_button (prefsForm->autoglobalsButton,FALSE);

  item=fl_get_sample_autoeditmode (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->autoeditmodeButton,TRUE);
  else
    fl_set_button (prefsForm->autoeditmodeButton,FALSE);

  item=fl_get_sample_copysave (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->copysaveButton,TRUE);
  else
    fl_set_button (prefsForm->copysaveButton,FALSE);

  item=fl_get_sample_tooltips (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->tooltipsButton,TRUE);
  else
    fl_set_button (prefsForm->tooltipsButton,FALSE);
  
  const char *textItem = fl_get_sample_tempdir (mainForm->sample);
  
  if (item)
    fl_set_input (prefsForm->tempdir,textItem);
  else
    fl_set_input (prefsForm->tempdir,"");

  char tempString [80];
  
  sprintf (tempString,"%d",normalIdle);
  fl_set_input (prefsForm->normalidle,tempString);

  sprintf (tempString,"%d",heavyIdle);
  fl_set_input (prefsForm->heavyidle,tempString);

  item=fl_get_sample_rangealt (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->rangealtButton,TRUE);
  else
    fl_set_button (prefsForm->rangealtButton,FALSE);

  item=fl_get_sample_rangecross (mainForm->sample);
  
  if (item)
    fl_set_button (prefsForm->rangecrossButton,TRUE);
  else
    fl_set_button (prefsForm->rangecrossButton,FALSE);
}

/*---------------------------------------------------------------------------
| FUNCTION updateSamplePrefs
---------------------------------------------------------------------------*/

void updateSamplePrefs (void)
{
  if (fl_get_button (prefsForm->dotsButton))
    fl_set_sample_drawmode (mainForm->sample,0);
  else if (fl_get_button (prefsForm->linesButton))
    fl_set_sample_drawmode (mainForm->sample,1);
  else
    fl_set_sample_drawmode (mainForm->sample,2);

  if (fl_get_button (prefsForm->quickButton))
    fl_set_sample_drawaccuracy (mainForm->sample,0);
  else
    fl_set_sample_drawaccuracy (mainForm->sample,1);

  if (fl_get_button (prefsForm->axisButton))
    fl_set_sample_axis (mainForm->sample,1);
  else
    fl_set_sample_axis (mainForm->sample,0);

  if (fl_get_button (prefsForm->framesButton))
    fl_set_sample_frames (mainForm->sample,1);
  else
    fl_set_sample_frames (mainForm->sample,0);
  
  if (fl_get_button (prefsForm->undoButton))
    fl_set_sample_undomode (mainForm->sample,1);
  else
  {
    waitCursorOn ();
    clearBuffers ();
    waitCursorOff ();
    fl_set_sample_undomode (mainForm->sample,0);
  }

  if (fl_get_button (prefsForm->autowindowsButton))
    fl_set_sample_autowindows (mainForm->sample,1);
  else
    fl_set_sample_autowindows (mainForm->sample,0);

  if (fl_get_button (prefsForm->autoglobalsButton))
    fl_set_sample_autoglobals (mainForm->sample,1);
  else
    fl_set_sample_autoglobals (mainForm->sample,0);

  if (fl_get_button (prefsForm->autoeditmodeButton))
    fl_set_sample_autoeditmode (mainForm->sample,1);
  else
    fl_set_sample_autoeditmode (mainForm->sample,0);

  if (fl_get_button (prefsForm->copysaveButton))
    fl_set_sample_copysave (mainForm->sample,1);
  else
    fl_set_sample_copysave (mainForm->sample,0);

  if (fl_get_button (prefsForm->tooltipsButton))
  {
    fl_set_sample_tooltips (mainForm->sample,1);
    tooltips_resume ();
  }
  else
  {
    fl_set_sample_tooltips (mainForm->sample,0);
    tooltips_suspend ();
  }
  
  const char *textItem = fl_get_input (prefsForm->tempdir);
  fl_set_sample_tempdir (mainForm->sample,textItem);
  
  fl_set_idle_delta (normalIdle);
    
  if (fl_get_button (prefsForm->rangealtButton))
    fl_set_sample_rangealt (mainForm->sample,1);
  else
    fl_set_sample_rangealt (mainForm->sample,0);

  if (fl_get_button (prefsForm->rangecrossButton))
    fl_set_sample_rangecross (mainForm->sample,1);
  else
    fl_set_sample_rangecross (mainForm->sample,0);

  fl_redraw_object (mainForm->sample);
}

/*---------------------------------------------------------------------------
| FUNCTION defaultSamplePrefs
---------------------------------------------------------------------------*/

void defaultSamplePrefs ()
{
  // Set prefs to default values
  fl_set_sample_drawmode (mainForm->sample,1);
  fl_set_sample_drawaccuracy (mainForm->sample,0);
  fl_set_sample_axis (mainForm->sample,1);
  fl_set_sample_frames (mainForm->sample,1);
  fl_set_sample_undomode (mainForm->sample,1);
  fl_set_sample_autowindows (mainForm->sample,1);
  fl_set_sample_autoglobals (mainForm->sample,1);
  fl_set_sample_autoeditmode (mainForm->sample,1);
  fl_set_sample_copysave (mainForm->sample,1);
  fl_set_sample_tooltips (mainForm->sample,1);
  fl_set_sample_rangealt (mainForm->sample,0);
  fl_set_sample_rangecross (mainForm->sample,0);
  updatePrefsForm ();
  preferencesChanged = FALSE;
}

/***************************************************************************/
