/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPTich_macros.h
|
| Revision    : 1.0
| Date        : 26/05/97
|
| Object      : None
|
| Description : Macro handler header file
|
| (c) Richard Kent 1997
|
| $Id$
|
****************************************************************************/

#ifndef _DPTich_macros_h
#define _DPTich_macros_h

#include "forms.h"
#include "DPSample.h"
#include "DPTich_prefs.h"

#define MACROSNAME         ".DAP.macros"
#define MACROCOMMANDLENGTH 256
#define MACRONAMELENGTH    128
#define MAXMACROS          32

#define MACROCURRENTBUFFER 1
#define MACROALLBUFFERS    2
#define MACRORAWMODE       1
#define MACROTEXTMODE      2
#define MACROTEMPAIFFMODE  3
#define MACROSAVEAIFFMODE  4
#define MACROBUFFERINPUT   1
#define MACRORANGEINPUT    2
#define MACROEITHERINPUT   3
#define MACRONONEINPUT     4
#define MACROBUFFEROUTPUT  1
#define MACRODIALOGOUTPUT  2
#define MACRONONEOUTPUT    3
#define MACROBYTEFORMAT    1
#define MACROSHORTFORMAT   2
#define MACROLONG24FORMAT  3
#define MACROLONG32FORMAT  4
#define MACROFLOATFORMAT   5
#define MACRODOUBLEFORMAT  6
#define MACROSIGNED        1
#define MACROUNSIGNED      2

typedef struct
{
  char name [MACRONAMELENGTH];
  int bufferMode;
  int processMode;
  int input;
  int output;
  int dataFormat;
  int dataSigned;
  char command [MACROCOMMANDLENGTH];
} macroType;

extern macroType macro [MAXMACROS];
extern long numberMacros;
extern long currentMacro;

int loadMacros ();
int saveMacros ();
void defaultMacros (void);
void updateMacroForm (void);
long findMacro (const char *name);
char *executeMacro (const char *name);
char *executeSingleMacro (int macroNumber,int bufferNumber);
void macroexecBrowserDbl_cb (FL_OBJECT *ob,long data);
int findNonSpace (const char *name);

inline signed long limitSLValue (signed long value,signed long min,signed long max);
inline unsigned long limitULValue (unsigned long value,unsigned long min,unsigned long max);
inline float limitFValue (float value,float min,float max);
inline double limitDValue (double value,double min,double max);

/*---------------------------------------------------------------------------
| FUNCTION limitValue
---------------------------------------------------------------------------*/

signed long limitSLValue (signed long value,signed long min,signed long max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

unsigned long limitULValue (unsigned long value,unsigned long min,unsigned long max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

float limitFValue (float value,float min,float max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

double limitDValue (double value,double min,double max)
{
  if (value < min) return min;
  if (value > max) return max;
  return value;
}

#endif // _DPTich_macros_h

/***************************************************************************/
