% class like report
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{debiandoc}
              [1997/06/24 v0.2 Class for debiandoc2latex (cl)]

\RequirePackage{ifthen}
\newboolean{booklet}

\DeclareOption{booklet}{\setboolean{booklet}{true}}

\DeclareOption*{\PassOptionsToClass{\CurrentOption}{report}}
\ProcessOptions


%%%%% load original article class %%%%%

\LoadClass{report}[1996/10/31]

\RequirePackage{german}
\RequirePackage{t1enc}
\RequirePackage[latin1]{inputenc}
\RequirePackage{varioref}

%%% select postscript fonts 
\RequirePackage{helvet}        % helvetica for sf 
\RequirePackage{times}         % times for the normal text

%\RequirePackage{courier}       % courier for tt

\RequirePackage{verbatim}
\RequirePackage{moreverb}


%%%%%%%%%%%%%% german section format:
\parindent=0pt
\setlength{\parskip}{%
0.5\baselineskip plus0.1\baselineskip minus0.1\baselineskip}

\topmargin -32pt


% check commands which we will manipulte
\CheckCommand{\chapter}{%
  \if@openright\cleardoublepage\else\clearpage\fi
  \thispagestyle{plain}%
  \global\@topnum\z@
  \@afterindentfalse
  \secdef\@chapter\@schapter}
%\CheckCommand{\@makechapterhead}[1]{%
%  \vspace*{50\p@}%
%  {\parindent \z@ \raggedright \normalfont
%    \ifnum \c@secnumdepth >\m@ne
%        \huge\bfseries \@chapapp\space \thechapter
%        \par\nobreak
%        \vskip 20\p@
%    \fi
%    \interlinepenalty\@M
%    \Huge \bfseries #1\par\nobreak
%    \vskip 40\p@
%  }}
%\CheckCommand{\@makeschapterhead}[1]{%
%  \vspace*{50\p@}%
%  {\parindent \z@ \raggedright
%    \normalfont
%    \interlinepenalty\@M
%    \Huge \bfseries  #1\par\nobreak
%    \vskip 40\p@
%  }}

\renewcommand{\chaptermark}[1]{%
  \markboth{\DocumentTitle}{\thechapter\ ~#1}}

% make lists more compact
\newenvironment{ditemize}{%
\begin{list}{\labelitemi}{%
\topsep0.5ex plus0.3ex minus0.1ex \partopsep0ex plus0.3ex
\parsep0.3ex plus0.2ex  minus0.1ex \itemsep0.3ex plus0.2ex minus0.1ex
}}
{\end{list}}

% even more compact
\newenvironment{dcompitemize}{%
\begin{list}{\labelitemi}{%
\topsep0.2ex plus0.2ex \partopsep0ex plus0.2ex
\parsep0ex plus0.2ex \itemsep0.2ex plus0.2ex minus0.1ex
}}
{\end{list}}

\newenvironment{denumerate}{%
\begin{list}{\labelenumi}{%
\topsep0.5ex plus0.3ex minus0.1ex \partopsep0ex plus0.3ex
\parsep0.3ex plus0.2ex  minus0.1ex \itemsep0.3ex plus0.2ex minus0.1ex
}}
{\end{list}}

% even more compact
\newenvironment{dcompenumerate}{%
\begin{list}{\labeenumi}{%
\topsep0.2ex plus0.2ex \partopsep0ex plus0.2ex
\parsep0ex plus0.2ex \itemsep0.2ex plus0.2ex minus0.1ex
}}%
{\end{list}}

% environment for examples
\newenvironment{dexample}{%
%\begin{boxedverbatim}:
  \def\verbatim@processline{%
    {\setbox0=\hbox{\the\verbatim@line}%
    \hsize=\wd0 \the\verbatim@line\par}}%
  \@minipagetrue%%%DPC%%%
  \small%
  \@tempswatrue%%%DPC%%%
  \setbox0=\vbox\bgroup \verbatim
}{%
%\end{boxedverbatim}:
  \endverbatim
  \unskip\setbox0=\lastbox %%%DPC%%%
  \egroup
  \setlength{\fboxrule}{1pt}%\setlength{\fboxsep}{1pt}
  \framebox[\linewidth][l]{\box0}% <<<=== change here for centering,...
}


\renewcommand{\@dottedtocline}[5]{%
  \ifnum #1>\c@tocdepth \else
    %\vskip \z@ \@plus.2\p@
    {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
     \parindent #2\relax\@afterindenttrue
     \interlinepenalty\@M
     \leavevmode
     \@tempdima #3\relax
     \advance\leftskip \@tempdima \null\nobreak\hskip -\leftskip
     {#4}\nobreak
     \leaders\hbox{$\m@th
        \mkern \@dotsep mu\hbox{.}\mkern \@dotsep
        mu$}\hfill
     \nobreak
     \hb@xt@\@pnumwidth{\hfil\normalfont \normalcolor #5}%
     \par}%
  \fi}


% special paper size and page layout for CD-Booklet
\ifthenelse{\boolean{booklet}}   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Booklet
  {%
\setlength{\paperheight}{208mm}
\setlength{\textheight}{170mm}
\setlength{\headheight}{9mm}
\setlength{\headsep}{6mm}

\setlength{\footskip}{0pt}% no footer

\setlength{\paperwidth}{210mm}
%spter mal: \setlength{\textwidth}{182mm}
\setlength{\textwidth}{175mm}

\if@twoside
  \oddsidemargin  0cm
  \evensidemargin 0cm
\else
  \oddsidemargin  0.5cm
  \evensidemargin 0.5cm
\fi
\marginparwidth 5pt       % no margin
\marginparsep 0pt

\renewcommand{\chapter}{%
  \clearpage
  \global\@topnum\z@
  \@afterindentfalse
  \secdef\@chapter\@schapter}
\renewcommand{\@makechapterhead}[1]{%
  {\parindent \z@ \raggedright \normalfont
    \interlinepenalty\@M
    \LARGE \bfseries 
    \ifnum \c@secnumdepth >\m@ne
        \thechapter\hspace{1.1em}
    \fi
    #1\par\nobreak
%    \vskip 40\p@
    \vskip 10\p@
  }}
\renewcommand{\@makeschapterhead}[1]{%
  {\parindent \z@ \raggedright \normalfont
    \interlinepenalty\@M
    \LARGE \bfseries  
    #1\par\nobreak
%    \vskip 40\p@
    \vskip 10\p@
  }}

\renewcommand{\section}{\@startsection {section}{1}{\z@}%
  {-2ex \@plus -1ex \@minus -.2ex}%
  {.5ex \@plus.2ex}%
  {\normalfont\Large\bfseries}}
\renewcommand{\subsection}{\@startsection{subsection}{2}{\z@}%
  {-1.5ex\@plus -1ex \@minus -.2ex}%
  {.4ex \@plus .2ex}%
  {\normalfont\large\bfseries}}



}{%                      %%%%%%%%%%%%%%%%%%%%%%%%%%%%%  normal a4paper
%\setlength{\paperheight}{297mm}
%\setlength{\paperwidth}{210mm}

\ifcase \@ptsize
    \textheight 53\baselineskip
    \headheight 23pt
\or
    \textheight 46\baselineskip
    \headheight 12pt
\or
    \textheight 42\baselineskip
    \headheight 35pt
\fi
\advance\textheight by \topskip
\ifcase \@ptsize                      %%%%%%%%%%%% 10 pt %%%%%%%%%%%%
    \textwidth      13cm % 5.00in
    \marginparwidth 2.5cm    % 1.00in
  \if@twoside
    \oddsidemargin  1.0cm  % 0.55in
    \evensidemargin 0.2cm  % 0.75in
  \else
    \oddsidemargin  0.8cm  % 0.55in
    \evensidemargin 0.8cm  % 0.55in
  \fi
\or                                   %%%%%%%%%%%% 11 pt %%%%%%%%%%%%
    \textwidth      15cm % 5.20in
    \marginparwidth 1.6cm    % 1.00in
  \if@twoside
    \oddsidemargin  1.0cm  % 0.45in - 1.143 cm
    \evensidemargin 0.2cm    % 0.65in - 1.651 cm
  \else
    \oddsidemargin  0.8cm  % 0.45in
    \evensidemargin 0.8cm  % 0.45in
  \fi
\or                                   %%%%%%%%%%%% 12 pt %%%%%%%%%%%%
    \textwidth      16.0cm % 5.70in
    \marginparwidth 3cm  % 0.80in
  \if@twoside
    \oddsidemargin  0.4cm  % 0.20in
    \evensidemargin 0cm    % 0.40in
  \else
    \oddsidemargin  0.3cm  % 0.20in
    \evensidemargin 0.3cm  % 0.20in
  \fi
\fi
\setlength{\footskip}{46pt}%20pt}%36pt
\setlength{\headsep}{36pt}% 20pt
\marginparsep 10pt
}


%%%%%%%%%%%%%%%%%%%%%%%%%% new headings
\newcommand{\DocumentTitle}{}

\newcommand{\ps@debiandocheadings}{%
%heading
\renewcommand{\@oddhead}{%
\begin{minipage}{\textwidth}%
{\bfseries\rightmark \hfill \thepage}\\[1.1ex]%
\rule[3ex]{\textwidth}{0.5pt}%
\end{minipage}%
}%
\if@twoside
\renewcommand{\@evenhead}{%
\begin{minipage}{\textwidth}%
{\bfseries\thepage \hfill \leftmark}\\[1.1ex]%
\rule[3ex]{\textwidth}{0.5pt}%
\end{minipage}%
}%
\else
  \renewcommand{\@evenhead}{\@oddhead}%
\fi

% no footer
\renewcommand{\@oddfoot}{}
\renewcommand{\@evenfoot}{\@oddfoot}
}

\pagestyle{debiandocheadings}


\newcommand{\mybackslash}{$\backslash$}



