/*
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Brian W. Barrett, Arun F. Rodrigues, Jeffrey M. Squyres,
 * 	 and Andrew Lumsdaine
 *
 * This file is part of XMPI
 *
 * You should have received a copy of the License Agreement for XMPI 
 * along with the software; see the file LICENSE.  If not, contact 
 * Office of Research, University of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.
 *
 * Additional copyrights may follow.

 *
 *	$Id: xmpi_sys.h,v 1.2 1999/11/08 06:20:26 bbarrett Exp $
 *
 *	Function:	- XMPI portable definitions
 */

#ifndef _XMPI_SYS_H
#define _XMPI_SYS_H

#include "app_schema.h"
#include "args.h"
#include "blktype.h"
#include "mpitrace.h"
#include "ndi.h"

/*
 * process, trace and database states 
 */

#define XMPI_SMISSING   	(-2)		/* missing, trace/dbase only */
#define XMPI_SUNDEF		(-1)		/* undefined */
#define XMPI_SRUN		TRDTRUN		/* running */
#define XMPI_SBLOCK		TRDTBLOCK	/* blocked */
#define XMPI_SSYSTEM		TRDTSYSTEM	/* system overhead */

/*
 * MPI wildcards
 */

#define XMPI_ANY_SOURCE		(-1)
#define XMPI_ANY_TAG		(-1)

/*
 * MPI context IDs
 */

#define XMPI_CID_WORLD		0
#define XMPI_CID_SELF		1
#define XMPI_CID_PARENT		2

/*
 * MPI datatypes
 */

#define XMPI_CONTIG		0
#define XMPI_VECTOR		1
#define XMPI_HVECTOR		2
#define XMPI_INDEXED		3
#define XMPI_HINDEXED		4
#define XMPI_STRUCT		5
#define XMPI_BYTE		6
#define XMPI_CHAR		7
#define XMPI_UCHAR		8
#define XMPI_SHORT		9
#define XMPI_USHORT		10
#define XMPI_INT		11
#define XMPI_UINT		12
#define XMPI_LOGICAL		13
#define XMPI_LONG		14
#define XMPI_ULONG		15
#define XMPI_FLOAT		16
#define XMPI_DOUBLE		17
#define XMPI_COMPLEX		18
#define XMPI_UB			19
#define XMPI_LB			20
#define XMPI_PACKED		21
#define XMPI_2INT		22
#define XMPI_2FLOAT		23
#define XMPI_2DOUBLE		24
#define XMPI_FLOAT_INT		25
#define XMPI_DOUBLE_INT		26
#define XMPI_LONG_INT 		27
#define XMPI_SHORT_INT		28
#define XMPI_LONG_DOUBLE	29
#define XMPI_LONG_DOUBLE_INT	30
#define XMPI_INTEGER		31
#define XMPI_CHARACTER		32
#define XMPI_REAL		33
#define XMPI_DOUBLE_PRECISION	34
#define XMPI_DOUBLE_COMPLEX	35
#define XMPI_2INTEGER		36
#define XMPI_2REAL		37
#define XMPI_2DOUBLE_PRECISION	38
#define XMPI_LONG_LONG_INT	39		/* non-LAM types start here */
#define XMPI_INTEGER1		40
#define XMPI_INTEGER2		41
#define XMPI_INTEGER4		42
#define XMPI_INTEGER8		43
#define XMPI_REAL4		44
#define XMPI_REAL8		45
#define XMPI_REAL16		46

#define XMPI_MAX_BASIC_TYPE	46		/* all above this are derived */

/*
 * structures
 */

struct xmproc {
	int		xmp_cx;		/* center x ordinate */
	int		xmp_cy;		/* center y ordinate */
	int		xmp_state;	/* process state */
	int		xmp_func;	/* process function */
	int		xmp_wfunc;	/* process wrapper function */
	int		xmp_tag;	/* process tag */
	int		xmp_lrank;	/* process local rank */
	int		xmp_lpeer;	/* process local peer rank */
	int		xmp_lroot;	/* process local root rank */
	int		xmp_gpeer;	/* process global peer rank */
	int		xmp_groot;	/* process global root rank */
	int		xmp_cid;	/* process context ID */
	int		xmp_cnt;	/* process count */
	int		xmp_dtype;	/* process datatype */
	int		xmp_nmsg;	/* total # of messages */
	int		xmp_more;	/* more messages */
	LIST		*xmp_msgs;	/* list of messages */
	struct xmmsg	*xmp_curmsg;	/* ptr current message */
	char		xmp_prog[TRDPROGMAX];	/* program name */
};

struct xmmsg {
	int		xmm_tag;	/* message tag */
	int		xmm_lsrc;	/* message local source rank */
	int		xmm_gsrc;	/* message global source rank */
	int		xmm_cid;	/* message context ID */
	int		xmm_cnt;	/* message count */
	int		xmm_dtype;	/* message datatype */
	int		xmm_nmsg;	/* # of these messages */
};

/*
 * prototypes
 */

#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int	xmpi_sys_snapshot __ARGS((struct _gps *, int, struct xmproc *));
extern int	xmpi_sys_init __ARGS((char *));
extern int	xmpi_sys_kill __ARGS((struct _gps *, int));
extern int	xmpi_sys_run __ARGS((char *, struct _gps **, int *));
extern int	xmpi_sys_trace __ARGS((int, struct _gps *, int));
extern void	xmpi_sys_finalize __ARGS((void));
extern void	*xmpi_sys_comm __ARGS((struct _gps *, int));
extern void	*xmpi_sys_dtype __ARGS((struct _gps *, int));
extern char	**xmpi_sys_logo  __ARGS((void));
extern char	*xmpi_sys_errorstr __ARGS((int));
extern char	**xmpi_sys_hosts __ARGS((void));
extern char	*xmpi_sys_version  __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _XMPI_SYS_H */
