/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */
#include <vdkb/vdkb_radiobutton.h>
#include <vdkb/vdkb_evbox.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_form.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_prjman.h>
#include <stdlib.h>
#include <vdkb/vdkb_fixed.h>
/*
================================
symbolic constants to templatize
a bit
================================
*/
// for methods and other stuff
#define CLASS VDKBRadioButton
// put here vdk class name string
#define VDK_CLASS "VDKRadioButton"
// put here vdk class name
#define VDK_ANCESTOR  VDKRadioButton
// put here here the widget will be named
// (name+counter)
#define VDK_WIDGET "radiobutton"

static char buff[128];
extern bool onDraggingAnObjectIntoAFixed;
extern GtkWidget *grabbed_widget;
int
CLASS::OnButtonEvent(GtkWidget *w, GdkEvent* event, void* o)
{
  g_return_val_if_fail(o != NULL, FALSE);
  g_return_val_if_fail(w != NULL, FALSE);
  CLASS* obj = reinterpret_cast<CLASS*>(o);
  VDKBEventContainer* container;
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),
			       "button_press_event");
  container = dynamic_cast<VDKBEventContainer*>(obj->ObjectFromVDK()->Parent());
  if(container)
    container->OnButtonPressed(obj,event);
  return TRUE;
}

int
CLASS::OnEnterEvent(GtkWidget *w,
				  GdkEvent* event,
				  void* o)
{
  g_return_val_if_fail(o != NULL, FALSE);
  g_return_val_if_fail(w != NULL, FALSE);
  //CLASS* obj = reinterpret_cast<CLASS*>(o);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),"enter_notify_event");
  return true;
}

int
CLASS::OnLeaveEvent(GtkWidget *w,
				  GdkEvent* event,
				  void* o)
{
  g_return_val_if_fail(o != NULL, FALSE);
  g_return_val_if_fail(w != NULL, FALSE);
  //  CLASS* obj = reinterpret_cast<CLASS*>(o);
  gtk_signal_emit_stop_by_name(GTK_OBJECT(w),"leave_notify_event");
  return true;
}
//////////////////////////////////////////////////////////////
/*
  - constructor
 */
CLASS::CLASS(char* name, VDKForm* owner,
				 char* label, char* tip = NULL):
  VDKBCheckButton(name,owner,label,tip)
{
  gtk_widget_destroy(widget);
  widget = gtk_radio_button_new_with_label(NULL,label);
  // newly constructed widget counter is incremented
  // each time
  Counter++;
  // assign this to VDKBObject <object> member.
  object = this;
  gtk_signal_connect(GTK_OBJECT(widget),"button_press_event",
		   GTK_SIGNAL_FUNC(CLASS::OnButtonEvent),
			       reinterpret_cast<gpointer>(this));
  gtk_signal_connect(GTK_OBJECT(widget),"enter_notify_event",
		   GTK_SIGNAL_FUNC(CLASS::OnEnterEvent),
			       reinterpret_cast<gpointer>(this));
  gtk_signal_connect(GTK_OBJECT(widget),"leave_notify_event",
		   GTK_SIGNAL_FUNC(CLASS::OnLeaveEvent),
			       reinterpret_cast<gpointer>(this));

}
////////////////////////////////////////////////////////////////
//
//               WRITER TO .FRM FILE
//
///////////////////////////////////////////////////////////////
/*
Writes a .frm format representation of label button widget
This virtual function is called by VDKBForm::WriteBoxesOnFrm()
a recursive algorithm that scans VDKBForm widget tree.
*/
void
CLASS::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  // first of all call ancestor to write common properties
  VDKBObject::WriteOnFrm(fp,parentobj);
  fprintf(fp,"\n\t%s\"%s\";",
	  PROP_CAPTION,(char*) GetProp(CAPTION));
  fprintf(fp,"\n\t%s%s;",
	  PROP_CAPTIONWRAP,(char*) GetProp(CAPTIONWRAP));
}
//////////////////////////////////////////////////////////////////
//
//               PREPARE GUI WIDGETS
//
//////////////////////////////////////////////////////////////////
/*
This method is called by global MakeWidget() in vdkb_design.cc
MakeWidget() scans a table that maps class id's with each
static MakeWidget() for each class. Class id's are generated
during clicks on widget palette.
On return:
0 - successfull
1 - unsupported widget
2 - target is not a container
 */
int
CLASS::MakeWidget(VDKBGuiForm* owner, GdkEvent* ev)
{
  CLASS* button = NULL;
 // widget name generation failed
  if(!owner->GenerateWidgetName(buff,VDK_WIDGET,&CLASS::Counter))
    // unauthorized operation
    return 2;
  else
    button = new CLASS(buff,owner,buff);
  return owner->AddToSelf(button,ev);
}
/*
This is called by a global CreateSource() in vdkb_parser.cc.
CreateSource() scans a table that maps class names with
each static CreateSource() in widget class.
 */
char*
CLASS::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_parent[128];
  char arg[64];
  char tmp[256];
  char obj_caption[128];
  // gets widget name and parent name
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
     return NULL;
  source = new char[4096];
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  sprintf(tmp,"\n%s = new %s(this,\"%s\");",
	  obj_name,VDK_CLASS,obj_caption);
  strcpy(source,tmp);
  ///////////////////////////////////////
  // call ancestor to set common properties
  char* props = VDKBObject::CreateSource(buffer,parser,obj_name);
  if(props)
    {
      strcat(source,props);
      delete[] props;
    }
  // get label button  props
  if(parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) &&
     strcmp(arg,NIHIL_PROP))
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,CAPTIONWRAP,arg);
     strcat(source,tmp);
   }
  // set widget specific properties
  // get label button  props
  if(parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) &&
     strcmp(arg,NIHIL_PROP)
     )
   {
     sprintf(tmp,"\n%s->%s = %s;",obj_name,CAPTIONWRAP,arg);
     strcat(source,tmp);
   }
  // get code that adds widget to container
  parser.WriteCodeToPack(obj_parent,obj_name,source,buffer,tmp);
  /*
    visible property must be wrote after adding it to a parent
    container. That's the reason why is written here and not
    in vdkb_object class as should be. Written only if == false
  */
  parser.WriteVisible( obj_name, arg, source,buffer,  tmp);
  return source;
}
/*
Invoked by VDKBGuiForm::MakeGuiObjects() during gui creation
reading .frm file.
MakeGuiObjects() scans .frm file and call a global CreateWidget()
that scans a table that maps class names with
each static CreateWidget() in widget class.
*/
bool
CLASS::CreateWidget(VDKBGuiForm* owner,
			      char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_parent[128];
  char obj_caption[256];
  char arg[64];
  CLASS* button;
 // get widget name and parent
  if(! parser.GetNameAndParent(buffer, obj_name, obj_parent))
    return false;
  // get caption
  if(!parser.GetParam(obj_caption,buffer,PROP_CAPTION))
    strcpy(obj_caption,"none");
  VDKObject* p = owner->ChildWithName(obj_parent);
  VDKBEventContainer* container = p ?
    dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
  if(container)
    {
      button = new CLASS(obj_name,owner,obj_caption);
      if(parser.GetParam(arg,buffer,PROP_CAPTIONWRAP) &&
	 strcmp(arg,NIHIL_PROP))
	{
	button->CaptionWrap = !strcmp(arg,CHECK_TRUE);
	button->SetPropValue(CAPTIONWRAP,arg);
	}
      // pack widget to container
      return owner->PackToSelf(button, container, buffer, parser);
    }
  else
    return false;
}









