/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.7
 * September 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb/vdkb_compodb.h>
#include <vdkb/vdkb.h>
#include <vdkb/vdkb_plugin.h>

extern VDKBuilder* TheApp;
static char buff[256];

DEFINE_SIGNAL_MAP(VDKBCompodbForm,VDKForm)
ON_SIGNAL(closeButton,clicked_signal,OncloseButtonClick),
ON_SIGNAL(compoList,select_row_signal,OncompoListSelectRow),
ON_SIGNAL(deleteButton,clicked_signal,OndeleteButtonClick),
ON_SIGNAL(addButton,clicked_signal,OnaddButtonClick),
ON_SIGNAL(modifyButton,clicked_signal,OnmodifyButtonClick),
ON_SIGNAL(saveButton,clicked_signal,OnsaveButtonClick)
END_SIGNAL_MAP

/*
form constructor
*/
VDKBCompodbForm::VDKBCompodbForm(VDKForm* owner, char* title):
	VDKForm(owner,title)
{
}

/*
main form destructor
*/
VDKBCompodbForm::~VDKBCompodbForm()
{
}


/*
main form setup
*/
void
VDKBCompodbForm::Setup(void)
{
  GUISetup(); // vdkb gui setup
  // put your code below here
  Changed = false;
}
/*
main form setup
*/
void
VDKBCompodbForm::GUISetup(void)
{
  SetSize(450,315);
  Title = "VDKBuilder component database";
  vbox1 = new VDKBox(this,v_box);
  Add(vbox1,0,1,1,0);
  char* compoListTitles[] = { "Compo","Library name","Library path",
			      " Id ","Valid","Component name","Error" };
  compoList = new VDKCustomList(this,7,compoListTitles,(GtkSelectionMode) 0);
  compoList->RowHeight = 25;
  compoList->SetSize(400,200);
  vbox1->Add(compoList,0,1,1,3);
  separator0 = new VDKSeparator(this,h_separator);
  vbox1->Add(separator0,0,0,0,3);
  hbox2 = new VDKBox(this,h_box);
  hbox2->SetSize(400,25);
  vbox1->Add(hbox2,0,0,0,3);
  hbox2->BorderWidth(0);
  closeButton = new VDKLabelButton(this,"Close");
  closeButton->Relief = (GtkReliefStyle) 0;
  hbox2->Add(closeButton,0,1,1,3);
  deleteButton = new VDKLabelButton(this,"Delete");
  hbox2->Add(deleteButton,0,1,1,3);
  addButton = new VDKLabelButton(this,"Add");
  hbox2->Add(addButton,0,1,1,3);
  modifyButton = new VDKLabelButton(this,"Modify");
  hbox2->Add(modifyButton,0,1,1,3);
  // disabled for now
  modifyButton->Enabled = false;
  saveButton = new VDKLabelButton(this,"Save");
  saveButton->Enabled = true;
  hbox2->Add(saveButton,0,1,1,3);
  statusbar0 = new VDKStatusbar(this);
  statusbar0->SetSize(391,25);
  vbox1->Add(statusbar0,l_justify,false,false,0);
}
//
char *strnzcpy(char *trgt, const char *src, int n)
//copies max (n-1) bytes from src to trgt and adds a zero, if neccessary
{
        trgt[--n] = 0;
        return strncpy(trgt,src,n);
}
void
VDKBCompodbForm::LoadComponentDb()
{
  //  char libname[128],libpath[128],id[16],valid[12],name[128],error[128];
# define MAX_MSG 128
 char libname[MAX_MSG],libpath[MAX_MSG],
   id[16],valid[12],name[MAX_MSG],error[MAX_MSG];
  char* compo = "";	
  char *columns[] = {compo,libname,libpath,id,valid,name,error};
  char **icon;
  compoList->Clear();

  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++)
    {
      VDKBPlugin plugin = li.current();
      //strcpy(libname,plugin.LibName());
      //strcpy(libpath,plugin.PathName());
      strnzcpy(libname,plugin.LibName(),MAX_MSG);
      strnzcpy(libpath,plugin.PathName(),MAX_MSG);
      if(plugin.IsValid())
	sprintf(id,"%d",plugin.Id());
      else
	strcpy(id," ");
      strcpy(valid,plugin.IsValid() ? "yes" : "*no*");
      // strcpy(name,plugin.IsValid() ? plugin.Interface()->VDKName(): " ");
      // strcpy(error,plugin.Error() ? plugin.Error() : " ");
      strnzcpy(name,plugin.IsValid() ? plugin.Interface()->VDKName():
	      " ",MAX_MSG);
      strnzcpy(error,plugin.Error() ? plugin.Error() : " ",MAX_MSG);
      icon = (char**) plugin.Icon();
      compoList->AddRow(columns, icon,0);
    }
}
//
bool
VDKBCompodbForm::SaveComponentDb()
{
  sprintf(buff,"%s/.vdkb/%s",(char*) TheApp->user_home,VDKB_PLUGIN_FILE);
  FILE* fp = fopen(buff,"w+");
  if(!fp)	
      return false;
  VDKBPluginListIterator li(TheApp->PluginList());
  for(;li;li++)
	fprintf(fp,"%s,%s\n",
		(char*) li.current().PathName(),
		(char*) li.current().LibName());
  fclose(fp);
  return true;
}
//
void
VDKBCompodbForm::OnShow(VDKForm* sender)
{
  LoadComponentDb();
}

bool
VDKBCompodbForm::CanClose()
{
    if(Changed &&	
       (Application()->MessageBox(APPNAME,
				       "Component database changed\nsave it ?",
				       MB_ICONQUESTION|MB_YESNO,
				       user_messages[user_ok],
				       user_messages[user_no]) == IDYES))
	OnsaveButtonClick(NULL);
    return true;
}
// signal response method
bool
VDKBCompodbForm::OncloseButtonClick(VDKObject* sender)
{
  Close();
  return true;
}

// signal response method
bool
VDKBCompodbForm::OncompoListSelectRow(VDKObject* sender)
{
  return true;
}

// signal response method
bool
VDKBCompodbForm::OndeleteButtonClick(VDKObject* sender)
{
    int ndx = compoList->Selected.Row();
    if( (ndx < 0) ||
	(ndx >= TheApp->PluginList().size())
	)
	return true;
    (TheApp->PluginList())[ndx].DlClose();
    TheApp->PluginList().unlink(ndx);
    compoList->RemoveRow(ndx);
    Changed = true;
    saveButton->Enabled = Changed;	
    return true;
}

// signal response method
bool
VDKBCompodbForm::OnaddButtonClick(VDKObject* sender)
{
    char libpath[256];
    char libname[256];
    char* compo = "";	
    char id[16],valid[12],name[128],error[128];
    char *columns[] = {compo,libname,libpath,id,valid,name,error};
    char ** icon;
    *libpath = *libname = '\0';
    VDKBCompoInputForm* child = new VDKBCompoInputForm(this,
						       libpath,
						       libname);
    child->Setup();
    child->ShowModal(GTK_WIN_POS_CENTER);
    if(*libpath && *libname)
	{
	    strcpy(id,"n/a");
	    VDKBPlugin plugin(libpath,libname);
	    plugin.DlOpen();
    	    strcpy(valid,plugin.IsValid() ? "yes" : "*no*");
	    strcpy(name,plugin.IsValid() ?
		   plugin.Interface()->VDKName():
		   " ");
	    strcpy(error,plugin.Error() ? plugin.Error() : " ");
	    icon = (char**) plugin.Icon();	
	    TheApp->PluginList().add(plugin);
	    compoList->AddRow(columns,icon,0);
	    Changed = true;
	}
    saveButton->Enabled = Changed;
    return true;	
}

// signal response method
bool
VDKBCompodbForm::OnmodifyButtonClick(VDKObject* sender)
{
  return true;
}

// signal response method
bool
VDKBCompodbForm::OnsaveButtonClick(VDKObject* sender)
{
    if(!SaveComponentDb())
	Application()->MessageBox(
				APPNAME,
				"Could not save component database",
				MB_ICONINFORMATION|MB_OK,
				user_messages[user_ok],
				NULL,
				5000);
    Changed = false;
    return true;
}
////////////////////////////////////
// VDKBCompoInputForm CLASS
///////////////////////////////////
DEFINE_SIGNAL_MAP(VDKBCompoInputForm,VDKForm)
ON_SIGNAL(acceptButton,clicked_signal,OnacceptButtonClick),
    ON_SIGNAL(cancelButton,clicked_signal,OncancelButtonClick)
END_SIGNAL_MAP
/*
form constructor
*/
VDKBCompoInputForm::VDKBCompoInputForm(VDKForm* owner,
				       char* libpath,
				       char* libname):
	VDKForm(owner,(char*) NULL),libpath(libpath),libname(libname)
{
}

/*
main form destructor
*/
VDKBCompoInputForm::~VDKBCompoInputForm()
{
}

/*
main form setup
*/
void
VDKBCompoInputForm::GUISetup(void)
{
	SetSize(321,100);
	Title = "Component database  dialog";
vbox1 = new VDKBox(this,v_box);
Add(vbox1,0,1,1,0);
vbox2 = new VDKBox(this,v_box);
vbox1->Add(vbox2,0,1,1,0);
vbox2->BorderWidth(0);
hbox5 = new VDKBox(this,h_box);
hbox5->SetSize(319,30);
vbox2->Add(hbox5,0,1,1,0);
hbox5->BorderWidth(0);
label0 = new VDKLabel(this,"Enter library path:");
hbox5->Add(label0,0,1,1,0);
libpathEntry = new VDKEntry(this,0);
libpathEntry->SetSize(195,25);
hbox5->Add(libpathEntry,0,1,0,0);
hbox6 = new VDKBox(this,h_box);
hbox6->SetSize(319,30);
vbox2->Add(hbox6,0,1,1,0);
hbox6->BorderWidth(0);
label1 = new VDKLabel(this,"Enter library name:");
label1->SetSize(102,35);
hbox6->Add(label1,0,1,1,0);
libnameEntry = new VDKEntry(this,0);
libnameEntry->SetSize(195,25);
hbox6->Add(libnameEntry,0,1,0,0);
separator1 = new VDKSeparator(this,h_separator);
vbox1->Add(separator1,0,0,0,0);
hbox10 = new VDKBox(this,h_box);
vbox1->Add(hbox10,0,1,1,0);
hbox10->BorderWidth(0);
acceptButton = new VDKCustomButton(this,(char*) NULL,"_Accept",16,(GtkPositionType) 0);
hbox10->Add(acceptButton,0,1,0,0);
cancelButton = new VDKCustomButton(this,(char*) NULL,"_Cancel",16,(GtkPositionType) 0);
hbox10->Add(cancelButton,0,1,0,0);
}
/*
main form setup
*/
void
VDKBCompoInputForm::Setup(void)
{
	GUISetup(); // vdkb gui setup
// put your code below here

}
// signal response method
bool
VDKBCompoInputForm::OnacceptButtonClick(VDKObject* sender)
{
    if(strlen(libpathEntry->Text) > 0)
	strcpy(libpath,libpathEntry->Text);
    else
	*libpath = '\0';
    if(strlen(libnameEntry->Text) > 0)
	strcpy(libname,libnameEntry->Text);
    else
	*libname = '\0';
    Close();
    return true;
}

// signal response method
bool
VDKBCompoInputForm::OncancelButtonClick(VDKObject* sender)
{
    *libname = *libpath = '\0';
    Close();
    return true;	
}
