/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_menubar_h
#define _vdkb_menubar_h

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_evbox.h>
#include <vdk/menu.h>

class VDKBGuiForm;
class VDKBParser;
class VDKBObjectInspector;

class VDKBMenubar: public VDKBEventContainer
{
 protected:
  VDKMenuItem *delBox;
  VDKMenuItem *addmenuitem,*prependmenuitem,*insertmenuitem,
    *delwidget,*setsize;
  // property controls used by object inspector
  VDKEntry *label;
  VDKCombo* shadow;
  VDKLabelButton* set;
  VDKBObjectInspector* inspector; // object inspector
  void Init();
  VDKMenu* popmenu;
 public:

  static int Counter;
  static int MakeWidget(VDKBGuiForm* owner, GdkEvent* ev = NULL);
  static char* CreateSource(char* buffer,VDKBParser& parser);
  static bool CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser);


  VDKBMenubar(char* name, VDKForm* owner);
  VDKBMenubar(char* name, VDKBEventContainer* outer);
  virtual ~VDKBMenubar() {}

  void Add(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs);
  
  void AddBox();
  void AddWidget(VDKObject* w, int justify = l_justify,
		 int expand = TRUE, int fill = TRUE , 
		 int padding = 0, bool forceArgs = false);

  bool AddMenuItem(VDKObject* sender);
  bool PrependMenuItem(VDKObject* sender);
  bool InsertMenuItem(VDKObject* sender);

  void PopMenu() { popmenu->Popup(); }
  bool DelBox(VDKObject* sender);

  bool OnButtonPressed(VDKObject*, GdkEvent*);
  bool OnButtonReleased(VDKObject*, GdkEvent*);

  virtual int Type() { return vdkbmenubar_class; }
  virtual int isA() { return vdkbmenubar_class; }
  virtual char* VDKName() { return "VDKMenubar"; }


  void WriteOnFrm(FILE* fp, VDKBObject* parentobj);
  VDKObjectContainer*  ExtraWidget(VDKBObjectInspector* isp);
  bool OnBorderWidth(VDKObject*);
  bool SetBoxSize(VDKObject* sender);
  bool OnSetShadow(VDKObject*);
  //
  DECLARE_EVENT_LIST(VDKBMenubar);
  DECLARE_SIGNAL_LIST(VDKBMenubar);
};

#endif

