/* TOM/TRT operating system dependencies.
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1996,1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: os.c,v 1.10 1999/03/01 17:47:26 tiggr Exp $  */

#include "trt.h"
#include <tom/tom-r.h>

#if HAVE_OS_OS_C
#include <os/os.c>
#endif

#if HAVE_DLFCN_H
#include <dlfcn.h>

void
dload_initialize ()
{
}

char *
dload_error (void)
{
  return (void *) dlerror ();
}

void *
dload_load (char *name)
{
  return dlopen (name, RTLD_NOW);
}

void *
dload_lookup (void *handle, char *name)
{
  return dlsym (handle, name);
}
#endif
