/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: extension.m,v 1.32 1998/01/19 13:28:45 tiggr Exp $  */

#import "tr.h"
#import "tom/trt.h"

id <TLString>
type_encoding_of_type (id t)
{
  id n = [t symbolp] ? [(TLSymbol *) t symbolName] : nil;

  /* XXX This is too ugly to even consider.  */
  return (!n ? @"TRT_TE_REFERENCE"
	  : [n equal: @"void"] ? @"TRT_TE_VOID"
	  : [n equal: @"boolean"] ? @"TRT_TE_BOOLEAN"
	  : [n equal: @"byte"] ? @"TRT_TE_BYTE"
	  : [n equal: @"char"] ? @"TRT_TE_CHAR"
	  : [n equal: @"int"] ? @"TRT_TE_INT"
	  : [n equal: @"long"] ? @"TRT_TE_LONG"
	  : [n equal: @"float"] ? @"TRT_TE_FLOAT"
	  : [n equal: @"double"] ? @"TRT_TE_DOUBLE"
	  : [n equal: @"pointer"] ? @"TRT_TE_POINTER"
	  : [n equal: @"selector"] ? @"TRT_TE_SELECTOR"
	  : [n equal: @"reference"] ? @"TRT_TE_REFERENCE"
	  : (id) formac (nil, @"***unknown: %@***", n));
}

id <TLString>
c_type_for_tom_type (id t)
{
  id n = [t symbolp] ? [t symbolName] : nil;

  /* XXX This is too ugly to even consider.  */
  return (!n ? @"tom_object"
	  : [n equal: @"void"] ? @"void"
	  : [n equal: @"boolean"] ? @"tom_byte"
	  : [n equal: @"byte"] ? @"tom_byte"
	  : [n equal: @"char"] ? @"tom_char"
	  : [n equal: @"int"] ? @"tom_int"
	  : [n equal: @"long"] ? @"tom_long"
	  : [n equal: @"float"] ? @"tom_float"
	  : [n equal: @"double"] ? @"tom_double"
	  : [n equal: @"pointer"] ? @"void *"
	  : [n equal: @"selector"] ? @"selector"
	  : [n equal: @"reference"] ? @"tom_object"
	  : (id) formac (nil, @"***unknown: %@***", n));
}

int
thread_local_offset_for_type (id t)
{
  id n = [t symbolp] ? [(TLSymbol *) t symbolName] : nil;
  int r, size = sizeof (void *);

  if (n)
    size = ([n equal: @"boolean"] ? 1
	    : [n equal: @"byte"] ? 1
	    : [n equal: @"char"] ? 2
	    : [n equal: @"int"] ? 4
	    : [n equal: @"long"] ? 8
	    : [n equal: @"float"] ? 4
	    : [n equal: @"double"] ? 8 : size);

  r = next_thread_local_offset = ((next_thread_local_offset + size - 1)
				  & ~(size - 1));
  next_thread_local_offset += size;
  return r;
}

@implementation LTIExtension (tr)

-(TLCons *) addExtensionDescriptions: (TLCons *) l
{
  return l ? [l nconc: CONS (self, nil)] : CONS (self, nil);
}

-(TLCons *) addReferenceVariables: (TLCons *) l
{
  id <TLEnumerator> e = [structure variables];
  LTTVariable *v;

  while ((v = [e nextObject]))
    {
      id type = [v type];

      if ([type isKindOf: [CO_LTIMeta class]])
	if (l)
	  [l nconc: CONS (v, nil)];
	else
	  l = CONS (v, nil);
    }

  return l;
}

-(TLCons *) compile: (id) s
	       unit: (LTTUnit *) u
      extensionList: (TLCons *) exts
{
  if ([[structure container] unit] == u)
    {
      formac (s, @"&%@,\n", [structure outputExtensionDescriptionName]);
      exts = CONS (structure, exts);
    }
  return exts;
}

-(id) compileDeclaration: (id) s
{
  if (single_unit)
    [self loadIfNeeded];

  if (output_var_decl)
    s = formac (s, @"struct %@ %@;\n", [structure outputExtensionStructName],
		[structure outputExtensionFieldName]);
  return s;
}

-(id) compileDefinition: (id) s
		context: (LTTMeta *) m
		  poser: (LTTMeta *) p
		   mark: (int) k
{
  if (mark == k || ![structure hasVariables])
    return s;
  mark = k;

  s = formac (s, @"{");

  if ([structure meta] == ltt_class_state && [structure isMainExtension])
    {
      LTTInstance *pi = [(LTTClass *) p instance];
      int num_supers = [pi numStateSupers] + [pi numBehaviourSupers];
      int num_subs= [pi numStateSubs] + [pi numBehaviourSubs];

      /* isa, asi */
      formac (s, @"&%@, %@", [m metaDefinitionName], @"TGC_ASI_CLASS_P");

      /* mdt, eot */
      if (app_unit)
	formac (s, @",\n{0, 0");
      else
	formac (s, @",\n{&%@%@, &%@%@", TO_MDT_PREFIX, [pi outputTypeName],
		TO_EOT_PREFIX, [pi outputTypeName]);

      /* num_instances */
      formac (s, @",\n0");

      /* name */
      {
	id <TLString> name = [[m lttName] internal];
	formac (s, @",\n{%#, %d}", name, [name length]);
      }

      /* rvo */
      if (app_unit)
	formac (s, @",\n0");
      else
	formac (s, @",\n&%@%@", TO_META_RVO_PREFIX, [pi outputTypeName]);

      /* instance_size */
      if (app_unit || [[pi semantics] haveDeferredMethods])
	formac (s, @",\n0");
      else
	formac (s, @",\nsizeof (struct %@)", [pi outputTypeName]);

      /* initial_asi, class_reference */
      formac (s, @",\n%@,\n(struct trt_class **) &%@",
	      default_asi_value, [m referenceName]);

      /* extensions */
      if (app_unit)
	formac (s, @",\n0");
      else
	formac (s, @",\n&%@", [pi extensionsDescriptionName]);

      /* subs */
      if (num_subs && !app_unit)
	formac (s, @",\n&_subs%@", [pi metaDefinitionName]);
      else
	formac (s, @",\n0");

      /* supers */
      if (num_supers && !app_unit)
	formac (s, @",\n&_supers%@", [pi metaDefinitionName]);
      else
	formac (s, @",\n0");

      /* poser */
      formac (s, @",\n0");

      /* state_extensions */
      formac (s, @",\n0");

      /* mark */
      formac (s, @",\n0");

      /* mark2 */
      formac (s, @",\n0");

      formac (s, @"\n}");
    }

  return formac (s, @"},\n");
}

-(id) declareEID: (id) s
{
  /* Declare our extension identity.  */
  s = formac (s, @"unsigned int %@%@;\n",
	      [structure outputExtensionIdentityName],
	      app_unit ? @"" : (id) formac (nil, @" = %d", eid));
  return s;
}

-(id) compileExtensionDescription: (id) s
{
  id <TLEnumerator> e;
  LTIVariable *v;
  int num_vars;
  LTTMeta *sm;

  if (defined)
    return s;
  defined = 1;
  if (single_unit && single_unit != [[structure container] unit])
    return s;

  num_vars = [structure numVariables];
  sm = [structure meta];

  /* XXX Hack.  */
#ifndef GLOBAL_RESOLUTION
#define GLOBAL_RESOLUTION 0
#endif

  /* Output the static variables.  */
  e = [structure staticVariables];
  if (e)
    while ((v = [e nextObject]))
      if ([v isLocal])
	s = formac (s, @"int _tlo_%@ = %d;\n", [v staticName],
		    thread_local_offset_for_type ([v type]));
      else
	s = formac (s, @"%@ %@;\n", c_type_for_tom_type ([v type]),
		    [v staticName]);
  
  if (!GLOBAL_RESOLUTION
      && !(sm == ltt_instance_any || sm == ltt_instance_all
	   || sm == ltt_class_any || sm == ltt_class_all))
    {
      /* Describe ourselves.  */
      s = formac (s, @"extern struct trtd_extension %@;\n",
		  [structure outputExtensionDescriptionName]);

      /* Iff we're resolving statically, define our eid (as in `int my_eid
	 = 23'), which will `override' the common declaration of the eid
	 declared in the extension's object file.  */
      if (!app_unit && num_vars)
	s = [self declareEID: s];
    }
  else
    {
      id <TLString> name = ([structure lttName]
			    ? [[structure lttName] internal] : nil);
      int num_statics = 0, num_methods = 0;
      TLMutableString *buf = nil;
      id static_desc = @"0";
      LTIMethod *m;
      int i, n;

      /* Output information on the static variables.  */
      e = [structure staticVariables];
      if (e)
	{
	  static_desc = formac (nil, @"_static%@",
				[structure outputExtensionDescriptionName]);
	  s = formac (s, @"struct trtd_static_var %@[] = {", static_desc);

	  while ((v = [e nextObject]))
	    {
	      id <TLString> vn = [[v lttName] internal];
	      BOOL th_local = [v isLocal];

	      num_statics++;
	      formac (s, @"\n{{{%#, %d}, %@}, &%@%@, %d},",
		      vn, [vn length], type_encoding_of_type ([v type]),
		      th_local ? @"_tlo_" : @"", [v staticName], th_local);
	    }
	  formac (s, @"};\n");
	}

      /* Output information on each method.  */
      for (i = 0, n = [methods length]; i < n; i++)
	{
	  m = [methods _elementAtIndex: i];
	  if (!num_methods)
	    {
	      buf = [TLMutableString mutableString];
	      formac (buf, @"\nstatic struct trtd_methods trtd_methods_%@ "
		      @"= {%d, {", [[structure lttName] external],
		      [methods length]);
	    }
	  if (app_unit && [m methodName])
	    [m compileDeclaration: s];
	  formac (buf, @"%@{%@, (void *) &%@, &%@}",
		  num_methods ? @",\n" : @"\n",
		  [m methodName] ? [m methodName] : @"0",
		  [[[m meta] structure] metaDefinitionName],
		  [[[m selector] structure] outputDefinitionName]);
	  num_methods++;
	}
      if (num_methods)
	formac (s, @"%@\n}};\n", buf);

      if (num_vars)
	s = [self declareEID: s];

      /* Indicate the supers inherited through us.  */
      if ([metas length])
	{
	  LTIMeta *m;

	  formac (s, @"static struct trt_metas metas_%@ = {{%d, 0}, {",
		  [[structure lttName] external], [metas length]);
	  e = [metas enumerator];

	  while ((m = [e nextObject]))
	    formac (s, @"\n(void *) &%@,",
		    [[m structure] metaDefinitionName]);
	  formac (s, @"\n}};\n");
	}

      /* Describe ourselves.  */
      s = formac (s, @"struct trtd_extension %@ = {\n",
		  [structure outputExtensionDescriptionName]);

      /* meta */
      formac (s, @"(void *) &%@", [[structure meta] metaDefinitionName]);

      /* extension_object */
      formac (s, @",\n0");

      /* eid_in_a_global */
      if (num_vars)
	formac (s, @",\n&%@", [structure outputExtensionIdentityName]);
      else
	formac (s, @",\n0");

      /* name */
      if (name)
	formac (s, @",\n{%#, %d}", name, [name length]);
      else
	formac (s, @",\n{0, 0}");

      /* methods */
      if (num_methods)
	formac (s, @",\n&trtd_methods_%@", [[structure lttName] external]);
      else
	formac (s, @",\n0");

      /* supers */
      if ([metas length])
	formac (s, @",\n&metas_%@", [[structure lttName] external]);
      else
	formac (s, @",\n0");

      /* state_size */
      if (num_vars)
	formac (s, @",\nsizeof (struct %@)",
		[structure outputExtensionStructName]);
      else
	formac (s, @",\n0");

      /* state_align */
      formac (s, @",\n%d", alignment);

      /* statics */
      formac (s, @",\n%@", static_desc);

      /* num_statics */
      formac (s, @",\n%d", num_statics);

      /* num_vars */
      formac (s, @",\n%d", num_vars);

      /* vars  */
      formac (s, @",\n{");

      if (num_vars)
	{
	  id <TLEnumerator> e = [structure variables];
	  BOOL first = YES;

	  while ((v = [e nextObject]))
	    {
	      id <TLString> name = [[v lttName] internal];

	      if (first)
		first = NO;
	      else
		formac (s, @",");
	      formac (s, @"\n{{{%#, %d}, %@}, ", name, [name length],
		      type_encoding_of_type ([v type]));
	      formac (s, @"(char *) &((struct %@ *) 0)->%@ - (char *) 0}",
		      [structure outputExtensionStructName],
		      [v outputName]);
	    }
	}
      formac (s, @"\n}};\n");
    }
  return s;
}

-(id) compileTypeDeclaration: (id) s
{
  id qqq = [CO_LTIMeta class];
  id <TLEnumerator> e;
  LTIVariable *v;

  if (declared)
    return s;
  declared = 1;

  if (single_unit)
    [self loadIfNeeded];

  {
    LTTUnit *u = [[structure container] unit];

    if (single_unit && single_unit != u
	&& !(single_tom_unit && u == ltt_builtin_unit))
      return s;
  }

  if (constants)
    {
      id <TLEnumerator> e = [constants enumerator];
      TLString *key;
      id value;

      while ((key = [e nextObject]))
	{
	  value = [constants objectForKey: key]; 
	  formac (s, @"#define %@_%@ %#\n", [[structure lttName] external],
		  quote (key), value);
	}
    }

  if ([structure hasVariables])
    {
      e = [structure variables];
      while ((v = [e nextObject]))
	{
	  LTIMeta *m = [v type];

	  if ([m isKindOf: qqq])
	    s = [m compileReferenceDeclaration: s];
	}
    }

  e = [structure staticVariables];
  if (e)
    while ((v = [e nextObject]))
      if ([v isLocal])
	s = formac (s, @"extern int _tlo_%@;\n", [v staticName]);
      else
	s = formac (s, @"extern %@ %@;\n", c_type_for_tom_type ([v type]),
		    [v staticName]);

  s = formac (s, @"extern unsigned int %@;\n",
	      [structure outputExtensionIdentityName]);

  if (output_var_decl)
    formac (s, @"struct %@ %@;\n", [structure outputExtensionStructName],
	    output_var_decl);

  return s;
}

-(BOOL) hasPointers
{
  id qqq = [CO_LTIMeta class];
  id <TLEnumerator> e;
  LTIVariable *v;
  static id Qpointer;

  if (!Qpointer)
    Qpointer = [TLSymbol symbolWithName: @"pointer"];
  
  if ([structure hasVariables])
    {
      e = [structure variables];
      while ((v = [e nextObject]))
	{
	  id m = [v type];

	  if (m == Qpointer)
	    return YES;
	}
    }

  e = [structure staticVariables];
  if (e)
    while ((v = [e nextObject]))
      {
	id m = [v type];

	if (![m isKindOf: qqq] && ![m compare: @"pointer"])
	  return YES;
      }

  return NO;
}

-(void) loadIfNeeded
{
  LTTFile *container = [structure container];
  if (![container loadedInfo])
    lti_load_file_info (container);
}

@end
