/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTIExtensions.h,v 1.23 1998/01/05 01:15:36 tiggr Exp $  */

#import "lti/lti.h"

@interface LTIClass (tr)

-(id) compileDefinition: (id) stream;

@end

@interface LTIExtension (tr)

-(TLCons *) addExtensionDescriptions: (TLCons *) l;

-(TLCons *) addReferenceVariables: (TLCons *) l;

-(TLCons *) compile: (id) stream
	       unit: (LTTUnit *) u
      extensionList: (TLCons *) exts;

-(id) compileDeclaration: (id) stream;

-(id) compileDefinition: (id) s
		context: (LTTMeta *) m
		  poser: (LTTMeta *) p
		   mark: (int) k;

-(id) compileExtensionDescription: (id) s;

-(id) compileTypeDeclaration: (id) stream;

-(BOOL) hasPointers;

-(void) loadIfNeeded;

@end

@interface LTIMeta (tr)

-(TLCons *) addExtensionDescriptions: (TLCons *) l mark: (int) k;

-(TLCons *) addReferenceVariables: (TLCons *) l mark: (int) k;

-(id) compileReferenceDeclaration: (id) s;

-(void) dontCompileReferenceDeclaration;

-(id) compileDeclaration: (id) stream;

/* Compile the extension list of the unit U to the STREAM.  The extensions
   are output in a topological sorted order of the inheritance graph.  */
-(TLCons *) compile: (id) stream
	       unit: (LTTUnit *) u
      extensionList: (TLCons *) exts
	       mark: (int) k;

-(id) compileExtensionsDeclaration: (id) stream mark: (int) k;

-(id) compileDefinition: (id) stream;

-(id) compileDefinition: (id) s
		context: (LTTMeta *) context
		  poser: (LTTMeta *) poser
		   mark: (int) k;

-(id) compileBuckets: (id) stream;

-(id) compileTables: (id) stream;

-(BOOL) hasPointers;

-(BOOL) hasPointers: (int) mark;

@end

@interface LTIMethod (tr)

-(id) compileDeclaration: (id) stream;

@end

@interface LTISelector (tr)

-(id) compileDeclaration: (id) stream;

-(id) compileDefinition: (id) stream;

@end

@interface LTIStringCST (tr)

-(id) compileDefinition: (id) stream;

-(id) compileReference: (id) stream;

@end

@interface LTTSelArgTypes (tr)

-(id) compileDeclaration: (id) stream;

-(id) compileDefinition: (id) stream;

@end
