/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMTop.m,v 1.27 1998/01/05 01:13:53 tiggr Exp $  */

#import "OTMTop.h"

/* The last line number output.  */
int last_line_number;

/* The last name output.  */
id last_file_name;

@implementation OTMTop

-(id) actualSelf: (id) context
{
  return self;
}

-(id) actualSelfNonPosing: (id) context
{
  return self;
}

-(int) compare: (id) o
{
  /* Compare for the purpose of sets and the like is `eq' testing.  */
  return !(o == self);
}

-(BOOL) constantp
{
  return NO;
}

-(BOOL) declaredp
{
  return declared;
}

-(BOOL) declarationOutputp
{
  return !!Q_OUTPUT_DECL (qualifiers);
}

-(BOOL) deferredp
{
  return !!Q_DEFERRED (qualifiers);
}

-(BOOL) definedp
{
  return defined;
}

-(void) description: (id <TLMutableStream>) stream
{
  formac (stream, @" %@:%d", filename, line_number);
}

-(id) elaborate
{
  return self;
}

-(void) gcReference
{
  MARK (filename);
}

-init
{
  return [self initWithLine: current_line inFile: current_filename];
}

-initWithLine: (int) line inFile: (id <TLString>) name
{
  filename = name;
  line_number = line;

  return self;
}

-(int) line
{
  return line_number;
}

-(id <TLString>) filename
{
  return filename;
}

-(id <TLString>) nl
{
  static int num_indents;
  static id *indents;

  if (!flag_readable)
    {
      if (line_number != last_line_number || last_file_name != filename)
	[self outputLineDirective];
      return @" ";
    }

  if (indent_level >= num_indents)
    {
      indents = xrealloc (indents, (1 + indent_level) * sizeof (*indents));
      BZERO ((void *) (indents + num_indents),
	     (1 + indent_level - num_indents) * sizeof (*indents));
      num_indents = 1 + indent_level;
    }

  if (!indents[indent_level])
    {
      static char s[] = "                                                     ";
      int i = sizeof (s) - 1 - 2 * indent_level;

      if (i < 0)
	i = 0;
      indents[indent_level] = [CO_TLString stringWithFormat: @"\n%s", s + i];
    }

  return indents[indent_level];
}

-(id <TLString>) nlPlain
{
  if (flag_readable)
    return [self nl];
  return @" ";
}

-(void) outputLineDirective
{
  if (last_file_name == filename
      && line_number > last_line_number 
      && line_number < last_line_number + 3)
    while (last_line_number != line_number)
      {
	last_line_number++;
	formac (of, @"\n");
      }
  else if (line_number != last_line_number || last_file_name != filename)
    {
      last_file_name = filename;
      last_line_number = line_number;
      if (line_number)
	formac (of, @"\n# %d %#\n", line_number, filename);
    }
}

-(void) setLine: (int) line
{
  line_number = line;
}

-(void) print: (id <TLMutableStream>) stream quoted: (BOOL) qp
{
  const char *s = class_get_class_name (isa);

  formac (stream, @"(%s %x", s, self);
  [self description: stream];
  [@")" print: stream quoted: NO];
}

-(id) precompile
{
  return self;
}

-(otm_qualifiers) protection
{
  return Q_PROTECTION (qualifiers);
}

-(otm_qualifiers) qualifiers
{
  return qualifiers;
}

-(otm_qualifiers) redo
{
  return Q_REDO (qualifiers);
}

-(void) refreshLocation
{
  filename = current_filename;
  line_number = current_line;
}

-(id) getLocationFrom: (OTMTop *) other
{
  filename = [other filename];
  line_number = [other line];
  return self;
}

-(id) resolveInContext: (OTMMeta *) current
{
  return self;
}

-(void) setDeclarationOutputP: (BOOL) ynp
{
  qualifiers = Q_SET_OUTPUT_DECL (qualifiers, ynp ? OQ_OUTPUT_DECL : 0);
}

-(void) setDeclared: (BOOL) ynp
{
  declared = !!ynp;
}

-(void) setDefined: (BOOL) ynp
{
  defined = !!ynp;
}

-(void) setDeferred: (BOOL) ynp
{
  qualifiers = Q_SET_DEFERRED (qualifiers, ynp ? OQ_DEFERRED : 0);
}

-(void) setProtection: (otm_qualifiers) prot
{
  qualifiers = Q_SET_PROTECTION (qualifiers, prot);
}

-(void) setQualifiers: (otm_qualifiers) q
{
  qualifiers = q;
}

-(void) setRedo: (otm_qualifiers) redo
{
  qualifiers = Q_SET_REDO (qualifiers, redo);
}

-(void) setStatic: (BOOL) ynp
{
  qualifiers = Q_SET_STATIC (qualifiers, ynp ? OQ_STATIC : 0);
}

-(BOOL) staticp
{
  return !!Q_STATIC (qualifiers);
}

@end
