/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996-1998 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMInvocation.m,v 1.35 1998/01/05 01:13:10 tiggr Exp $  */

#define OTMINVOCATION_DECLARE_PRIVATE_METHODS
#import "OTMInvocation.h"
#import "OTMBasic.h"
#import "OTMBuiltinMethod.h"
#import "OTMCompound.h"
#import "OTMDynamicType.h"
#import "OTMITE.h"
#import "OTMMeta.h"
#import "OTMNumberCST.h"
#import "OTMTuple.h"
#import "OTMVariable.h"

@implementation OTMInvocation

+(OTMInvocation *) invocationWithReceiver: (OTMExpr *) r
				    super: (OTMMeta *) s
				   method: (OTMMethod *) m
				arguments: (TLVector *) a
			       returnType: (OTMType *) t
				inContext: (id) c
{
  return [[self gcAlloc] initWithReceiver: r super: s method: m
			 arguments: a returnType: t inContext: c];
}

-(TLVector *) arguments
{
  return arguments;
}

-(void) compile
{
  int i, n = [arguments length];

  [self nl];
  [receiver compile];

  for (i = 0; i < n; i++)
    {
      OTMExpr *p = [arguments _elementAtIndex: i];

      [p compile];
    }  
}

-(void) compileAssignmentToTuple: (OTMTuple *) lhs
{
  OTMExpr *e = [[lhs elements] _elementAtIndex: 0];

  formac (of, @"%@%@ = %@;", [self nl], [(OTMVariable *) e outputReference],
	  [method resultOfInvocation: self toTuple: lhs]);
}

-(void) compileStatement
{
  [self compile];
  formac (of, @"%@%@;", [self nl], [method resultOfInvocation: self]);
}

-(id) conditionCopyFor: (OTMCustomMethod *) method
{
  internal (@"[OTMInvocation conditionCopyFor:]");
  return NULL;
}

-(id) elaborate
{
  int i, n = [arguments length];
  int saved_line = current_line;
  id result;

  current_line = line_number;

  if ([method isKindOf: [CO_OTMBuiltinMethod self]])
    {
      enum builtin_operator op = [(OTMBuiltinMethod *) method operator];
      
      if (op == BO_SC_AND || op == BO_SC_OR || op == BO_IMPLIES)
	{
	  id previous_compound = current_compound;
	  OTMExpr *left = [arguments _elementAtIndex: 0];
	  OTMExpr *right = [arguments _elementAtIndex: 1];
	  OTMExpr *result;
	  OTMITE *ite;

	  current_line = line_number;
	  result = temp_something_with_type ([left type], 1);
	  ite = [CO_OTMITE iteWithCondition: [left elaborate]];
	  current_compound = [CO_OTMCompound compoundWithContainer:
			      previous_compound];

	  if (op == BO_SC_AND)
	    {
	      emit_assignment (result, [right elaborate]);
	      [ite setThen: current_compound];

	      current_compound = [CO_OTMCompound compoundWithContainer:
					      previous_compound];
	      emit_assignment (result, [CO_OTMNumberCST numberWithValue: @"0"
							type: [left type]]);
	    }
	  else if (op == BO_SC_OR)
	    {
	      emit_assignment (result, [CO_OTMNumberCST numberWithValue: @"1"
							type: [left type]]);
	      [ite setThen: current_compound];

	      current_compound = [CO_OTMCompound compoundWithContainer:
					      previous_compound];
	      emit_assignment (result, [right elaborate]);
	    }
	  else if (op == BO_IMPLIES)
	    {
	      emit_assignment (result, [right elaborate]);
	      [ite setThen: current_compound];

	      current_compound = [CO_OTMCompound compoundWithContainer:
					      previous_compound];
	      emit_assignment (result, [CO_OTMNumberCST numberWithValue: @"1"
							type: [left type]]);
	    }

	  [ite setElse: current_compound];

	  current_compound = previous_compound;
	  emit_statement (ite);
	  return result;
	}
    }

  receiver = [receiver elaborate];

  for (i = 0; i < n; i++)
    {
      OTMExpr *p = [arguments _elementAtIndex: i];
      OTMExpr *o = [p elaborate];

      if (o != p)
	[arguments _replaceElementAtIndex: i by: o];
    }

  if ([method dynamicTyped])
    [CO_OTMDynamicType addInvocation: self
		       toDynamicSelector: [method selector]];

  if ([type matches: basic_type[BT_VOID]])
    return self;

  result = emit_assignment (temp_something_with_type (type, 1), self);

  current_line = saved_line;
  return result;
}

-(void) gcReference
{
  MARK (context);
  MARK (method);
  MARK (receiver);
  MARK (the_super);
  MARK (arguments);

  [super gcReference];
}

-(id) initWithReceiver: (OTMExpr *) r
		 super: (OTMMeta *) s
		method: (OTMMethod *) m
	     arguments: (TLVector *) a
	    returnType: (OTMType *) t
	     inContext: (id) c
{
  if (![super initWithType: t])
    return nil;

  context = c;
  method = m;
  receiver = r;
  arguments = a;
  the_super = s;

  return self;
}

-(OTMMethod *) method
{
  return method;
}

-(id <TLString>) exprName
{
  return @"invocation";
}

-(id) precompile
{
  int i, n = [arguments length];

  receiver = [receiver precompile];
  method = [method precompile];

  if ([method dynamicTyped])
    [[[CO_OTMDynamicType selectorForInvocation: self
		      ofDynamicSelector: [method selector]]
	       semantics]
	 compileDeclaration];

  for (i = 0; i < n; i++)
    {
      id p = [arguments _elementAtIndex: i];
      id o = [p precompile];

      if (o != p)
	[arguments _replaceElementAtIndex: i by: o];
    }

  if (the_super)
    {
      [[[receiver type] actualSelf: [current_either semantics]]
       compileSuperReferenceDeclaration: the_super];
    }

  return [super precompile];
}

-(OTMExpr *) receiver
{
  return receiver;
}

-(id <TLString>) result
{
  return [method resultOfInvocation: self];
}

-(OTMMeta *) super
{
  return the_super;
}

@end
