/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMInvocation.h,v 1.10 1998/01/05 01:13:08 tiggr Exp $  */

#import "OTMExpr.h"

@class OTMMethod;

@interface OTMInvocation: OTMExpr
{
  /* The compound containing this expression.  */
  id context;

  /* The method being invoked.  */
  id method;

  /* The receiver.  */
  OTMExpr *receiver;

  /* The super, if any.  */
  OTMMeta *the_super;

  /* The arguments.  */
  TLVector *arguments;
}

+(OTMInvocation *) invocationWithReceiver: (OTMExpr *) rcv
				    super: (OTMMeta *) the_super
				   method: (OTMMethod *) method
				arguments: (TLVector *) args
			       returnType: (OTMType *) return_type
				inContext: (id) compound;

-(TLVector *) arguments;
-(OTMExpr *) receiver;
-(OTMMethod *) method;
-(OTMMeta *) super;

#ifdef OTMINVOCATION_DECLARE_PRIVATE_METHODS

-(id) initWithReceiver: (OTMExpr *) rcv
		 super: (OTMMeta *) the_super
		method: (OTMMethod *) method
	     arguments: (TLVector *) args
	    returnType: (OTMType *) return_type
	     inContext: (id) compound;

#endif

@end
